/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast.geom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.recast4j.recast.AreaModification;
import org.recast4j.recast.ConvexVolume;
import org.recast4j.recast.RecastVectors;
import org.recast4j.recast.geom.InputGeomProvider;
import org.recast4j.recast.geom.TriMesh;

public class SimpleInputGeomProvider
implements InputGeomProvider {
    public final float[] vertices;
    public final int[] faces;
    public final float[] normals;
    final float[] bmin;
    final float[] bmax;
    final List<ConvexVolume> volumes = new ArrayList<ConvexVolume>();

    public SimpleInputGeomProvider(List<Float> vertexPositions, List<Integer> meshFaces) {
        this(SimpleInputGeomProvider.mapVertices(vertexPositions), SimpleInputGeomProvider.mapFaces(meshFaces));
    }

    private static int[] mapFaces(List<Integer> meshFaces) {
        int[] faces = new int[meshFaces.size()];
        for (int i = 0; i < faces.length; ++i) {
            faces[i] = meshFaces.get(i);
        }
        return faces;
    }

    private static float[] mapVertices(List<Float> vertexPositions) {
        float[] vertices = new float[vertexPositions.size()];
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = vertexPositions.get(i).floatValue();
        }
        return vertices;
    }

    public SimpleInputGeomProvider(float[] vertices, int[] faces) {
        this.vertices = vertices;
        this.faces = faces;
        this.normals = new float[faces.length];
        this.calculateNormals();
        this.bmin = new float[3];
        this.bmax = new float[3];
        RecastVectors.copy(this.bmin, vertices, 0);
        RecastVectors.copy(this.bmax, vertices, 0);
        for (int i = 1; i < vertices.length / 3; ++i) {
            RecastVectors.min(this.bmin, vertices, i * 3);
            RecastVectors.max(this.bmax, vertices, i * 3);
        }
    }

    @Override
    public float[] getMeshBoundsMin() {
        return this.bmin;
    }

    @Override
    public float[] getMeshBoundsMax() {
        return this.bmax;
    }

    public List<ConvexVolume> convexVolumes() {
        return this.volumes;
    }

    public void addConvexVolume(float[] verts, float minh, float maxh, AreaModification areaMod) {
        ConvexVolume vol = new ConvexVolume();
        vol.hmin = minh;
        vol.hmax = maxh;
        vol.verts = verts;
        vol.areaMod = areaMod;
        this.volumes.add(vol);
    }

    @Override
    public Iterable<TriMesh> meshes() {
        return Collections.singletonList(new TriMesh(this.vertices, this.faces));
    }

    public void calculateNormals() {
        for (int i = 0; i < this.faces.length; i += 3) {
            int v0 = this.faces[i] * 3;
            int v1 = this.faces[i + 1] * 3;
            int v2 = this.faces[i + 2] * 3;
            float[] e0 = new float[3];
            float[] e1 = new float[3];
            for (int j = 0; j < 3; ++j) {
                e0[j] = this.vertices[v1 + j] - this.vertices[v0 + j];
                e1[j] = this.vertices[v2 + j] - this.vertices[v0 + j];
            }
            this.normals[i] = e0[1] * e1[2] - e0[2] * e1[1];
            this.normals[i + 1] = e0[2] * e1[0] - e0[0] * e1[2];
            this.normals[i + 2] = e0[0] * e1[1] - e0[1] * e1[0];
            float d = (float)Math.sqrt(this.normals[i] * this.normals[i] + this.normals[i + 1] * this.normals[i + 1] + this.normals[i + 2] * this.normals[i + 2]);
            if (!(d > 0.0f)) continue;
            d = 1.0f / d;
            int n = i;
            this.normals[n] = this.normals[n] * d;
            int n2 = i + 1;
            this.normals[n2] = this.normals[n2] * d;
            int n3 = i + 2;
            this.normals[n3] = this.normals[n3] * d;
        }
    }
}

