/*
 * Decompiled with CFR 0.152.
 */
package org.recast4j.recast.geom;

import java.util.Collections;
import java.util.List;
import org.recast4j.recast.ConvexVolume;
import org.recast4j.recast.RecastVectors;
import org.recast4j.recast.geom.InputGeomProvider;
import org.recast4j.recast.geom.TriMesh;

public class SingleTrimeshInputGeomProvider
implements InputGeomProvider {
    private final float[] bmin = new float[3];
    private final float[] bmax = new float[3];
    private final List<TriMesh> meshes;

    public SingleTrimeshInputGeomProvider(float[] vertices, int[] faces) {
        RecastVectors.copy(this.bmin, vertices, 0);
        RecastVectors.copy(this.bmax, vertices, 0);
        for (int i = 1; i < vertices.length / 3; ++i) {
            RecastVectors.min(this.bmin, vertices, i * 3);
            RecastVectors.max(this.bmax, vertices, i * 3);
        }
        this.meshes = Collections.singletonList(new TriMesh(vertices, faces));
    }

    @Override
    public float[] getMeshBoundsMin() {
        return this.bmin;
    }

    @Override
    public float[] getMeshBoundsMax() {
        return this.bmax;
    }

    @Override
    public Iterable<TriMesh> meshes() {
        return this.meshes;
    }

    @Override
    public Iterable<ConvexVolume> convexVolumes() {
        return Collections.emptyList();
    }
}

