/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.flv.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AudioCodec;
import org.red5.codec.VideoCodec;
import org.red5.io.IStreamableFile;
import org.red5.io.ITag;
import org.red5.io.ITagWriter;
import org.red5.io.amf.Output;
import org.red5.io.flv.FLVHeader;
import org.red5.io.flv.IFLV;
import org.red5.io.flv.impl.FLVReader;
import org.red5.io.utils.IOUtils;
import org.red5.media.processor.IPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLVWriter
implements ITagWriter {
    private static Logger log = LoggerFactory.getLogger(FLVWriter.class);
    private static final int HEADER_LENGTH = 9;
    private static final int TAG_HEADER_LENGTH = 11;
    private static final int META_POSITION = 13;
    private static final byte[] DEFAULT_STREAM_ID = new byte[]{0, 0, 0};
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private IFLV flv;
    private volatile long bytesWritten;
    private int offset;
    private int timeOffset;
    private volatile int audioCodecId = -1;
    private volatile int videoCodecId = -1;
    private AtomicBoolean audioConfigWritten = new AtomicBoolean(false);
    private AtomicBoolean videoConfigWritten = new AtomicBoolean(false);
    private volatile int soundRate;
    private volatile int soundSize;
    private volatile boolean soundType;
    private boolean append;
    private int duration;
    private int videoDataSize = 0;
    private int audioDataSize = 0;
    private RandomAccessFile file;
    private RandomAccessFile dataFile;
    private String filePath;
    private final Semaphore lock = new Semaphore(1, true);
    private volatile int lastTagSize;
    private LinkedList<IPostProcessor> postProcessors;
    private AtomicBoolean finalized = new AtomicBoolean(false);
    private String recordedDate;

    public FLVWriter(String filePath) {
        this.filePath = filePath;
        log.debug("Writing to: {}", (Object)filePath);
        try {
            File dat = new File(filePath + ".ser");
            this.dataFile = new RandomAccessFile(dat, "rw");
        }
        catch (Exception e) {
            log.error("Failed to create FLV writer", (Throwable)e);
        }
        finally {
            this.recordedDate = ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT);
        }
    }

    public FLVWriter(File file, boolean append) {
        this.filePath = file.getAbsolutePath();
        log.debug("Writing to: {}", (Object)this.filePath);
        try {
            this.append = append;
            if (append) {
                this.duration = this.timeOffset = FLVReader.getDuration(file);
                log.debug("Duration: {}", (Object)this.timeOffset);
                this.dataFile = new RandomAccessFile(file, "rw");
                if (!(file.exists() && file.canRead() && file.canWrite())) {
                    log.warn("File does not exist or cannot be accessed");
                } else {
                    log.trace("File size: {} last modified: {}", (Object)file.length(), (Object)file.lastModified());
                    this.bytesWritten = file.length();
                }
                if (this.duration == 0) {
                    this.dataFile.seek(13L);
                }
            } else {
                File dat = new File(this.filePath + ".ser");
                if (dat.exists()) {
                    dat.delete();
                    dat.createNewFile();
                }
                this.dataFile = new RandomAccessFile(dat, "rw");
                this.recordedDate = ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT);
            }
        }
        catch (Exception e) {
            log.error("Failed to create FLV writer", (Throwable)e);
        }
    }

    @Override
    public void writeHeader() throws IOException {
        FLVHeader flvHeader = new FLVHeader();
        flvHeader.setFlagAudio(this.audioCodecId != -1);
        flvHeader.setFlagVideo(this.videoCodecId != -1);
        ByteBuffer header = ByteBuffer.allocate(13);
        flvHeader.write(header);
        this.file = new RandomAccessFile(this.filePath, "rw");
        this.file.setLength(13L);
        if (header.hasArray()) {
            log.debug("Header bytebuffer has a backing array");
            this.file.write(header.array());
        } else {
            log.debug("Header bytebuffer does not have a backing array");
            byte[] tmp = new byte[13];
            header.get(tmp);
            this.file.write(tmp);
        }
        this.bytesWritten = this.file.length();
        assert (13L - this.bytesWritten == 0L);
        log.debug("Header size: {} bytes written: {}", (Object)13, (Object)this.bytesWritten);
        header.clear();
        header = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean writeTag(ITag tag) throws IOException {
        boolean onWrittenSetVideoFlag = false;
        boolean onWrittenSetAudioFlag = false;
        try {
            block47: {
                byte[] bodyBuf;
                int timestamp;
                ByteBuffer tagBuffer;
                int totalTagSize;
                byte dataType;
                int bodySize;
                long prevBytesWritten;
                block46: {
                    int id2;
                    block48: {
                        block49: {
                            this.lock.acquire();
                            log.trace("writeTag: {}", (Object)tag);
                            prevBytesWritten = this.bytesWritten;
                            log.trace("Previous bytes written: {}", (Object)prevBytesWritten);
                            bodySize = tag.getBodySize();
                            log.debug("Tag body size: {}", (Object)bodySize);
                            int previousTagSize = tag.getPreviousTagSize();
                            if (previousTagSize != this.lastTagSize) {
                                log.debug("Incoming previous tag size: {} does not match current value for last tag size: {}", (Object)previousTagSize, (Object)this.lastTagSize);
                            }
                            if (this.dataFile == null) break block47;
                            log.debug("Current file position: {}", (Object)this.dataFile.getChannel().position());
                            dataType = tag.getDataType();
                            IoBuffer tagBody = tag.getBody();
                            long fileOffset = this.dataFile.getFilePointer();
                            log.debug("Current file offset: {} expected offset: {}", (Object)fileOffset, (Object)prevBytesWritten);
                            if (fileOffset < prevBytesWritten) {
                                log.debug("Seeking to expected offset");
                                this.dataFile.seek(prevBytesWritten);
                                log.debug("New file position: {}", (Object)this.dataFile.getChannel().position());
                            }
                            totalTagSize = 11 + bodySize + 4;
                            this.dataFile.setLength(this.dataFile.length() + (long)totalTagSize);
                            tagBuffer = ByteBuffer.allocate(totalTagSize);
                            timestamp = tag.getTimestamp() + this.timeOffset;
                            bodyBuf = null;
                            if (bodySize <= 0) break block46;
                            bodyBuf = new byte[bodySize];
                            tagBody.get(bodyBuf);
                            if (dataType != 8) break block48;
                            this.audioDataSize += bodySize;
                            if (this.audioCodecId != -1) break block49;
                            id2 = bodyBuf[0] & 0xFF;
                            this.audioCodecId = (id2 & 0xF0) >> 4;
                            log.debug("Audio codec id: {}", (Object)this.audioCodecId);
                            if (this.audioCodecId == AudioCodec.AAC.getId()) {
                                log.trace("AAC audio type");
                                this.soundRate = 44100;
                                this.soundSize = 16;
                                this.soundType = true;
                                if (bodyBuf[1] != 0) {
                                    log.debug("Rejecting AAC data since config has not yet been written");
                                    boolean bl = false;
                                    return bl;
                                }
                                onWrittenSetAudioFlag = true;
                                break block46;
                            } else if (this.audioCodecId == AudioCodec.SPEEX.getId()) {
                                log.trace("Speex audio type");
                                this.soundRate = 5500;
                                this.soundSize = 16;
                                this.soundType = false;
                                break block46;
                            } else {
                                switch ((id2 & 0xC) >> 2) {
                                    case 0: {
                                        this.soundRate = 5500;
                                        break;
                                    }
                                    case 1: {
                                        this.soundRate = 11000;
                                        break;
                                    }
                                    case 2: {
                                        this.soundRate = 22000;
                                        break;
                                    }
                                    case 3: {
                                        this.soundRate = 44100;
                                        break;
                                    }
                                }
                                log.debug("Sound rate: {}", (Object)this.soundRate);
                                switch ((id2 & 2) >> 1) {
                                    case 0: {
                                        this.soundSize = 8;
                                        break;
                                    }
                                    case 1: {
                                        this.soundSize = 16;
                                        break;
                                    }
                                }
                                log.debug("Sound size: {}", (Object)this.soundSize);
                                this.soundType = (id2 & 1) > 0;
                                log.debug("Sound type: {}", (Object)this.soundType);
                            }
                            break block46;
                        }
                        if (!this.audioConfigWritten.get() && this.audioCodecId == AudioCodec.AAC.getId()) {
                            if (bodyBuf[1] != 0) {
                                boolean id2 = false;
                                return id2;
                            }
                            onWrittenSetAudioFlag = true;
                        }
                        break block46;
                    }
                    if (dataType == 9) {
                        this.videoDataSize += bodySize;
                        if (this.videoCodecId == -1) {
                            id2 = bodyBuf[0] & 0xFF;
                            this.videoCodecId = id2 & 0xF;
                            log.debug("Video codec id: {}", (Object)this.videoCodecId);
                            if (this.videoCodecId == VideoCodec.AVC.getId()) {
                                if (bodyBuf[1] != 0) {
                                    log.debug("Rejecting AVC data since config has not yet been written");
                                    boolean bl = false;
                                    return bl;
                                }
                                onWrittenSetVideoFlag = true;
                            }
                        } else if (!this.videoConfigWritten.get() && this.videoCodecId == VideoCodec.AVC.getId()) {
                            if (bodyBuf[1] != 0) {
                                log.debug("Rejecting AVC data since config has not yet been written");
                                boolean bl = false;
                                return bl;
                            }
                            onWrittenSetVideoFlag = true;
                        }
                    }
                }
                IOUtils.writeUnsignedByte(tagBuffer, dataType);
                IOUtils.writeMediumInt(tagBuffer, bodySize);
                IOUtils.writeExtendedMediumInt(tagBuffer, timestamp);
                tagBuffer.put(DEFAULT_STREAM_ID);
                if (log.isTraceEnabled()) {
                    log.trace("Tag buffer (after tag header) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                }
                if (bodyBuf != null) {
                    tagBuffer.put(bodyBuf);
                    if (log.isTraceEnabled()) {
                        log.trace("Tag buffer (after body) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                    }
                }
                tagBuffer.putInt(11 + bodySize);
                if (log.isTraceEnabled()) {
                    log.trace("Tag buffer (after prev tag size) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                }
                tagBuffer.flip();
                if (log.isDebugEnabled()) {
                    // empty if block
                }
                this.dataFile.write(tagBuffer.array());
                this.bytesWritten = this.dataFile.length();
                if (log.isTraceEnabled()) {
                    log.trace("Tag written, check value: {} (should be 0)", (Object)(this.bytesWritten - prevBytesWritten - (long)totalTagSize));
                }
                this.lastTagSize = 11 + bodySize;
                tagBuffer.clear();
                this.duration = Math.max(this.duration, timestamp);
                log.debug("Writer duration: {}", (Object)this.duration);
                if (this.bytesWritten - prevBytesWritten != (long)totalTagSize) {
                    log.debug("Not all of the bytes appear to have been written, prev-current: {}", (Object)(this.bytesWritten - prevBytesWritten));
                }
                boolean bl = true;
                return bl;
            }
            throw new IOException("FLV write channel has been closed", new ClosedChannelException());
        }
        catch (InterruptedException e) {
            log.warn("Exception acquiring lock", (Throwable)e);
            return false;
        }
        finally {
            this.updateInfoFile();
            if (onWrittenSetAudioFlag && this.audioConfigWritten.compareAndSet(false, true)) {
                log.trace("Audio configuration written");
            } else if (onWrittenSetVideoFlag && this.videoConfigWritten.compareAndSet(false, true)) {
                log.trace("Video configuration written");
            }
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeTag(byte dataType, IoBuffer data) throws IOException {
        if (this.timeOffset == 0) {
            this.timeOffset = (int)System.currentTimeMillis();
        }
        try {
            this.lock.acquire();
            if (log.isTraceEnabled()) {
                log.trace("writeTag - type: {} data: {}", (Object)dataType, (Object)data);
            }
            long prevBytesWritten = this.bytesWritten;
            log.trace("Previous bytes written: {}", (Object)prevBytesWritten);
            int bodySize = data.limit();
            log.debug("Tag body size: {}", (Object)bodySize);
            if (this.dataFile != null) {
                log.debug("Current file position: {}", (Object)this.dataFile.getChannel().position());
                long fileOffset = this.dataFile.getFilePointer();
                log.debug("Current file offset: {} expected offset: {}", (Object)fileOffset, (Object)prevBytesWritten);
                if (fileOffset < prevBytesWritten) {
                    log.debug("Seeking to expected offset");
                    this.dataFile.seek(prevBytesWritten);
                    log.debug("New file position: {}", (Object)this.dataFile.getChannel().position());
                }
                int totalTagSize = 11 + bodySize + 4;
                this.dataFile.setLength(this.dataFile.length() + (long)totalTagSize);
                ByteBuffer tagBuffer = ByteBuffer.allocate(totalTagSize);
                IOUtils.writeUnsignedByte(tagBuffer, dataType);
                IOUtils.writeMediumInt(tagBuffer, bodySize);
                int timestamp = (int)(System.currentTimeMillis() - (long)this.timeOffset);
                IOUtils.writeExtendedMediumInt(tagBuffer, timestamp);
                tagBuffer.put(DEFAULT_STREAM_ID);
                log.trace("Tag buffer (after tag header) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                if (data.hasArray()) {
                    tagBuffer.put(data.array());
                    log.trace("Tag buffer (after body) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                }
                tagBuffer.putInt(11 + bodySize);
                log.trace("Tag buffer (after prev tag size) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                tagBuffer.flip();
                if (log.isDebugEnabled()) {
                    // empty if block
                }
                this.dataFile.write(tagBuffer.array());
                this.bytesWritten = this.dataFile.length();
                if (log.isTraceEnabled()) {
                    log.trace("Tag written, check value: {} (should be 0)", (Object)(this.bytesWritten - prevBytesWritten - (long)totalTagSize));
                }
                this.lastTagSize = 11 + bodySize;
                tagBuffer.clear();
                this.duration = Math.max(this.duration, timestamp);
                log.debug("Writer duration: {}", (Object)this.duration);
                if (this.bytesWritten - prevBytesWritten != (long)totalTagSize) {
                    log.debug("Not all of the bytes appear to have been written, prev-current: {}", (Object)(this.bytesWritten - prevBytesWritten));
                }
                boolean bl = true;
                return bl;
            }
            try {
                throw new IOException("FLV write channel has been closed", new ClosedChannelException());
            }
            catch (InterruptedException e) {
                log.warn("Exception acquiring lock", (Throwable)e);
            }
        }
        finally {
            this.updateInfoFile();
            this.lock.release();
        }
        return false;
    }

    @Override
    public boolean writeStream(byte[] b) {
        try {
            this.dataFile.write(b);
            return true;
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    private void writeMetadataTag(double duration, int videoCodecId, int audioCodecId) throws IOException {
        log.debug("writeMetadataTag - duration: {} video codec: {} audio codec: {}", new Object[]{duration, videoCodecId, audioCodecId});
        IoBuffer buf = IoBuffer.allocate((int)1024);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onMetaData");
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("server", "Red5");
        params.put("recordeddate", this.recordedDate);
        params.put("duration", duration);
        if (videoCodecId != -1) {
            params.put("videocodecid", videoCodecId == 7 ? "avc1" : Integer.valueOf(videoCodecId));
            if (this.videoDataSize > 0) {
                params.put("videodatarate", (double)(8 * this.videoDataSize / 1024) / duration);
            }
        } else {
            params.put("novideocodec", 0);
        }
        if (audioCodecId != -1) {
            params.put("audiocodecid", audioCodecId == 10 ? "mp4a" : Integer.valueOf(audioCodecId));
            if (audioCodecId == AudioCodec.AAC.getId()) {
                params.put("audiosamplerate", 44100);
                params.put("audiosamplesize", 16);
            } else if (audioCodecId == AudioCodec.SPEEX.getId()) {
                params.put("audiosamplerate", 16000);
                params.put("audiosamplesize", 16);
            } else {
                params.put("audiosamplerate", this.soundRate);
                params.put("audiosamplesize", this.soundSize);
            }
            params.put("stereo", this.soundType);
            if (this.audioDataSize > 0) {
                params.put("audiodatarate", (double)(8 * this.audioDataSize / 1024) / duration);
            }
        } else {
            params.put("noaudiocodec", 0);
        }
        params.put("canSeekToEnd", true);
        out.writeMap(params);
        buf.flip();
        int bodySize = buf.limit();
        log.debug("Metadata size: {}", (Object)bodySize);
        int totalTagSize = 11 + bodySize + 4;
        this.file.setLength(this.file.length() + (long)totalTagSize);
        ByteBuffer tagBuffer = ByteBuffer.allocate(totalTagSize);
        int timestamp = 0;
        byte[] bodyBuf = new byte[bodySize];
        buf.get(bodyBuf);
        IOUtils.writeUnsignedByte(tagBuffer, (byte)18);
        IOUtils.writeMediumInt(tagBuffer, bodySize);
        IOUtils.writeExtendedMediumInt(tagBuffer, timestamp);
        tagBuffer.put(DEFAULT_STREAM_ID);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after tag header) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.put(bodyBuf);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after body) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.putInt(11 + bodySize);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after prev tag size) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.flip();
        this.file.write(tagBuffer.array());
        this.bytesWritten = this.file.length();
        tagBuffer.clear();
        buf.clear();
    }

    private void updateMetadataTag(RandomAccessFile flvFile, double duration, int videoCodecId, int audioCodecId) throws IOException {
        log.debug("updateMetadataTag - duration: {} video codec: {} audio codec: {}", new Object[]{duration, videoCodecId, audioCodecId});
        IoBuffer buf = IoBuffer.allocate((int)512);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onMetaData");
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("server", "Red5");
        params.put("recordeddate", this.recordedDate);
        params.put("duration", duration);
        if (videoCodecId != -1) {
            params.put("videocodecid", videoCodecId == 7 ? "avc1" : Integer.valueOf(videoCodecId));
            if (this.videoDataSize > 0) {
                params.put("videodatarate", (double)(8 * this.videoDataSize / 1024) / duration);
            }
        } else {
            params.put("novideocodec", 0);
        }
        if (audioCodecId != -1) {
            params.put("audiocodecid", audioCodecId == 10 ? "mp4a" : Integer.valueOf(audioCodecId));
            if (audioCodecId == AudioCodec.AAC.getId()) {
                params.put("audiosamplerate", 44100);
                params.put("audiosamplesize", 16);
            } else if (audioCodecId == AudioCodec.SPEEX.getId()) {
                params.put("audiosamplerate", 16000);
                params.put("audiosamplesize", 16);
            } else {
                params.put("audiosamplerate", this.soundRate);
                params.put("audiosamplesize", this.soundSize);
            }
            params.put("stereo", this.soundType);
            if (this.audioDataSize > 0) {
                params.put("audiodatarate", (double)(8 * this.audioDataSize / 1024) / duration);
            }
        } else {
            params.put("noaudiocodec", 0);
        }
        params.put("canSeekToEnd", true);
        out.writeMap(params);
        buf.flip();
        int bodySize = buf.limit();
        log.debug("Metadata size: {}", (Object)bodySize);
        int totalTagSize = 11 + bodySize + 4;
        ByteBuffer tagBuffer = ByteBuffer.allocate(totalTagSize);
        int timestamp = 0;
        byte[] bodyBuf = new byte[bodySize];
        buf.get(bodyBuf);
        IOUtils.writeUnsignedByte(tagBuffer, (byte)18);
        IOUtils.writeMediumInt(tagBuffer, bodySize);
        IOUtils.writeExtendedMediumInt(tagBuffer, timestamp);
        tagBuffer.put(DEFAULT_STREAM_ID);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after tag header) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.put(bodyBuf);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after body) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.putInt(11 + bodySize);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after prev tag size) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.flip();
        flvFile.seek(13L);
        flvFile.write(tagBuffer.array());
        tagBuffer.clear();
        buf.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long finalizeFlv() {
        long bytesTransferred;
        block46: {
            block47: {
                block44: {
                    bytesTransferred = 0L;
                    if (this.finalized.get()) break block47;
                    log.debug("Finalizing {}", (Object)this.filePath);
                    Object tmpFile23332 = new File(this.filePath + ".info");
                    if (((File)tmpFile23332).exists()) {
                        int[] info = FLVWriter.readInfoFile((File)tmpFile23332);
                        if (this.audioCodecId == -1 && info[0] > 0) {
                            this.audioCodecId = info[0];
                        }
                        if (this.videoCodecId == -1 && info[1] > 0) {
                            this.videoCodecId = info[1];
                        }
                        if (this.duration == 0 && info[2] > 0) {
                            this.duration = info[2];
                        }
                        if (this.audioDataSize == 0 && info[3] > 0) {
                            this.audioDataSize = info[3];
                        }
                        if (this.soundRate == 0 && info[4] > 0) {
                            this.soundRate = info[4];
                        }
                        if (this.soundSize == 0 && info[5] > 0) {
                            this.soundSize = info[5];
                        }
                        if (!this.soundType && info[6] > 0) {
                            this.soundType = true;
                        }
                        if (this.videoDataSize == 0 && info[7] > 0) {
                            this.videoDataSize = info[7];
                        }
                    } else {
                        log.debug("Flv info file not found");
                    }
                    tmpFile23332 = null;
                    if (!this.append) {
                        this.writeHeader();
                        this.writeMetadataTag((double)this.duration * 0.001, this.videoCodecId, this.audioCodecId);
                        if (this.dataFile == null) {
                            this.dataFile = new RandomAccessFile(this.filePath + ".ser", "r");
                        }
                        this.dataFile.seek(0L);
                        bytesTransferred = this.file.getChannel().transferFrom(this.dataFile.getChannel(), this.bytesWritten, this.dataFile.length());
                    } else {
                        this.updateMetadataTag(this.dataFile, (double)this.duration * 0.001, this.videoCodecId, this.audioCodecId);
                        bytesTransferred = 1L;
                    }
                    if (this.dataFile != null && bytesTransferred > 0L) {
                        this.dataFile.close();
                        this.dataFile = null;
                        if (bytesTransferred > 0L) {
                            File inf;
                            File dat = new File(this.filePath + ".ser");
                            if (dat.exists()) {
                                dat.delete();
                            }
                            if ((inf = new File(this.filePath + ".info")).exists()) {
                                inf.delete();
                            }
                        } else {
                            log.warn("FLV serial file not deleted due to transfer error");
                        }
                    }
                    if (this.file == null) break block44;
                    try {
                        this.file.close();
                    }
                    catch (Exception tmpFile23332) {
                        // empty catch block
                    }
                }
                if (this.postProcessors != null) {
                    for (IPostProcessor postProcessor : this.postProcessors) {
                        log.debug("Execute: {}", (Object)postProcessor);
                        try {
                            postProcessor.init(this.filePath);
                            this.executor.submit(postProcessor).get();
                        }
                        catch (Throwable t) {
                            log.warn("Exception during post process on: {}", (Object)this.filePath, (Object)t);
                        }
                    }
                    this.postProcessors.clear();
                } else {
                    log.debug("No post processors configured");
                }
                this.finalized.compareAndSet(false, true);
                break block46;
                catch (Exception e) {
                    block45: {
                        log.warn("Finalization of flv file failed; new finalize job will be spawned", (Throwable)e);
                        if (this.file == null) break block45;
                        try {
                            this.file.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.postProcessors != null) {
                        for (IPostProcessor postProcessor : this.postProcessors) {
                            log.debug("Execute: {}", (Object)postProcessor);
                            try {
                                postProcessor.init(this.filePath);
                                this.executor.submit(postProcessor).get();
                            }
                            catch (Throwable t) {
                                log.warn("Exception during post process on: {}", (Object)this.filePath, (Object)t);
                            }
                        }
                        this.postProcessors.clear();
                    } else {
                        log.debug("No post processors configured");
                    }
                    this.finalized.compareAndSet(false, true);
                    break block46;
                    catch (Throwable throwable) {
                        if (this.file != null) {
                            try {
                                this.file.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (this.postProcessors != null) {
                            for (IPostProcessor postProcessor : this.postProcessors) {
                                log.debug("Execute: {}", (Object)postProcessor);
                                try {
                                    postProcessor.init(this.filePath);
                                    this.executor.submit(postProcessor).get();
                                }
                                catch (Throwable t) {
                                    log.warn("Exception during post process on: {}", (Object)this.filePath, (Object)t);
                                }
                            }
                            this.postProcessors.clear();
                        } else {
                            log.debug("No post processors configured");
                        }
                        this.finalized.compareAndSet(false, true);
                        throw throwable;
                    }
                }
            }
            log.trace("Finalization already completed");
        }
        return bytesTransferred;
    }

    private static int[] readInfoFile(File tmpFile) {
        int[] info = new int[8];
        try (RandomAccessFile infoFile = new RandomAccessFile(tmpFile, "r");){
            info[0] = infoFile.readInt();
            info[1] = infoFile.readInt();
            info[2] = infoFile.readInt();
            info[3] = infoFile.readInt();
            info[4] = infoFile.readInt();
            info[5] = infoFile.readInt();
            info[6] = infoFile.readInt();
            info[7] = infoFile.readInt();
        }
        catch (Exception e) {
            log.warn("Exception reading flv file information data", (Throwable)e);
        }
        return info;
    }

    private void updateInfoFile() {
        try (RandomAccessFile infoFile = new RandomAccessFile(this.filePath + ".info", "rw");){
            infoFile.writeInt(this.audioCodecId);
            infoFile.writeInt(this.videoCodecId);
            infoFile.writeInt(this.duration);
            infoFile.writeInt(this.audioDataSize);
            infoFile.writeInt(this.soundRate);
            infoFile.writeInt(this.soundSize);
            infoFile.writeInt(this.soundType ? 1 : 0);
            infoFile.writeInt(this.videoDataSize);
        }
        catch (Exception e) {
            log.warn("Exception writing flv file information data", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        log.debug("close");
        boolean locked = false;
        long bytesTransferred = 0L;
        try {
            locked = this.lock.tryAcquire(500L, TimeUnit.MILLISECONDS);
            if (locked) {
                bytesTransferred = this.finalizeFlv();
            }
        }
        catch (InterruptedException e) {
            log.warn("Exception acquiring lock", (Throwable)e);
        }
        finally {
            if (locked) {
                this.lock.release();
            }
            log.debug("Closed: {}", (Object)this.filePath);
            if (bytesTransferred == 0L) {
                log.info("Spawning flv finalizer for {}", (Object)this.filePath);
                Future<?> future = this.executor.submit(new FLVFinalizer());
                try {
                    future.get();
                }
                catch (Exception e) {
                    log.warn("Exception while finalizing: {}", (Object)this.filePath, (Object)e);
                }
            }
        }
        if (this.executor != null && !this.executor.isTerminated()) {
            this.executor.shutdown();
        }
    }

    @Override
    public void addPostProcessor(IPostProcessor postProcessor) {
        if (this.postProcessors == null) {
            this.postProcessors = new LinkedList();
        }
        this.postProcessors.add(postProcessor);
    }

    @Override
    public IStreamableFile getFile() {
        return this.flv;
    }

    public void setFLV(IFLV flv) {
        this.flv = flv;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setVideoCodecId(int videoCodecId) {
        this.videoCodecId = videoCodecId;
    }

    public void setAudioCodecId(int audioCodecId) {
        this.audioCodecId = audioCodecId;
    }

    public void setSoundRate(int soundRate) {
        this.soundRate = soundRate;
    }

    public void setSoundSize(int soundSize) {
        this.soundSize = soundSize;
    }

    public void setSoundType(boolean soundType) {
        this.soundType = soundType;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setVideoDataSize(int videoDataSize) {
        this.videoDataSize = videoDataSize;
    }

    public void setAudioDataSize(int audioDataSize) {
        this.audioDataSize = audioDataSize;
    }

    public static boolean repair(String path, Integer audioId, Integer videoId) throws InterruptedException {
        boolean result = false;
        Object writer = null;
        log.debug("Serial file path: " + path);
        System.out.println("Serial file path: " + path);
        if (path.endsWith(".ser")) {
            File ser = new File(path);
            if (ser.exists() && ser.canRead()) {
                ser = null;
                String flvPath = path.substring(0, path.lastIndexOf(46));
                log.debug("Flv file path: " + flvPath);
                System.out.println("Flv file path: " + flvPath);
                File inf = new File(flvPath + ".info");
                if (inf.exists() && inf.canRead()) {
                    inf = null;
                    writer = new FLVWriter(flvPath);
                } else {
                    log.debug("Info file was not found or could not be read, using dummy data");
                    System.err.println("Info file was not found or could not be read, using dummy data");
                    writer = new FLVWriter(flvPath);
                    int acid = audioId == null ? 11 : audioId;
                    int vcid = videoId == null ? 7 : videoId;
                    ((FLVWriter)writer).setAudioCodecId(acid);
                    ((FLVWriter)writer).setVideoCodecId(vcid);
                    ((FLVWriter)writer).setDuration(Integer.MAX_VALUE);
                    ((FLVWriter)writer).setSoundRate(16000);
                    ((FLVWriter)writer).setSoundSize(16);
                }
            } else {
                log.error("Serial file was not found or could not be read");
                System.err.println("Serial file was not found or could not be read");
            }
        } else {
            log.error("Provide the path to your .ser file");
            System.err.println("Serial file was not found or could not be read");
        }
        if (writer != null) {
            Object object = writer;
            object.getClass();
            Future<?> future = super.submit((FLVWriter)object.new FLVFinalizer());
            try {
                future.get();
                log.debug("File repair completed");
                System.out.println("File repair completed");
                result = true;
            }
            catch (Exception e) {
                log.warn("Exception while finalizing: {}", (Object)path, (Object)e);
            }
        }
        return result;
    }

    private Future<?> submit(FLVFinalizer flvFinalizer) {
        if (this.executor != null && !this.executor.isTerminated()) {
            return this.executor.submit(flvFinalizer);
        }
        return null;
    }

    public static void main(String[] args) throws InterruptedException {
        if (args == null || args[0] == null) {
            System.err.println("Provide the path to your .ser file");
        } else {
            FLVWriter.repair(args[0], args.length > 1 && args[1] != null ? Integer.valueOf(args[1]) : null, args.length > 2 && args[2] != null ? Integer.valueOf(args[2]) : null);
        }
        System.exit(0);
    }

    private final class FLVFinalizer
    implements Runnable {
        private FLVFinalizer() {
        }

        @Override
        public void run() {
            log.debug("Finalizer run");
            try {
                FLVWriter.this.file = null;
                File tmp = new File(FLVWriter.this.filePath);
                boolean deleted = tmp.delete();
                log.info("Deleted ({}) incomplete file: {}", (Object)deleted, (Object)FLVWriter.this.filePath);
                tmp = null;
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                log.error("Error on cleanup of flv", (Throwable)e);
            }
            FLVWriter.this.finalizeFlv();
            log.debug("Finalizer exit");
        }
    }
}

