/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.webm;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.red5.io.matroska.ConverterException;
import org.red5.io.matroska.dtd.CompoundTag;
import org.red5.io.matroska.dtd.StringTag;
import org.red5.io.matroska.dtd.Tag;
import org.red5.io.matroska.dtd.TagFactory;
import org.red5.io.matroska.dtd.UnsignedIntegerTag;
import org.red5.io.webm.TagConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebmWriter
implements Closeable,
TagConsumer {
    private static Logger log = LoggerFactory.getLogger(WebmWriter.class);
    private boolean append;
    private RandomAccessFile dataFile;
    private File file;
    private volatile long bytesWritten;
    private String filePath;

    public WebmWriter(File file, boolean append) {
        this.file = file;
        this.filePath = file.getAbsolutePath();
        try {
            this.append = append;
            if (append) {
                if (!(file.exists() && file.canRead() && file.canWrite())) {
                    throw new FileNotFoundException("File does not exist or cannot be accessed");
                }
                log.trace("File size: {} last modified: {}", (Object)file.length(), (Object)file.lastModified());
                this.bytesWritten = file.length();
                this.dataFile = new RandomAccessFile(file, "rws");
            } else {
                File dat = new File(this.filePath + ".ser");
                if (dat.exists()) {
                    dat.delete();
                    dat.createNewFile();
                }
                this.dataFile = new RandomAccessFile(dat, "rws");
            }
        }
        catch (Exception e) {
            log.error("Failed to create FLV writer", (Throwable)e);
        }
    }

    public void writeHeader() throws IOException, ConverterException {
        if (this.append) {
            return;
        }
        try {
            CompoundTag ebml = ((CompoundTag)TagFactory.create("EBML")).add(((UnsignedIntegerTag)TagFactory.create("EBMLVersion")).setValue(1L)).add(((UnsignedIntegerTag)TagFactory.create("EBMLReadVersion")).setValue(1L)).add(((UnsignedIntegerTag)TagFactory.create("EBMLMaxIDLength")).setValue(4L)).add(((UnsignedIntegerTag)TagFactory.create("EBMLMaxSizeLength")).setValue(8L)).add(((StringTag)TagFactory.create("DocType")).setValue("webm")).add(((UnsignedIntegerTag)TagFactory.create("DocTypeVersion")).setValue(3L)).add(((UnsignedIntegerTag)TagFactory.create("DocTypeReadVersion")).setValue(2L));
            byte[] hb = ebml.encode();
            this.bytesWritten += (long)hb.length;
            this.dataFile.write(hb);
        }
        catch (IOException | ConverterException e) {
            log.error("Failed to write header", (Throwable)e);
            throw e;
        }
    }

    public void writeTag(Tag tag) throws IOException {
        byte[] hb = tag.encode();
        this.bytesWritten += (long)hb.length;
        this.dataFile.write(hb);
    }

    @Override
    public void close() throws IOException {
        if (this.dataFile != null) {
            if (!this.append) {
                this.dataFile.seek(0L);
                try (RandomAccessFile rf = new RandomAccessFile(this.file, "rw");){
                    rf.getChannel().transferFrom(this.dataFile.getChannel(), 0L, this.dataFile.length());
                }
            }
            try {
                this.dataFile.close();
                this.dataFile = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void consume(Tag tag) throws IOException {
        this.writeTag(tag);
    }
}

