/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf3;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.amf.AMF;
import org.red5.io.amf3.IDataInput;
import org.red5.io.amf3.Input;
import org.red5.io.object.Deserializer;

public class DataInput
implements IDataInput {
    private Input input;
    private IoBuffer buffer;

    protected DataInput(Input input) {
        this.input = input;
        this.buffer = input.getBuffer();
    }

    @Override
    public ByteOrder getEndian() {
        return this.buffer.order();
    }

    @Override
    public void setEndian(ByteOrder endian) {
        this.buffer.order(endian);
    }

    @Override
    public boolean readBoolean() {
        return this.buffer.get() != 0;
    }

    @Override
    public byte readByte() {
        return this.buffer.get();
    }

    @Override
    public void readBytes(byte[] bytes) {
        this.buffer.get(bytes);
    }

    @Override
    public void readBytes(byte[] bytes, int offset) {
        this.buffer.get(bytes, offset, bytes.length - offset);
    }

    @Override
    public void readBytes(byte[] bytes, int offset, int length) {
        this.buffer.get(bytes, offset, length);
    }

    @Override
    public double readDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public float readFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public int readInt() {
        return this.buffer.getInt();
    }

    @Override
    public String readMultiByte(int length, String charSet) {
        Charset cs = Charset.forName(charSet);
        int limit = this.buffer.limit();
        ByteBuffer strBuf = this.buffer.buf();
        strBuf.limit(strBuf.position() + length);
        String string = cs.decode(strBuf).toString();
        this.buffer.limit(limit);
        return string;
    }

    @Override
    public Object readObject() {
        return Deserializer.deserialize(this.input, Object.class);
    }

    @Override
    public short readShort() {
        return this.buffer.getShort();
    }

    @Override
    public int readUnsignedByte() {
        return this.buffer.getUnsigned();
    }

    @Override
    public long readUnsignedInt() {
        return this.buffer.getUnsignedInt();
    }

    @Override
    public int readUnsignedShort() {
        return this.buffer.getShort() & 0xFFFF;
    }

    @Override
    public String readUTF() {
        int length = this.buffer.getShort() & 0xFFFF;
        return this.readUTFBytes(length);
    }

    @Override
    public String readUTFBytes(int length) {
        int limit = this.buffer.limit();
        ByteBuffer strBuf = this.buffer.buf();
        strBuf.limit(strBuf.position() + length);
        String string = AMF.CHARSET.decode(strBuf).toString();
        this.buffer.limit(limit);
        return string;
    }
}

