/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.matroska.dtd;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import org.red5.io.matroska.ParserUtils;
import org.red5.io.matroska.VINT;
import org.red5.io.matroska.dtd.UnsignedIntegerTag;

public class DateTag
extends UnsignedIntegerTag {
    public static final long NANO_MULTIPLIER = 1000L;
    public static final long DELAY = 978285600000L;
    private Date value;

    public DateTag(String name, VINT id) throws IOException {
        super(name, id);
    }

    public DateTag(String name, VINT id, VINT size, InputStream inputStream) throws IOException {
        super(name, id, size, inputStream);
    }

    @Override
    public void parse(InputStream inputStream) throws IOException {
        long _val = ParserUtils.parseInteger(inputStream, (int)this.getSize());
        long val = _val / 1000L + 978285600000L;
        super.setValue(_val);
        this.value = new Date(val);
    }

    @Override
    protected void putValue(ByteBuffer bb) throws IOException {
        super.putValue(bb);
    }

    public DateTag setValue(Date value) {
        this.value = value;
        super.setValue((value.getTime() - 978285600000L) * 1000L);
        return this;
    }

    public Date getDate() {
        return this.value;
    }

    @Override
    public String toString() {
        return super.toString() + " = " + this.value;
    }
}

