/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.mp3.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.mp3.AudioFrame;
import org.apache.tika.parser.mp3.Mp3Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.red5.io.IKeyFrameMetaCache;
import org.red5.io.IStreamableFile;
import org.red5.io.ITag;
import org.red5.io.ITagReader;
import org.red5.io.amf.Output;
import org.red5.io.flv.IKeyFrameDataAnalyzer;
import org.red5.io.flv.impl.Tag;
import org.red5.io.mp3.impl.MP3Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class MP3Reader
implements ITagReader,
IKeyFrameDataAnalyzer {
    protected static Logger log = LoggerFactory.getLogger(MP3Reader.class);
    private File file;
    private FileInputStream fis;
    private ITag tag;
    private int prevSize;
    private double currentTime;
    private IKeyFrameDataAnalyzer.KeyFrameMeta frameMeta;
    private HashMap<Long, Float> posTimeMap;
    private int dataRate;
    private long duration;
    private static IKeyFrameMetaCache frameCache;
    private MetaData metaData;
    private LinkedList<ITag> firstTags = new LinkedList();
    private long fileSize;
    private final Semaphore lock = new Semaphore(1, true);
    private FileChannel fileChannel;
    private LinkedList<AudioFrame> frameList;
    private int frameIndex;
    private int frameCount;

    MP3Reader() {
    }

    public MP3Reader(File file) throws IOException {
        this.file = file;
        this.fis = new FileInputStream(file);
        try {
            String[] metadataNames;
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            Mp3Parser parser = new Mp3Parser();
            parser.parse((InputStream)this.fis, (ContentHandler)handler, metadata, null);
            log.debug("Contents of the document: {}", (Object)handler.toString());
            this.metaData = new MetaData();
            String val = null;
            for (String name : metadataNames = metadata.names()) {
                val = metadata.get(name);
                log.debug("Meta name: {} value: {}", (Object)name, (Object)val);
                if ("xmpDM:artist".equals(name)) {
                    this.metaData.setArtist(val);
                    continue;
                }
                if ("xmpDM:album".equals(name)) {
                    this.metaData.setAlbum(val);
                    continue;
                }
                if ("title".equals(name)) {
                    this.metaData.setSongName(val);
                    continue;
                }
                if ("xmpDM:genre".equals(name)) {
                    this.metaData.setGenre(val);
                    continue;
                }
                if ("xmpDM:logComment".equals(name)) {
                    this.metaData.setComment(val);
                    continue;
                }
                if ("xmpDM:trackNumber".equals(name)) {
                    this.metaData.setTrack(val);
                    continue;
                }
                if ("xmpDM:releaseDate".equals(name)) {
                    this.metaData.setYear(val);
                    continue;
                }
                if ("xmpDM:duration".equals(name) || "duration".equals(name)) {
                    this.metaData.setDuration(val);
                    continue;
                }
                if ("xmpDM:audioSampleRate".equals(name) || "samplerate".equals(name)) {
                    this.metaData.setSampleRate(val);
                    continue;
                }
                if (!"channels".equals(name)) continue;
                this.metaData.setChannels(val);
            }
        }
        catch (Exception e) {
            log.error("MP3Reader {}", (Throwable)e);
        }
        this.checkValidHeader();
        this.fileSize = file.length();
        log.debug("File size: {}", (Object)this.fileSize);
        this.analyzeKeyFrames();
        this.firstTags.addFirst(this.createFileMeta());
        log.trace("File input stream - open: {} position: {}", (Object)this.fis.getChannel().isOpen(), (Object)this.fis.getChannel().position());
        this.fileChannel = this.fis.getChannel();
    }

    @Override
    public boolean hasVideo() {
        return false;
    }

    public void setFrameCache(IKeyFrameMetaCache frameCache) {
        MP3Reader.frameCache = frameCache;
    }

    private void checkValidHeader() {
        int sampleRate = Integer.valueOf(this.metaData.getSampleRate());
        switch (sampleRate) {
            case 5513: 
            case 11025: 
            case 22050: 
            case 44100: 
            case 48000: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported sample rate: " + sampleRate);
            }
        }
    }

    private ITag createFileMeta() {
        log.debug("createFileMeta");
        IoBuffer in = IoBuffer.allocate((int)1024);
        in.setAutoExpand(true);
        Output out = new Output(in);
        out.writeString("onMetaData");
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        props.put("audiocodecid", (byte)2);
        props.put("canSeekToEnd", true);
        if (this.metaData != null) {
            if (this.metaData.artist != null) {
                props.put("artist", this.metaData.artist);
            }
            if (this.metaData.album != null) {
                props.put("album", this.metaData.album);
            }
            if (this.metaData.songName != null) {
                props.put("songName", this.metaData.songName);
            }
            if (this.metaData.genre != null) {
                props.put("genre", this.metaData.genre);
            }
            if (this.metaData.year != null) {
                props.put("year", this.metaData.year);
            }
            if (this.metaData.track != null) {
                props.put("track", this.metaData.track);
            }
            if (this.metaData.comment != null) {
                props.put("comment", this.metaData.comment);
            }
            if (this.metaData.duration != null) {
                props.put("duration", this.metaData.duration);
            }
            if (this.metaData.channels != null) {
                props.put("channels", this.metaData.channels);
            }
            if (this.metaData.sampleRate != null) {
                props.put("samplerate", this.metaData.sampleRate);
            }
            if (this.metaData.hasCoverImage()) {
                HashMap<String, Object[]> covr = new HashMap<String, Object[]>(1);
                covr.put("covr", new Object[]{this.metaData.getCovr()});
                props.put("tags", covr);
            }
            this.metaData = null;
        }
        log.debug("Metadata properties map: {}", props);
        if (!props.containsKey("duration")) {
            if (this.frameMeta != null) {
                props.put("duration", (double)this.frameMeta.timestamps[this.frameMeta.timestamps.length - 1] / 1000.0);
            } else {
                log.debug("Frame meta was null");
            }
        }
        if (this.dataRate > 0) {
            props.put("audiodatarate", this.dataRate);
        }
        out.writeMap(props);
        in.flip();
        Tag result = new Tag(18, 0, in.limit(), null, this.prevSize);
        result.setBody(in);
        return result;
    }

    @Override
    public IStreamableFile getFile() {
        return null;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public long getBytesRead() {
        try {
            return this.fileChannel != null ? this.fileChannel.position() : 0L;
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getTotalBytes() {
        return this.fileSize;
    }

    @Override
    public boolean hasMoreTags() {
        log.debug("hasMoreTags");
        return this.fileChannel.isOpen() && this.frameIndex < this.frameCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITag readTag() {
        log.debug("readTag");
        try {
            AudioFrame frame;
            this.lock.acquire();
            if (!this.firstTags.isEmpty()) {
                ITag iTag = this.firstTags.removeFirst();
                return iTag;
            }
            if ((frame = this.frameList.get(this.frameIndex++)) == null) {
                ITag iTag = null;
                return iTag;
            }
            int frameSize = frame.getLength();
            log.trace("Frame size: {}", (Object)frameSize);
            if (frameSize == 0) {
                ITag iTag = null;
                return iTag;
            }
            this.tag = new Tag(8, (int)this.currentTime, frameSize + 1, null, this.prevSize);
            this.prevSize = frameSize + 1;
            this.currentTime += (double)frame.getDuration();
            IoBuffer body = IoBuffer.allocate((int)this.tag.getBodySize());
            body.setAutoExpand(true);
            byte tagType = 34;
            switch (frame.getSampleRate()) {
                case 48000: {
                    tagType = (byte)(tagType | 0x10);
                    break;
                }
                case 44100: {
                    tagType = (byte)(tagType | 0xC);
                    break;
                }
                case 22050: {
                    tagType = (byte)(tagType | 8);
                    break;
                }
                case 11025: {
                    tagType = (byte)(tagType | 4);
                    break;
                }
                default: {
                    tagType = (byte)(tagType | 0);
                }
            }
            tagType = (byte)(tagType | (frame.getChannels() > 1 ? 1 : 0));
            body.put(tagType);
            log.trace("Allocating {} buffer", (Object)frameSize);
            if (frameSize > 0) {
                ByteBuffer in = ByteBuffer.allocate(frameSize).order(ByteOrder.BIG_ENDIAN);
                this.fileChannel.read(in);
                in.flip();
                body.put(in);
                body.flip();
                this.tag.setBody(body);
            } else {
                log.warn("Buffer size was invalid: {}", (Object)frameSize);
            }
        }
        catch (InterruptedException e) {
            log.warn("Exception acquiring lock", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Exception reading tag", (Throwable)e);
        }
        finally {
            this.lock.release();
        }
        return this.tag;
    }

    @Override
    public void close() {
        if (this.posTimeMap != null) {
            this.posTimeMap.clear();
        }
        try {
            this.fis.close();
            this.fileChannel.close();
        }
        catch (IOException e) {
            log.error("Exception on close", (Throwable)e);
        }
    }

    @Override
    public void decodeHeader() {
    }

    @Override
    public void position(long pos) {
        if (pos == Long.MAX_VALUE) {
            this.currentTime = this.duration;
        }
        if (this.posTimeMap.containsKey(pos)) {
            try {
                this.fileChannel.position(pos);
                this.currentTime = this.posTimeMap.get(pos).floatValue();
            }
            catch (IOException e) {
                log.warn("Setting position to: {} failed", (Object)pos, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IKeyFrameDataAnalyzer.KeyFrameMeta analyzeKeyFrames() {
        log.debug("analyzeKeyFrames");
        if (this.frameMeta != null) {
            return this.frameMeta;
        }
        try {
            this.lock.acquire();
            if (frameCache != null) {
                this.frameMeta = frameCache.loadKeyFrameMeta(this.file);
                if (this.frameMeta != null && this.frameMeta.duration > 0L) {
                    this.duration = this.frameMeta.duration;
                    this.frameMeta.audioOnly = true;
                    this.posTimeMap = new HashMap();
                    for (int i = 0; i < this.frameMeta.positions.length; ++i) {
                        this.posTimeMap.put(this.frameMeta.positions[i], Float.valueOf(this.frameMeta.timestamps[i]));
                    }
                    IKeyFrameDataAnalyzer.KeyFrameMeta i = this.frameMeta;
                    return i;
                }
            }
            FileChannel channel = this.fis.getChannel();
            log.debug("Position: {}", (Object)channel.position());
            channel.position(0L);
            MP3Stream stream = new MP3Stream(this.fis);
            this.frameList = new LinkedList();
            ArrayList<Long> positionList = new ArrayList<Long>();
            ArrayList<Float> timestampList = new ArrayList<Float>();
            this.dataRate = 0;
            long rate = 0L;
            float time = 0.0f;
            AudioFrame frame = stream.nextFrame();
            while (frame != null) {
                long pos = channel.position() - 4L;
                if (pos + (long)frame.getLength() > this.fileSize) {
                    log.trace("Last frame was incomplete");
                    break;
                }
                this.frameList.add(frame);
                positionList.add(pos);
                timestampList.add(Float.valueOf(time));
                rate += (long)(frame.getBitRate() / 1000);
                time += frame.getDuration();
                ++this.frameCount;
                stream.skipFrame();
                frame = stream.nextFrame();
            }
            channel.position(0L);
            log.trace("Finished with frame count: {}", (Object)this.frameCount);
            this.duration = (long)time;
            this.dataRate = (int)(rate / (long)this.frameCount);
            this.posTimeMap = new HashMap();
            this.frameMeta = new IKeyFrameDataAnalyzer.KeyFrameMeta();
            this.frameMeta.duration = this.duration;
            this.frameMeta.positions = new long[positionList.size()];
            this.frameMeta.timestamps = new int[timestampList.size()];
            this.frameMeta.audioOnly = true;
            for (int i = 0; i < this.frameMeta.positions.length; ++i) {
                this.frameMeta.positions[i] = (Long)positionList.get(i);
                this.frameMeta.timestamps[i] = ((Float)timestampList.get(i)).intValue();
                this.posTimeMap.put((Long)positionList.get(i), (Float)timestampList.get(i));
            }
            if (frameCache != null) {
                frameCache.saveKeyFrameMeta(this.file, this.frameMeta);
            }
        }
        catch (InterruptedException e) {
            log.warn("Exception acquiring lock", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Exception analyzing frames", (Throwable)e);
        }
        finally {
            this.lock.release();
        }
        log.debug("Analysis complete");
        if (log.isTraceEnabled()) {
            log.trace("{}", (Object)this.frameMeta);
        }
        return this.frameMeta;
    }

    static class MetaData {
        String album;
        String artist;
        String genre;
        String songName;
        String track;
        String year;
        String comment;
        String duration;
        String sampleRate;
        String channels;
        byte[] covr = null;

        MetaData() {
        }

        public String getAlbum() {
            return this.album;
        }

        public void setAlbum(String album) {
            this.album = album;
        }

        public String getArtist() {
            return this.artist;
        }

        public void setArtist(String artist) {
            this.artist = artist;
        }

        public String getGenre() {
            return this.genre;
        }

        public void setGenre(String genre) {
            this.genre = genre;
        }

        public String getSongName() {
            return this.songName;
        }

        public void setSongName(String songName) {
            this.songName = songName;
        }

        public String getTrack() {
            return this.track;
        }

        public void setTrack(String track) {
            this.track = track;
        }

        public String getYear() {
            return this.year;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getDuration() {
            return this.duration;
        }

        public void setDuration(String duration) {
            this.duration = duration;
        }

        public String getSampleRate() {
            return this.sampleRate;
        }

        public void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        public String getChannels() {
            return this.channels;
        }

        public void setChannels(String channels) {
            this.channels = channels;
        }

        public byte[] getCovr() {
            return this.covr;
        }

        public void setCovr(byte[] covr) {
            this.covr = covr;
            log.debug("Cover image array size: {}", (Object)covr.length);
        }

        public boolean hasCoverImage() {
            return this.covr != null;
        }
    }
}

