/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.mp3.impl;

public class MP3Header {
    private static final int[][] BITRATES = new int[][]{{0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, -1}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, -1}, {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, -1}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256, -1}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}};
    private static final int[][] SAMPLERATES = new int[][]{{11025, 12000, 8000, -1}, {-1, -1, -1, -1}, {22050, 24000, 16000, -1}, {44100, 48000, 32000, -1}};
    private int data;
    private byte audioVersionId;
    private byte layerDescription;
    private boolean protectionBit;
    private byte bitRateIndex;
    private byte samplingRateIndex;
    private boolean paddingBit;
    private byte channelMode;

    public MP3Header(int data) throws Exception {
        if ((data & 0xFFE00000) != -2097152) {
            throw new Exception("Invalid frame sync word");
        }
        this.data = data;
        this.audioVersionId = (byte)((data &= 0x1FFFFF) >> 19 & 3);
        this.layerDescription = (byte)(data >> 17 & 3);
        this.protectionBit = (data >> 16 & 1) == 0;
        this.bitRateIndex = (byte)(data >> 12 & 0xF);
        this.samplingRateIndex = (byte)(data >> 10 & 3);
        this.paddingBit = (data >> 9 & 1) != 0;
        this.channelMode = (byte)(data >> 6 & 3);
    }

    public int getData() {
        return this.data;
    }

    public boolean isStereo() {
        return this.channelMode != 3;
    }

    public boolean isProtected() {
        return this.protectionBit;
    }

    public int getBitRate() {
        int result;
        switch (this.audioVersionId) {
            case 1: {
                return -1;
            }
            case 0: 
            case 2: {
                if (this.layerDescription == 3) {
                    result = BITRATES[3][this.bitRateIndex];
                    break;
                }
                if (this.layerDescription == 2 || this.layerDescription == 1) {
                    result = BITRATES[4][this.bitRateIndex];
                    break;
                }
                return -1;
            }
            case 3: {
                if (this.layerDescription == 3) {
                    result = BITRATES[0][this.bitRateIndex];
                    break;
                }
                if (this.layerDescription == 2) {
                    result = BITRATES[1][this.bitRateIndex];
                    break;
                }
                if (this.layerDescription == 1) {
                    result = BITRATES[2][this.bitRateIndex];
                    break;
                }
                return -1;
            }
            default: {
                return -1;
            }
        }
        return result * 1000;
    }

    public int getSampleRate() {
        return SAMPLERATES[this.audioVersionId][this.samplingRateIndex];
    }

    public int frameSize() {
        switch (this.layerDescription) {
            case 3: {
                return (12 * this.getBitRate() / this.getSampleRate() + (this.paddingBit ? 1 : 0)) * 4;
            }
            case 1: 
            case 2: {
                if (this.audioVersionId == 3) {
                    return 144 * this.getBitRate() / this.getSampleRate() + (this.paddingBit ? 1 : 0);
                }
                return 72 * this.getBitRate() / this.getSampleRate() + (this.paddingBit ? 1 : 0);
            }
        }
        return -1;
    }

    public double frameDuration() {
        switch (this.layerDescription) {
            case 3: {
                return 384.0 / ((double)this.getSampleRate() * 0.001);
            }
            case 1: 
            case 2: {
                if (this.audioVersionId == 3) {
                    return 1152.0 / ((double)this.getSampleRate() * 0.001);
                }
                return 576.0 / ((double)this.getSampleRate() * 0.001);
            }
        }
        return -1.0;
    }
}

