/*
 * Decompiled with CFR 0.152.
 */
package org.red5.compatibility.flex.messaging.messages;

import org.red5.compatibility.flex.messaging.messages.AbstractMessage;
import org.red5.io.amf3.ByteArray;
import org.red5.io.amf3.IDataInput;
import org.red5.io.amf3.IDataOutput;
import org.red5.io.utils.RandomGUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncMessage
extends AbstractMessage {
    private static final long serialVersionUID = -3549535089417916783L;
    protected static byte CORRELATION_ID_FLAG = 1;
    protected static byte CORRELATION_ID_BYTES_FLAG = (byte)2;
    public String correlationId;
    protected byte[] correlationIdBytes;
    static Logger log = LoggerFactory.getLogger(AsyncMessage.class);

    @Override
    protected void addParameters(StringBuilder result) {
        super.addParameters(result);
        result.append(",correlationId=");
        result.append(this.correlationId);
    }

    public void setCorrelationId(String id) {
        this.correlationId = id;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public void readExternal(IDataInput in) {
        super.readExternal(in);
        short[] flagsArray = this.readFlags(in);
        for (int i = 0; i < flagsArray.length; ++i) {
            short flags = flagsArray[i];
            int reservedPosition = 0;
            if (i == 0) {
                if ((flags & CORRELATION_ID_FLAG) != 0) {
                    this.correlationId = (String)in.readObject();
                }
                if ((flags & CORRELATION_ID_BYTES_FLAG) != 0) {
                    ByteArray ba = (ByteArray)in.readObject();
                    this.correlationIdBytes = new byte[ba.length()];
                    ba.readBytes(this.correlationIdBytes);
                    this.correlationId = RandomGUID.fromByteArray(this.correlationIdBytes);
                }
                reservedPosition = 2;
            }
            if (flags >> reservedPosition == 0) continue;
            for (int j = reservedPosition; j < 6; j = (int)((short)(j + 1))) {
                if ((flags >> j & 1) == 0) continue;
                in.readObject();
            }
        }
    }

    @Override
    public void writeExternal(IDataOutput output) {
        super.writeExternal(output);
        if (this.correlationIdBytes == null) {
            this.correlationIdBytes = RandomGUID.toByteArray(this.correlationId);
        }
        short flags = 0;
        if (this.correlationId != null && this.correlationIdBytes == null) {
            flags = (short)(flags | CORRELATION_ID_FLAG);
        }
        if (this.correlationIdBytes != null) {
            flags = (short)(flags | CORRELATION_ID_BYTES_FLAG);
        }
        output.writeByte((byte)flags);
        if (this.correlationId != null && this.correlationIdBytes == null) {
            output.writeObject(this.correlationId);
        }
        if (this.correlationIdBytes != null) {
            output.writeObject(this.correlationIdBytes);
        }
    }
}

