/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.mp4;

public class MP4Frame
implements Comparable<MP4Frame> {
    private byte type;
    private long offset;
    private int size;
    private double time;
    private int timeOffset;
    private boolean keyFrame;

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
    }

    public boolean isKeyFrame() {
        return this.keyFrame;
    }

    public void setKeyFrame(boolean keyFrame) {
        this.keyFrame = keyFrame;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MP4Frame other = (MP4Frame)obj;
        if (this.offset != other.offset) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MP4Frame type=");
        sb.append(this.type);
        sb.append(", time=");
        sb.append(this.time);
        sb.append(", timeOffset=");
        sb.append(this.timeOffset);
        sb.append(", size=");
        sb.append(this.size);
        sb.append(", offset=");
        sb.append(this.offset);
        sb.append(", keyframe=");
        sb.append(this.keyFrame);
        return sb.toString();
    }

    @Override
    public int compareTo(MP4Frame that) {
        int ret = 0;
        if (this.time > that.getTime()) {
            ret = 1;
        } else if (this.time < that.getTime()) {
            ret = -1;
        } else if (Double.doubleToLongBits(this.time) == Double.doubleToLongBits(that.getTime()) && this.offset > that.getOffset()) {
            ret = 1;
        } else if (Double.doubleToLongBits(this.time) == Double.doubleToLongBits(that.getTime()) && this.offset < that.getOffset()) {
            ret = -1;
        }
        return ret;
    }
}

