/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.object;

import org.red5.io.object.UnsignedNumber;

public final class UnsignedByte
extends UnsignedNumber {
    static final long serialVersionUID = 1L;
    private short value;

    public UnsignedByte(byte c) {
        this.value = c;
    }

    public UnsignedByte(short c) {
        this.value = (short)(c & 0xFF);
    }

    public UnsignedByte(int c) {
        this.value = (short)(c & 0xFF);
    }

    public UnsignedByte(long c) {
        this.value = (short)(c & 0xFFL);
    }

    private UnsignedByte() {
        this.value = 0;
    }

    public static UnsignedByte fromBytes(byte[] c) {
        return UnsignedByte.fromBytes(c, 0);
    }

    public static UnsignedByte fromBytes(byte[] c, int idx) {
        UnsignedByte number = new UnsignedByte();
        if (c.length - idx < 1) {
            throw new IllegalArgumentException("An UnsignedByte number is composed of 1 byte.");
        }
        number.value = (short)(c[0] & 0xFF);
        return number;
    }

    public static UnsignedByte fromString(String c) {
        return UnsignedByte.fromString(c, 10);
    }

    public static UnsignedByte fromString(String c, int radix) {
        UnsignedByte number = new UnsignedByte();
        short v = Short.parseShort(c, radix);
        number.value = (short)(v & 0xFF);
        return number;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)(this.value & 0xFF);
    }

    @Override
    public int intValue() {
        return this.value & 0xFF;
    }

    @Override
    public long longValue() {
        return (long)this.value & 0xFFL;
    }

    @Override
    public byte[] getBytes() {
        byte[] c = new byte[]{(byte)(this.value & 0xFF)};
        return c;
    }

    @Override
    public int compareTo(UnsignedNumber other) {
        short otherValue = other.shortValue();
        if (this.value > otherValue) {
            return 1;
        }
        if (this.value < otherValue) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (other != null && other instanceof Number) {
            return this.value == ((Number)other).shortValue();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public String toString() {
        return Short.toString(this.value);
    }

    @Override
    public void shiftRight(int nBits) {
        if (Math.abs(nBits) > 8) {
            throw new IllegalArgumentException("Cannot right shift " + nBits + " an UnsignedByte.");
        }
        this.value = (short)(this.value >>> nBits);
    }

    @Override
    public void shiftLeft(int nBits) {
        if (Math.abs(nBits) > 8) {
            throw new IllegalArgumentException("Cannot left shift " + nBits + " an UnsignedByte.");
        }
        this.value = (short)(this.value << nBits);
    }
}

