/*
 * Decompiled with CFR 0.152.
 */
package org.red5.compatibility.flex.messaging.messages;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.red5.compatibility.flex.messaging.messages.Message;
import org.red5.io.amf3.ByteArray;
import org.red5.io.amf3.IDataInput;
import org.red5.io.amf3.IDataOutput;
import org.red5.io.utils.ObjectMap;
import org.red5.io.utils.RandomGUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMessage
implements Message,
Serializable {
    private static final long serialVersionUID = -834697863344344313L;
    public long timestamp;
    public Map<String, Object> headers = new ObjectMap<String, Object>();
    public Object body;
    public String messageId;
    protected byte[] messageIdBytes;
    public long timeToLive;
    public String clientId;
    protected byte[] clientIdBytes;
    public String destination;
    static Logger log = LoggerFactory.getLogger(AbstractMessage.class);

    public AbstractMessage() {
        this.timestamp = System.currentTimeMillis();
        this.messageId = UUID.randomUUID().toString();
    }

    protected void addParameters(StringBuilder result) {
        result.append("ts=");
        result.append(this.timestamp);
        result.append(",headers=");
        result.append(this.headers);
        result.append(",body=");
        result.append(this.body);
        result.append(",messageId=");
        result.append(this.messageId);
        result.append(",timeToLive=");
        result.append(this.timeToLive);
        result.append(",clientId=");
        result.append(this.clientId);
        result.append(",destination=");
        result.append(this.destination);
    }

    @Override
    public Object getBody() {
        return this.body;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    @Override
    public Object getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public boolean headerExists(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public void setBody(Object value) {
        this.body = value;
    }

    @Override
    public void setClientId(String value) {
        this.clientId = value;
    }

    @Override
    public void setDestination(String value) {
        this.destination = value;
    }

    @Override
    public void setHeader(String name, Object value) {
        this.headers.put(name, value);
    }

    @Override
    public void setHeaders(Map<String, Object> value) {
        if (!this.headers.isEmpty()) {
            this.headers.clear();
        }
        this.headers.putAll(value);
    }

    @Override
    public void setMessageId(String value) {
        this.messageId = value;
    }

    @Override
    public void setTimestamp(long value) {
        this.timestamp = value;
    }

    @Override
    public void setTimeToLive(long value) {
        this.timeToLive = value;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName());
        result.append('(');
        this.addParameters(result);
        result.append(')');
        return result.toString();
    }

    protected short[] readFlags(IDataInput input) {
        boolean hasNextFlag = true;
        short[] flagsArray = new short[2];
        int i = 0;
        while (hasNextFlag) {
            short flags = (short)input.readUnsignedByte();
            log.debug("Unsigned byte: {}", (Object)flags);
            if (i == flagsArray.length) {
                short[] tempArray = new short[i * 2];
                System.arraycopy(flagsArray, 0, tempArray, 0, flagsArray.length);
                flagsArray = tempArray;
            }
            flagsArray[i] = flags;
            hasNextFlag = (flags & 0x80) != 0;
            ++i;
        }
        log.debug("Flag count: {}", (Object)flagsArray.length);
        return flagsArray;
    }

    public void readExternal(IDataInput input) {
        log.debug("AbstractMessage - Read external");
        short[] flagsArray = this.readFlags(input);
        for (int i = 0; i < flagsArray.length; ++i) {
            short flags = flagsArray[i];
            int reservedPosition = 0;
            if (i == 0) {
                Object obj;
                if ((flags & 1) != 0) {
                    obj = input.readObject();
                    log.debug("Body object: {} name: {}", obj, (Object)obj.getClass().getName());
                    this.body = obj;
                }
                if ((flags & 2) != 0) {
                    obj = input.readObject();
                    log.debug("Client id object: {} name: {}", obj, (Object)obj.getClass().getName());
                    this.clientId = (String)obj;
                }
                if ((flags & 4) != 0) {
                    obj = input.readObject();
                    log.debug("Destination object: {} name: {}", obj, (Object)obj.getClass().getName());
                    this.destination = (String)obj;
                }
                if ((flags & 8) != 0) {
                    obj = input.readObject();
                    log.debug("Headers object: {} name: {}", obj, (Object)obj.getClass().getName());
                    this.headers = (ObjectMap)obj;
                }
                if ((flags & 0x10) != 0) {
                    obj = input.readUTF();
                    log.debug("Message id object: {} name: {}", obj, (Object)obj.getClass().getName());
                    this.messageId = (String)obj;
                }
                if ((flags & 0x20) != 0) {
                    obj = input.readObject();
                    log.debug("Timestamp object: {} name: {}", obj, (Object)obj.getClass().getName());
                    this.timestamp = ((Number)obj).longValue();
                }
                if ((flags & 0x40) != 0) {
                    obj = input.readObject();
                    log.debug("TTL object: {} name: {}", obj, (Object)obj.getClass().getName());
                    this.timeToLive = ((Number)obj).longValue();
                }
                reservedPosition = 7;
            } else if (i == 1) {
                ByteArray ba;
                if ((flags & 1) != 0) {
                    Object obj = input.readObject();
                    log.debug("Client id (bytes) object: {} name: {}", obj, (Object)obj.getClass().getName());
                    if (obj instanceof ByteArray) {
                        ba = (ByteArray)obj;
                        this.clientIdBytes = new byte[ba.length()];
                        ba.readBytes(this.clientIdBytes);
                        this.clientId = RandomGUID.fromByteArray(this.clientIdBytes);
                    }
                }
                if ((flags & 2) != 0) {
                    Object obj = input.readObject();
                    log.debug("Message id (bytes) object: {} name: {}", obj, (Object)obj.getClass().getName());
                    if (obj instanceof ByteArray) {
                        ba = (ByteArray)obj;
                        this.messageIdBytes = new byte[ba.length()];
                        ba.readBytes(this.messageIdBytes);
                        this.messageId = RandomGUID.fromByteArray(this.messageIdBytes);
                    }
                }
                reservedPosition = 2;
            }
            if (flags >> reservedPosition == 0) continue;
            for (int j = reservedPosition; j < 6; j = (int)((short)(j + 1))) {
                if ((flags >> j & 1) == 0) continue;
                input.readObject();
            }
        }
    }

    public void writeExternal(IDataOutput output) {
        short flags = 0;
        if (this.clientIdBytes == null) {
            this.clientIdBytes = (byte[])(this.clientId == null ? null : RandomGUID.toByteArray(this.clientId));
        }
        if (this.messageIdBytes == null) {
            this.messageIdBytes = (byte[])(this.messageId == null ? null : RandomGUID.toByteArray(this.messageId));
        }
        if (this.body != null) {
            flags = (short)(flags | 1);
        }
        if (this.clientId != null && this.clientIdBytes == null) {
            flags = (short)(flags | 2);
        }
        if (this.destination != null) {
            flags = (short)(flags | 4);
        }
        if (this.headers != null) {
            flags = (short)(flags | 8);
        }
        if (this.messageId != null && this.messageIdBytes == null) {
            flags = (short)(flags | 0x10);
        }
        if (this.timestamp != 0L) {
            flags = (short)(flags | 0x20);
        }
        if (this.timeToLive != 0L) {
            flags = (short)(flags | 0x40);
        }
        if (this.clientIdBytes != null || this.messageIdBytes != null) {
            flags = (short)(flags | 0x80);
        }
        output.writeByte((byte)flags);
        flags = 0;
        if (this.clientIdBytes != null) {
            flags = (short)(flags | 1);
        }
        if (this.messageIdBytes != null) {
            flags = (short)(flags | 2);
        }
        if (flags != 0) {
            output.writeByte((byte)flags);
        }
        if (this.body != null) {
            output.writeObject(this.body);
        }
        if (this.clientId != null && this.clientIdBytes == null) {
            output.writeUTF(this.clientId);
        }
        if (this.destination != null) {
            output.writeUTF(this.destination);
        }
        if (this.headers != null) {
            output.writeObject(this.headers);
        }
        if (this.messageId != null && this.messageIdBytes == null) {
            output.writeUTF(this.messageId);
        }
        if (this.timestamp != 0L) {
            output.writeObject(this.timestamp);
        }
        if (this.timeToLive != 0L) {
            output.writeObject(this.timeToLive);
        }
        if (this.clientIdBytes != null) {
            output.writeObject(this.clientIdBytes);
        }
        if (this.messageIdBytes != null) {
            output.writeObject(this.messageIdBytes);
        }
    }
}

