/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.object;

import java.lang.reflect.Type;
import org.red5.io.object.DataTypes;
import org.red5.io.object.Input;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deserializer {
    private static final Logger log = LoggerFactory.getLogger(Deserializer.class);

    private Deserializer() {
    }

    public static <T> T deserialize(Input in, Type target) {
        byte type = in.readDataType();
        if (log.isTraceEnabled()) {
            log.trace("Type: {} target: {}", (Object)type, (Object)(target != null ? target.toString() : "Target not specified"));
        }
        if (log.isDebugEnabled()) {
            log.debug("Datatype: {}", (Object)DataTypes.toStringValue(type));
        }
        Object result = null;
        switch (type) {
            case 1: {
                result = in.readNull();
                break;
            }
            case 2: {
                result = in.readBoolean();
                break;
            }
            case 3: {
                result = in.readNumber();
                break;
            }
            case 4: {
                try {
                    if (target != null && ((Class)target).isEnum()) {
                        log.warn("Enum target specified");
                        String name = in.readString();
                        result = Enum.valueOf((Class)target, name);
                        break;
                    }
                    result = in.readString();
                    break;
                }
                catch (RuntimeException e) {
                    log.error("failed to deserialize {}", (Object)target, (Object)e);
                    throw e;
                }
            }
            case 5: {
                result = in.readDate();
                break;
            }
            case 6: {
                result = in.readArray(target);
                break;
            }
            case 7: {
                result = in.readMap();
                break;
            }
            case 8: {
                result = in.readXML();
                break;
            }
            case 9: {
                result = in.readObject();
                break;
            }
            case 16: {
                result = in.readByteArray();
                break;
            }
            case 61: {
                result = in.readVectorInt();
                break;
            }
            case 62: {
                result = in.readVectorUInt();
                break;
            }
            case 63: {
                result = in.readVectorNumber();
                break;
            }
            case 64: {
                result = in.readVectorObject();
                break;
            }
            case 17: {
                result = in.readReference();
                break;
            }
            case -1: {
                log.debug("End-of-object detected");
                break;
            }
            default: {
                result = in.readCustom();
            }
        }
        return (T)result;
    }
}

