/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf3;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.amf.AMF;
import org.red5.io.amf3.ByteArray;
import org.red5.io.amf3.DataInput;
import org.red5.io.amf3.IExternalizable;
import org.red5.io.object.Deserializer;
import org.red5.io.utils.ArrayUtils;
import org.red5.io.utils.ConversionUtils;
import org.red5.io.utils.ObjectMap;
import org.red5.io.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Input
extends org.red5.io.amf.Input
implements org.red5.io.object.Input {
    private int amf3_mode;
    private RefStorage refStorage;

    public Input(IoBuffer buf) {
        this(buf, new RefStorage());
    }

    public Input(IoBuffer buf, RefStorage refStorage) {
        super(buf);
        this.refStorage = refStorage;
        this.refMap = refStorage.refMap;
    }

    public void enforceAMF3() {
        ++this.amf3_mode;
    }

    protected IoBuffer getBuffer() {
        return this.buf;
    }

    @Override
    public byte readDataType() {
        this.log.trace("readDataType - amf3_mode: {}", (Object)this.amf3_mode);
        byte coreType = 0;
        if (this.buf != null) {
            this.currentDataType = this.buf.get();
            this.log.debug("Current data type: {}", (Object)this.currentDataType);
            switch (this.currentDataType) {
                case 17: {
                    this.log.trace("Got AMF3 object indicator");
                    this.amf3_mode = 1;
                    this.currentDataType = this.buf.get();
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    this.log.trace("Assuming Vector type");
                    this.amf3_mode = 1;
                }
            }
            if (this.amf3_mode == 0) {
                switch (this.currentDataType) {
                    case 5: 
                    case 6: {
                        return 1;
                    }
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: 
                    case 12: {
                        return 4;
                    }
                    case 3: 
                    case 16: {
                        return 9;
                    }
                    case 8: {
                        return 7;
                    }
                    case 10: {
                        return 6;
                    }
                    case 11: {
                        return 5;
                    }
                    case 15: {
                        return 8;
                    }
                    case 7: {
                        return 17;
                    }
                }
            }
            this.log.debug("Current data type (after amf checks): {}", (Object)this.currentDataType);
            switch (this.currentDataType) {
                case 0: 
                case 1: {
                    coreType = 1;
                    break;
                }
                case 4: 
                case 5: {
                    coreType = 3;
                    break;
                }
                case 2: 
                case 3: {
                    coreType = 2;
                    break;
                }
                case 6: {
                    coreType = 4;
                    break;
                }
                case 7: 
                case 11: {
                    coreType = 8;
                    break;
                }
                case 10: {
                    coreType = 9;
                    break;
                }
                case 9: {
                    coreType = 6;
                    break;
                }
                case 8: {
                    coreType = 5;
                    break;
                }
                case 12: {
                    coreType = 16;
                    break;
                }
                case 13: {
                    coreType = 61;
                    break;
                }
                case 14: {
                    coreType = 62;
                    break;
                }
                case 15: {
                    coreType = 63;
                    break;
                }
                case 16: {
                    coreType = 64;
                    break;
                }
                default: {
                    this.log.info("Unknown datatype: {}", (Object)this.currentDataType);
                    coreType = 0;
                }
            }
            this.log.debug("Core type: {}", (Object)coreType);
        } else {
            this.log.error("Why is buf null?");
        }
        return coreType;
    }

    @Override
    public Object readNull() {
        return null;
    }

    @Override
    public Boolean readBoolean() {
        return this.currentDataType == 3 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Number readNumber() {
        if (this.buf.hasRemaining()) {
            int remaining = this.buf.remaining();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Remaining bytes for Number: {}", (Object)remaining);
            }
            Number v = this.currentDataType == 5 ? (Number)(remaining >= 8 ? (Number)this.buf.getDouble() : (Number)this.buf.getInt()) : (Number)this.readInteger();
            if (this.log.isTraceEnabled()) {
                this.log.trace("readNumber - value: {}", (Object)v);
            }
            return v;
        }
        this.log.warn("No remaining bytes for buffer readNumber");
        return null;
    }

    @Override
    public String readString() {
        String string;
        this.log.trace("readString - amf3_mode: {}", (Object)this.amf3_mode);
        if (this.currentDataType == 6 || this.amf3_mode > 0) {
            int len = this.readInteger();
            this.log.debug("readString - length: {}", (Object)len);
            if (len == 1) {
                return "";
            }
            if ((len & 1) == 0) {
                if (this.refStorage.stringReferences.isEmpty()) {
                    this.log.debug("String reference list is empty");
                }
                return (String)this.refStorage.stringReferences.get(len >> 1);
            }
            this.log.debug("readString - new length: {}", (Object)(len >>= 1));
            int limit = this.buf.limit();
            this.log.debug("readString - limit: {}", (Object)limit);
            ByteBuffer strBuf = this.buf.buf();
            strBuf.limit(strBuf.position() + len);
            string = AMF.CHARSET.decode(strBuf).toString();
            this.log.debug("String: {}", (Object)string);
            this.buf.limit(limit);
            this.refStorage.stringReferences.add(string);
        } else {
            string = super.readString();
        }
        return string;
    }

    public String readString(int length) {
        this.log.debug("readString - length: {}", (Object)length);
        int limit = this.buf.limit();
        ByteBuffer strBuf = this.buf.buf();
        strBuf.limit(strBuf.position() + length);
        String string = AMF.CHARSET.decode(strBuf).toString();
        this.log.debug("String: {}", (Object)string);
        this.buf.limit(limit);
        byte b = this.buf.get();
        if (b != 0) {
            this.buf.position(this.buf.position() - 1);
        }
        return string;
    }

    public RefStorage getRefStorage() {
        return this.refStorage;
    }

    @Override
    public String getString() {
        return this.readString();
    }

    @Override
    public Date readDate() {
        int ref = this.readInteger();
        if ((ref & 1) == 0) {
            return (Date)this.getReference(ref >> 1);
        }
        long ms = (long)this.buf.getDouble();
        Date date = new Date(ms);
        this.storeReference(date);
        return date;
    }

    @Override
    public Object readArray(Type target) {
        Cloneable result;
        Object ref;
        int count = this.readInteger();
        this.log.debug("Count: {} and {} ref {}", new Object[]{count, count & 1, count >> 1});
        if ((count & 1) == 0 && (ref = this.getReference(count >> 1)) != null) {
            return ref;
        }
        count >>= 1;
        String key = this.readString();
        ++this.amf3_mode;
        if (key.equals("")) {
            Object value;
            Class nested = Object.class;
            Class collection = Collection.class;
            if (target instanceof ParameterizedType) {
                ParameterizedType t = (ParameterizedType)target;
                Type[] actualTypeArguments = t.getActualTypeArguments();
                if (actualTypeArguments.length == 1) {
                    nested = (Class)actualTypeArguments[0];
                }
                target = t.getRawType();
            }
            if (target instanceof Class) {
                collection = (Class)target;
            }
            if (collection.isArray()) {
                nested = ArrayUtils.getGenericType(collection.getComponentType());
                result = Array.newInstance(nested, count);
                this.storeReference(result);
                for (int i = 0; i < count; ++i) {
                    value = Deserializer.deserialize(this, nested);
                    Array.set(result, i, value);
                }
            } else {
                AbstractCollection resultCollection = SortedSet.class.isAssignableFrom(collection) ? new TreeSet() : (Set.class.isAssignableFrom(collection) ? new HashSet(count) : new ArrayList(count));
                result = resultCollection;
                this.storeReference(result);
                for (int i = 0; i < count; ++i) {
                    value = Deserializer.deserialize(this, nested);
                    resultCollection.add(value);
                }
            }
        } else {
            HashMap resultMap;
            Class v = Object.class;
            Class collection = Collection.class;
            if (target instanceof ParameterizedType) {
                ParameterizedType t = (ParameterizedType)target;
                Type[] actualTypeArguments = t.getActualTypeArguments();
                if (actualTypeArguments.length == 2) {
                    v = (Class)actualTypeArguments[1];
                }
                target = t.getRawType();
            }
            if (target instanceof Class) {
                collection = (Class<TreeMap>)((Object)target);
            }
            collection = SortedMap.class.isAssignableFrom(collection) ? TreeMap.class : HashMap.class;
            try {
                resultMap = (HashMap)collection.newInstance();
            }
            catch (Exception e) {
                resultMap = new HashMap(count);
            }
            this.storeReference(resultMap);
            while (!key.equals("")) {
                Object value = Deserializer.deserialize(this, v);
                resultMap.put(key, value);
                key = this.readString();
            }
            for (int i = 0; i < count; ++i) {
                Object value = Deserializer.deserialize(this, v);
                resultMap.put(i, value);
            }
            result = resultMap;
        }
        --this.amf3_mode;
        return result;
    }

    @Override
    public Object readMap() {
        return super.readMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object readObject() {
        String className;
        this.log.trace("readObject - amf3_mode: {}", (Object)this.amf3_mode);
        int type = this.readInteger();
        this.log.debug("Type: {} and {} ref {}", new Object[]{type, type & 1, type >> 1});
        if ((type & 1) == 0) {
            Object ref = this.getReference(type >> 1);
            if (ref != null) {
                return ref;
            }
            byte b = this.buf.get();
            if (b == 7) {
                this.log.debug("BEL: {}", (Object)b);
            } else {
                this.log.debug("Non-BEL byte: {} extra byte: {}", (Object)b, (Object)this.buf.get());
            }
        }
        AbstractList attributes = null;
        Object result = null;
        boolean inlineClass = ((type >>= 1) & 1) == 1;
        this.log.debug("Class is in-line? {}", (Object)inlineClass);
        if (!inlineClass) {
            ClassReference info = (ClassReference)this.refStorage.classReferences.get(type >> 1);
            className = info.className;
            attributes = info.attributeNames;
            type = info.type;
            if (attributes != null) {
                type |= attributes.size() << 2;
            }
        } else {
            className = this.readString();
            this.log.debug("Type: {} classname: {}", (Object)(type >>= 1), (Object)className);
            if (classAliases.containsKey(className)) {
                type = 1;
            } else if (className.startsWith("flex")) {
                if (className.endsWith("CommandMessage")) {
                    attributes = new LinkedList<String>(){
                        {
                            this.add("timestamp");
                            this.add("headers");
                            this.add("operation");
                            this.add("body");
                            this.add("correlationId");
                            this.add("messageId");
                            this.add("timeToLive");
                            this.add("clientId");
                            this.add("destination");
                        }
                    };
                } else {
                    this.log.debug("Attributes for {} were not set", (Object)className);
                }
            }
        }
        ++this.amf3_mode;
        Object instance = this.newInstance(className);
        ObjectMap properties = null;
        PendingObject pending = new PendingObject();
        int tempRefId = this.storeReference(pending);
        this.log.debug("Object type: {}", (Object)(type & 3));
        block2 : switch (type & 3) {
            case 0: {
                void var11_17;
                this.log.debug("Detected: Object property type");
                int count = type >> 2;
                this.log.debug("Count: {}", (Object)count);
                if (attributes == null) {
                    void var11_15;
                    attributes = new ArrayList(count);
                    boolean bl = false;
                    while (var11_15 < count) {
                        attributes.add(this.readString());
                        ++var11_15;
                    }
                    this.refStorage.classReferences.add(new ClassReference(className, 0, attributes));
                }
                properties = new ObjectMap();
                boolean bl = false;
                while (var11_17 < count) {
                    String name = (String)attributes.get((int)var11_17);
                    properties.put(name, Deserializer.deserialize(this, this.getPropertyType(instance, name)));
                    ++var11_17;
                }
                break;
            }
            case 1: {
                this.log.debug("Detected: Externalizable type");
                if ("".equals(className)) {
                    throw new RuntimeException("Classname is required to load an Externalizable object");
                }
                this.log.debug("Externalizable class: {}", (Object)className);
                if (className.length() == 3) {
                    className = (String)classAliases.get(className);
                }
                if ((result = this.newInstance(className)) == null) {
                    throw new RuntimeException(String.format("Could not instantiate class: %s", className));
                }
                if (!(result instanceof IExternalizable)) {
                    throw new RuntimeException(String.format("Class must implement the IExternalizable interface: %s", className));
                }
                this.refStorage.classReferences.add(new ClassReference(className, 1, null));
                this.storeReference(tempRefId, result);
                ((IExternalizable)result).readExternal(new DataInput(this));
                break;
            }
            case 2: {
                void var11_23;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Detected: Object value type");
                }
                int count = type >> 2;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Count: {}", (Object)count);
                }
                if (attributes == null) {
                    void var11_19;
                    attributes = new ArrayList(count);
                    boolean bl = false;
                    while (var11_19 < count) {
                        attributes.add(this.readString());
                        ++var11_19;
                    }
                }
                if (count == 0 && attributes != null) {
                    count = attributes.size();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Using class attribute size for property count: {}", (Object)count);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>(count);
                    for (int i = 0; i < count; ++i) {
                        arrayList.add(this.readString());
                    }
                    if (this.log.isDebugEnabled() && count != arrayList.size()) {
                        this.log.debug("Count and attributes length does not match!");
                    }
                }
                this.refStorage.classReferences.add(new ClassReference(className, 2, attributes));
                properties = new ObjectMap();
                for (String key : attributes) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Looking for property: {}", (Object)key);
                    }
                    Object value = Deserializer.deserialize(this, this.getPropertyType(instance, key));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Key: {} Value: {}", (Object)key, value);
                    }
                    properties.put(key, value);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Buffer - position: {} limit: {}", (Object)this.buf.position(), (Object)this.buf.limit());
                }
                if (!this.buf.hasRemaining()) break;
                String string = this.readString();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Looking for property: {}", (Object)string);
                }
                while (!"".equals(var11_23)) {
                    Object value = Deserializer.deserialize(this, this.getPropertyType(instance, (String)var11_23));
                    properties.put(var11_23, value);
                    if (!this.buf.hasRemaining()) break block2;
                    String string2 = this.readString();
                }
                break;
            }
            default: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Detected: Object proxy type");
                }
                if ("".equals(className)) {
                    throw new RuntimeException("Classname is required to load an Externalizable object");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Externalizable class: {}", (Object)className);
                }
                if ((result = this.newInstance(className)) == null) {
                    throw new RuntimeException(String.format("Could not instantiate class: %s", className));
                }
                if (!(result instanceof IExternalizable)) {
                    throw new RuntimeException(String.format("Class must implement the IExternalizable interface: %s", className));
                }
                this.refStorage.classReferences.add(new ClassReference(className, 3, null));
                this.storeReference(tempRefId, result);
                ((IExternalizable)result).readExternal(new DataInput(this));
            }
        }
        --this.amf3_mode;
        if (result == null) {
            if ("".equals(className)) {
                for (Map.Entry entry : properties.entrySet()) {
                    if (entry.getValue() != pending) continue;
                    entry.setValue(properties);
                }
                this.storeReference(tempRefId, properties);
                result = properties;
            } else {
                if ("RecordSet".equals(className)) {
                    throw new RuntimeException("Objects of type RecordSet not supported yet.");
                }
                if ("RecordSetPage".equals(className)) {
                    throw new RuntimeException("Objects of type RecordSetPage not supported yet.");
                }
                result = this.newInstance(className);
                if (result != null) {
                    this.storeReference(tempRefId, result);
                    Class<?> resultClass = result.getClass();
                    pending.resolveProperties(result);
                    for (Map.Entry entry : properties.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (value == pending) {
                            value = result;
                        }
                        if (value instanceof PendingObject) {
                            ((PendingObject)value).addPendingProperty(result, resultClass, key);
                            continue;
                        }
                        if (value != null) {
                            try {
                                Field field = resultClass.getField(key);
                                Class<?> fieldType = field.getType();
                                if (!fieldType.isAssignableFrom(value.getClass())) {
                                    value = ConversionUtils.convert(value, fieldType);
                                } else if (value instanceof Enum) {
                                    value = Enum.valueOf(fieldType, value.toString());
                                }
                                field.set(result, value);
                            }
                            catch (Exception e) {
                                try {
                                    BeanUtils.setProperty(result, (String)key, value);
                                }
                                catch (IllegalAccessException ex) {
                                    this.log.warn("Error mapping key: {} value: {}", (Object)key, value);
                                }
                                catch (InvocationTargetException ex) {
                                    this.log.warn("Error mapping key: {} value: {}", (Object)key, value);
                                }
                            }
                            continue;
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Skipping null property: {}", (Object)key);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public ByteArray readByteArray() {
        int type = this.readInteger();
        if ((type & 1) == 0) {
            return (ByteArray)this.getReference(type >> 1);
        }
        ByteArray result = new ByteArray(this.buf, type >>= 1);
        this.storeReference(result);
        return result;
    }

    @Override
    public Vector<Integer> readVectorInt() {
        this.log.debug("readVectorInt");
        int type = this.readInteger();
        if ((type & 1) == 0) {
            return (Vector)this.getReference(type >> 1);
        }
        int len = type >> 1;
        Vector<Integer> array = new Vector<Integer>(len);
        this.storeReference(array);
        int ref2 = this.readInteger();
        for (int j = 0; j < len; ++j) {
            array.add(this.buf.getInt());
        }
        return array;
    }

    @Override
    public Vector<Long> readVectorUInt() {
        this.log.debug("readVectorUInt");
        int type = this.readInteger();
        if ((type & 1) == 0) {
            return (Vector)this.getReference(type >> 1);
        }
        int len = type >> 1;
        Vector<Long> array = new Vector<Long>(len);
        this.storeReference(array);
        int ref2 = this.readInteger();
        for (int j = 0; j < len; ++j) {
            long value = (this.buf.get() & 0xFF) << 24;
            value += (long)((this.buf.get() & 0xFF) << 16);
            value += (long)((this.buf.get() & 0xFF) << 8);
            array.add(value += (long)(this.buf.get() & 0xFF));
        }
        return array;
    }

    @Override
    public Vector<Double> readVectorNumber() {
        this.log.debug("readVectorNumber");
        int type = this.readInteger();
        this.log.debug("Type: {}", (Object)type);
        if ((type & 1) == 0) {
            return (Vector)this.getReference(type >> 1);
        }
        int len = type >> 1;
        this.log.debug("Length: {}", (Object)len);
        Vector<Double> array = new Vector<Double>(len);
        this.storeReference(array);
        int ref2 = this.readInteger();
        this.log.debug("Ref2: {}", (Object)ref2);
        for (int j = 0; j < len; ++j) {
            Double d = this.buf.getDouble();
            this.log.debug("Double: {}", (Object)d);
            array.add(d);
        }
        return array;
    }

    @Override
    public Vector<Object> readVectorObject() {
        this.log.debug("readVectorObject");
        int type = this.readInteger();
        this.log.debug("Type: {}", (Object)type);
        if ((type & 1) == 0) {
            return (Vector)this.getReference(type >> 1);
        }
        int len = type >> 1;
        this.log.debug("Length: {}", (Object)len);
        Vector<Object> array = new Vector<Object>(len);
        this.storeReference(array);
        int ref2 = this.readInteger();
        this.log.debug("Ref2: {}", (Object)ref2);
        this.buf.skip(1);
        Object object = null;
        for (int j = 0; j < len; ++j) {
            byte objectType = this.buf.get();
            this.log.debug("Object type: {}", (Object)objectType);
            switch (objectType) {
                case 0: 
                case 1: {
                    object = null;
                    break;
                }
                case 6: {
                    object = this.readString();
                    break;
                }
                case 5: {
                    object = this.readNumber();
                    break;
                }
                case 4: {
                    object = this.readInteger();
                    break;
                }
                case 12: {
                    object = this.readByteArray();
                    break;
                }
                case 13: {
                    object = this.readVectorInt();
                    break;
                }
                case 14: {
                    object = this.readVectorUInt();
                    break;
                }
                case 15: {
                    object = this.readVectorNumber();
                    break;
                }
                case 16: {
                    object = this.readVectorObject();
                    break;
                }
                default: {
                    object = this.readObject();
                }
            }
            array.add(object);
        }
        this.log.debug("Vector: {}", array);
        return array;
    }

    @Override
    public Object readCustom() {
        return null;
    }

    @Override
    public Object readReference() {
        throw new RuntimeException("AMF3 doesn't support direct references.");
    }

    private int readInteger() {
        byte b = this.buf.get();
        if (this.buf.hasRemaining()) {
            int n;
            int result = 0;
            for (n = 0; (b & 0x80) != 0 && n < 3; ++n) {
                result <<= 7;
                result |= b & 0x7F;
                b = this.buf.get();
            }
            if (n < 3) {
                result <<= 7;
                result |= b;
            } else {
                result <<= 8;
                if (((result |= b & 0xFF) & 0x10000000) != 0) {
                    result |= 0xE0000000;
                }
            }
            return result;
        }
        return b;
    }

    private int readAMF3IntegerNew() {
        int b = this.buf.get() & 0xFF;
        if (b < 128) {
            return b;
        }
        int value = (b & 0x7F) << 7;
        b = this.buf.get() & 0xFF;
        if (b < 128) {
            return value | b;
        }
        value = (value | b & 0x7F) << 7;
        b = this.buf.get() & 0xFF;
        if (b < 128) {
            return value | b;
        }
        value = (value | b & 0x7F) << 8;
        b = this.buf.get() & 0xFF;
        return value | b;
    }

    @Override
    public Document readXML() {
        int len = this.readInteger();
        if (len == 1) {
            return null;
        }
        if ((len & 1) == 0) {
            return (Document)this.getReference(len >> 1);
        }
        int limit = this.buf.limit();
        ByteBuffer strBuf = this.buf.buf();
        strBuf.limit(strBuf.position() + (len >>= 1));
        String xmlString = AMF.CHARSET.decode(strBuf).toString();
        this.buf.limit(limit);
        Document doc = null;
        try {
            doc = XMLUtils.stringToDoc(xmlString);
        }
        catch (IOException ioex) {
            this.log.error("IOException converting xml to dom", (Throwable)ioex);
        }
        this.storeReference(doc);
        return doc;
    }

    @Override
    public void reset() {
        super.reset();
    }

    public static class RefStorage {
        private List<ClassReference> classReferences = new ArrayList<ClassReference>();
        private List<String> stringReferences = new ArrayList<String>();
        private ConcurrentMap<Integer, Object> refMap = new ConcurrentHashMap<Integer, Object>(4);
    }

    protected static class PendingObject {
        private static Logger log = LoggerFactory.getLogger(PendingObject.class);
        private List<PendingProperty> properties;

        public PendingObject() {
            if (log.isDebugEnabled()) {
                log.debug("PendingObject");
            }
        }

        public void addPendingProperty(Object obj, Class<?> klass, String name) {
            if (this.properties == null) {
                this.properties = new ArrayList<PendingProperty>();
            }
            this.properties.add(new PendingProperty(obj, klass, name));
        }

        public void resolveProperties(Object result) {
            if (this.properties != null) {
                for (PendingProperty prop : this.properties) {
                    try {
                        prop.klass.getField(prop.name).set(prop.obj, result);
                    }
                    catch (Exception e) {
                        try {
                            BeanUtils.setProperty((Object)prop.obj, (String)prop.name, (Object)result);
                        }
                        catch (Exception ex) {
                            log.warn("Error mapping property: {} ({})", (Object)prop.name, result);
                        }
                    }
                }
            } else {
                return;
            }
            this.properties.clear();
        }

        static final class PendingProperty {
            Object obj;
            Class<?> klass;
            String name;

            PendingProperty(Object obj, Class<?> klass, String name) {
                if (log.isDebugEnabled()) {
                    log.debug("Pending property - obj: {} class: {} name: {}", new Object[]{obj, klass, name});
                }
                this.obj = obj;
                this.klass = klass;
                this.name = name;
            }
        }
    }

    protected static class ClassReference {
        private static Logger log = LoggerFactory.getLogger(ClassReference.class);
        protected String className;
        protected int type;
        protected List<String> attributeNames;

        public ClassReference(String className, int type, List<String> attributeNames) {
            if (log.isDebugEnabled()) {
                log.debug("Class reference - className: {} type: {} attributeNames: {}", new Object[]{className, type, attributeNames});
            }
            this.className = className;
            this.type = type;
            this.attributeNames = attributeNames;
        }
    }
}

