/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.red5.io.utils.DOM2Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XMLUtils {
    protected static Logger log = LoggerFactory.getLogger(XMLUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document stringToDoc(String str) throws IOException {
        if (!StringUtils.isNotEmpty((CharSequence)str)) throw new IOException("Error - could not convert empty string to doc");
        try (StringReader reader = new StringReader(str);){
            Document doc;
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = doc = db.parse(new InputSource(reader));
            return document;
        }
        catch (Exception ex) {
            log.debug("String: {}", (Object)str);
            throw new IOException(String.format("Error converting from string to doc %s", ex.getMessage()));
        }
    }

    public static String docToString(Document dom) {
        return XMLUtils.docToString1(dom);
    }

    public static String docToString1(Document dom) {
        StringWriter sw = new StringWriter();
        DOM2Writer.serializeAsXML(dom, sw);
        return sw.toString();
    }

    public static String docToString2(Document domDoc) throws IOException {
        try {
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer();
            trans.setOutputProperty("indent", "no");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            trans.transform(new DOMSource(domDoc), result);
            return sw.toString();
        }
        catch (Exception ex) {
            throw new IOException(String.format("Error converting from doc to string %s", ex.getMessage()));
        }
    }
}

