/*
 * Decompiled with CFR 0.152.
 */
package org.red5.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AbstractVideo;
import org.red5.codec.IVideoStreamCodec;
import org.red5.codec.VideoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VP8Video
extends AbstractVideo {
    private static Logger log = LoggerFactory.getLogger(VP8Video.class);
    static final String CODEC_NAME = "VP8";
    public static final byte[] VP8_KEYFRAME_PREFIX = new byte[]{24, 1};
    public static final byte[] VP8_FRAME_PREFIX = new byte[]{40, 1};
    private static final byte I_BIT = -128;
    private static final byte K_BIT = 16;
    private static final byte L_BIT = 64;
    private static final byte M_BIT = -128;
    public static final int MAX_LENGTH = 6;
    private static final byte S_BIT = 16;
    private static final byte T_BIT = 32;
    private static final byte X_BIT = -128;

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public boolean canDropFrames() {
        return true;
    }

    @Override
    public boolean canHandleData(IoBuffer data) {
        if (data.hasRemaining()) {
            byte first = data.get();
            data.rewind();
            return (first & 0xF) == VideoCodec.VP8.getId();
        }
        return false;
    }

    @Override
    public boolean addData(IoBuffer data, int timestamp) {
        return this.addData(data, timestamp, true);
    }

    @Override
    public boolean addData(IoBuffer data, int timestamp, boolean amf) {
        log.trace("addData timestamp: {} remaining: {} amf? {}", new Object[]{timestamp, data.remaining(), amf});
        if (data.hasRemaining()) {
            int start = data.position();
            if (!amf) {
                int remaining = data.remaining();
                if (remaining > 7) {
                    byte[] peek = new byte[8];
                    data.get(peek);
                    boolean isKey = VP8Video.isKeyFrame(peek, 0);
                    data.position(start);
                    IoBuffer slice = data.getSlice(start, remaining);
                    log.info("Data start: {} post-slice: {}", (Object)start, (Object)data.position());
                    data.expand(remaining + 2);
                    if (isKey) {
                        data.put(VP8_KEYFRAME_PREFIX);
                    } else {
                        data.put(VP8_FRAME_PREFIX);
                    }
                    data.put(slice);
                    data.flip();
                    start = data.position();
                } else {
                    log.warn("Remaining VP8 content was less than expected: {}", (Object)remaining);
                }
                data.position(start);
            }
            byte frameType = data.get();
            byte subFrameType = data.get();
            if ((frameType & 0xF) == VideoCodec.VP8.getId()) {
                if ((frameType & 0xF0) == 16) {
                    if (log.isDebugEnabled()) {
                        log.debug("Keyframe - VP8 type: {}", (Object)subFrameType);
                    }
                    data.rewind();
                    switch (subFrameType) {
                        case 1: {
                            if (timestamp != this.keyframeTimestamp) {
                                this.keyframeTimestamp = timestamp;
                                this.keyframes.clear();
                            }
                            this.keyframes.add(new IVideoStreamCodec.FrameData(data));
                            break;
                        }
                    }
                }
            } else {
                log.debug("Non-VP8 data, rejecting");
                data.position(start);
                return false;
            }
            data.position(start);
        }
        return true;
    }

    private static int getDesciptorSize(byte[] input, int offset, int length) {
        if ((input[offset] & 0xFFFFFF80) == 0) {
            return 1;
        }
        int size = 2;
        if ((input[offset + 1] & 0xFFFFFF80) != 0) {
            ++size;
            if ((input[offset + 2] & 0xFFFFFF80) != 0) {
                ++size;
            }
        }
        if ((input[offset + 1] & 0x40) != 0) {
            ++size;
        }
        if ((input[offset + 1] & 0x30) != 0) {
            ++size;
        }
        return size;
    }

    private static boolean isKeyFrame(byte[] input, int offset) {
        return (input[offset] & 0x10) == 0;
    }
}

