/*
 * Decompiled with CFR 0.152.
 */
package org.red5.compatibility.flex.messaging.messages;

import java.util.UUID;
import org.red5.compatibility.flex.messaging.messages.AsyncMessage;
import org.red5.io.amf3.ByteArray;
import org.red5.io.amf3.IDataInput;
import org.red5.io.amf3.IDataOutput;
import org.red5.io.utils.RandomGUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandMessage
extends AsyncMessage {
    private static final long serialVersionUID = 8805045741686625945L;
    protected static byte OPERATION_FLAG = 1;
    public String messageRefType;
    public int operation = 10000;
    static Logger log = LoggerFactory.getLogger(CommandMessage.class);

    public CommandMessage() {
        this.messageId = UUID.randomUUID().toString();
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    protected void addParameters(StringBuilder result) {
        super.addParameters(result);
        result.append(",messageRefType=");
        result.append(this.messageRefType);
        result.append(",operation=");
        result.append(this.operation);
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    @Override
    public void readExternal(IDataInput in) {
        log.debug("CommandMessage - Read external");
        super.readExternal(in);
        short[] flagsArray = this.readFlags(in);
        for (int i = 0; i < flagsArray.length; ++i) {
            short flags = flagsArray[i];
            log.debug("Unsigned byte: {}", (Object)flags);
            int reservedPosition = 0;
            if (i == 0) {
                if ((flags & OPERATION_FLAG) != 0) {
                    Integer obj = (Integer)in.readObject();
                    log.debug("Operation object: {} name: {}", (Object)obj, (Object)obj.getClass().getName());
                    this.operation = obj;
                }
                reservedPosition = 1;
            }
            if (flags >> reservedPosition == 0) continue;
            for (int j = reservedPosition; j < 6; j = (int)((short)(j + 1))) {
                if ((flags >> j & 1) == 0) continue;
                Object obj = in.readObject();
                log.debug("Object2: {} name: {}", obj, (Object)obj.getClass().getName());
                if (!(obj instanceof ByteArray)) continue;
                ByteArray ba = (ByteArray)obj;
                byte[] arr = new byte[ba.length()];
                ba.readBytes(arr);
                log.debug("Array length: {} Data: {}", (Object)arr.length, (Object)RandomGUID.fromByteArray(arr));
            }
        }
        log.debug("Operation: {}", (Object)this.operation);
    }

    @Override
    public void writeExternal(IDataOutput out) {
        super.writeExternal(out);
        short flags = 0;
        if (this.operation != 10000) {
            flags = (short)(flags | OPERATION_FLAG);
        }
        out.writeByte((byte)flags);
        if (this.operation != 10000) {
            out.writeObject(this.operation);
        }
    }
}

