/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.matroska.dtd;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.red5.io.matroska.ConverterException;
import org.red5.io.matroska.ParserUtils;
import org.red5.io.matroska.VINT;
import org.red5.io.matroska.dtd.Tag;

public class CompoundTag
extends Tag {
    private Map<String, Tag> subElements = new HashMap<String, Tag>();

    public CompoundTag(String name, VINT id) throws IOException {
        super(name, id);
    }

    public CompoundTag(String name, VINT id, VINT size, InputStream inputStream) throws IOException {
        super(name, id, size, inputStream);
    }

    @Override
    public void readData(InputStream inputStream) throws IOException {
    }

    @Override
    public void parse(InputStream inputStream) throws IOException, ConverterException {
        for (Tag tag : ParserUtils.parseMasterElement(inputStream, (int)this.getSize())) {
            this.subElements.put(tag.getName(), tag);
        }
    }

    @Override
    public int totalSize() {
        return (int)((long)(this.id.getLength() + this.size.getLength()) + (!this.subElements.isEmpty() ? this.size.getValue() : 0L));
    }

    @Override
    protected void putValue(ByteBuffer bb) throws IOException {
        for (Tag tag : this.subElements.values()) {
            bb.put(tag.encode());
        }
    }

    public CompoundTag add(Tag ch) {
        this.subElements.put(ch.getName(), ch);
        long sz = this.getSize() + (long)ch.totalSize();
        byte length = 1;
        for (long v = sz + 1L >> 8; v > 0L; v >>= 8) {
            length = (byte)(length + 1);
        }
        this.size = new VINT(0L, length, sz);
        return this;
    }

    public int getNumberOfSubElements() {
        return this.subElements.size();
    }

    public Tag get(String tagName) {
        return this.subElements.get(tagName);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(super.toString() + "\n");
        for (Tag tag : this.subElements.values()) {
            result.append("\t" + tag + "\n");
        }
        return result.toString();
    }
}

