/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.matroska.dtd;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.red5.io.matroska.ParserUtils;
import org.red5.io.matroska.VINT;
import org.red5.io.matroska.dtd.Tag;

public class FloatTag
extends Tag {
    private double value;

    public FloatTag(String name, VINT id) throws IOException {
        super(name, id);
    }

    public FloatTag(String name, VINT id, VINT size, InputStream inputStream) throws IOException {
        super(name, id, size, inputStream);
    }

    @Override
    public void parse(InputStream inputStream) throws IOException {
        this.value = ParserUtils.parseFloat(inputStream, (int)this.getSize());
    }

    @Override
    protected void putValue(ByteBuffer bb) throws IOException {
        if (this.getSize() == 4L) {
            bb.putFloat((float)this.value);
        } else {
            bb.putDouble(this.value);
        }
    }

    public double getValue() {
        return this.value;
    }

    public FloatTag setValue(double value) {
        this.value = value;
        this.size = VINT.fromValue(8L);
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + " = " + this.value;
    }
}

