/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.matroska.dtd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.red5.io.matroska.ConverterException;
import org.red5.io.matroska.ParserUtils;
import org.red5.io.matroska.VINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tag {
    static Logger log = LoggerFactory.getLogger(Tag.class);
    private String name;
    VINT id;
    VINT size;
    private byte[] data;

    public Tag(String name, VINT id) throws IOException {
        this(name, id, new VINT(0L, 0, 0L), null);
    }

    public Tag(String name, VINT id, VINT size, InputStream inputStream) throws IOException {
        this.name = name;
        this.id = id;
        this.size = size;
        this.readData(inputStream);
    }

    public abstract void parse(InputStream var1) throws IOException, ConverterException;

    public void parse() throws IOException, ConverterException {
        this.parse(new ByteArrayInputStream(this.data));
    }

    public void readData(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        this.data = ParserUtils.parseBinary(inputStream, (int)this.size.getValue());
    }

    protected abstract void putValue(ByteBuffer var1) throws IOException;

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id.getBinary();
    }

    public long getSize() {
        return this.size.getValue();
    }

    public int totalSize() {
        return (int)((long)(this.id.getLength() + this.size.getLength()) + this.size.getValue());
    }

    public byte[] encode() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(this.totalSize());
        log.debug("Tag: " + this);
        buf.put(this.id.encode());
        buf.put(this.size.encode());
        this.putValue(buf);
        buf.flip();
        return buf.array();
    }

    public String toString() {
        return String.format("%s [id: %s, size: %s]", this.name, this.id, this.size);
    }
}

