/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.sctp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Random;
import org.red5.io.sctp.IAssociationControl;
import org.red5.io.sctp.SctpException;
import org.red5.io.sctp.packet.SctpPacket;
import org.red5.io.sctp.packet.chunks.Init;

public class Association
implements IAssociationControl {
    private Timestamp creationTimestamp;
    private int verificationTagSource;
    private int verificationTagDestination;
    private int initialTSNSource;
    private int initialTSNDestination;
    private IAssociationControl.State state;
    private DatagramSocket source;
    private InetSocketAddress destination;
    private Random random;

    public Association(Random random, InetSocketAddress sourceAddress, int initialTSN, int verificationTag) throws SocketException {
        this.random = random;
        this.setState(IAssociationControl.State.CLOSED);
        this.setVerificationTagItself(random.nextInt());
        this.source = new DatagramSocket(sourceAddress);
        this.creationTimestamp = new Timestamp(System.currentTimeMillis());
    }

    public Association(Random random, InetSocketAddress sourceAddress) throws SocketException {
        this.random = random;
        this.setState(IAssociationControl.State.CLOSED);
        this.setVerificationTagItself(random.nextInt());
        this.source = new DatagramSocket(sourceAddress);
        this.creationTimestamp = new Timestamp(System.currentTimeMillis());
    }

    public boolean setUp(InetSocketAddress address) throws IOException, SctpException, InvalidKeyException, NoSuchAlgorithmException {
        this.destination = address;
        this.initialTSNSource = this.random.nextInt();
        Init initChunk = new Init(this.verificationTagSource, this.initialTSNSource);
        SctpPacket packet = new SctpPacket((short)this.source.getLocalPort(), (short)this.destination.getPort(), 0, initChunk);
        byte[] data = packet.getBytes();
        this.source.send(new DatagramPacket(data, data.length, this.destination));
        this.state = IAssociationControl.State.COOKIE_WAIT;
        byte[] buffer = new byte[1024];
        DatagramPacket udpPacket = new DatagramPacket(buffer, buffer.length);
        this.source.receive(udpPacket);
        try {
            packet = new SctpPacket(buffer, 0, udpPacket.getLength());
        }
        catch (SctpException e) {
            e.printStackTrace();
        }
        packet.apply(this);
        this.source.receive(udpPacket);
        try {
            packet = new SctpPacket(buffer, 0, udpPacket.getLength());
        }
        catch (SctpException e) {
            e.printStackTrace();
        }
        packet.apply(this);
        return this.state == IAssociationControl.State.ESTABLISHED;
    }

    @Override
    public IAssociationControl.State getState() {
        return this.state;
    }

    public void setSource(DatagramSocket source) {
        this.source = source;
    }

    @Override
    public int getVerificationTag() {
        return this.verificationTagDestination;
    }

    public int getVerificationTagItself() {
        return this.verificationTagSource;
    }

    public void setVerificationTagItself(int verificationTagItself) {
        this.verificationTagSource = verificationTagItself;
    }

    @Override
    public void setState(IAssociationControl.State state) {
        this.state = state;
    }

    @Override
    public void sendPacket(SctpPacket packet) throws IOException {
        byte[] data = packet.getBytes();
        this.source.send(new DatagramPacket(data, data.length));
    }

    @Override
    public int getDestinationPort() {
        return this.destination.getPort();
    }

    @Override
    public int getSourcePort() {
        return this.source.getLocalPort();
    }
}

