/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.utils.HexDump;
import org.slf4j.Logger;

public class IOUtils {
    public static final Charset CHARSET = Charset.forName("UTF-8");

    public static final void writeReverseInt(IoBuffer out, int value) {
        out.putInt((value & 0xFF) << 24 | (value >> 8 & 0xFF) << 16 | (value >>> 16 & 0xFF) << 8 | value >>> 24 & 0xFF);
    }

    public static final void writeMediumInt(IoBuffer out, int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        out.put(bytes);
    }

    public static final void writeMediumInt(ByteBuffer out, int value) {
        out.put((byte)(value >>> 16 & 0xFF));
        out.put((byte)(value >>> 8 & 0xFF));
        out.put((byte)(value & 0xFF));
    }

    public static final void writeExtendedMediumInt(IoBuffer out, int value) {
        value = (value & 0xFF000000) >> 24 | value << 8;
        out.putInt(value);
    }

    public static final void writeExtendedMediumInt(ByteBuffer out, int value) {
        value = (value & 0xFF000000) >> 24 | value << 8;
        out.putInt(value);
    }

    public static final void writeUnsignedByte(ByteBuffer out, byte value) {
        out.put((byte)(value & 0xFF));
    }

    public static final int readUnsignedMediumInt(ByteBuffer in) {
        return ((in.get() & 0xFF) << 16) + ((in.get() & 0xFF) << 8) + (in.get() & 0xFF);
    }

    public static final int readUnsignedMediumInt(IoBuffer in) {
        return ((in.get() & 0xFF) << 16) + ((in.get() & 0xFF) << 8) + (in.get() & 0xFF);
    }

    public static final int readMediumInt(ByteBuffer in) {
        return ((in.get() & 0xFF) << 16) + ((in.get() & 0xFF) << 8) + (in.get() & 0xFF);
    }

    public static final int readMediumInt(IoBuffer in) {
        return ((in.get() & 0xFF) << 16) + ((in.get() & 0xFF) << 8) + (in.get() & 0xFF);
    }

    public static final int readExtendedMediumInt(IoBuffer in) {
        int result = in.getInt();
        result = result >>> 8 | (result & 0xFF) << 24;
        return result;
    }

    public static final int readExtendedMediumInt(ByteBuffer in) {
        int result = in.getInt();
        result = result >>> 8 | (result & 0xFF) << 24;
        return result;
    }

    public static final int readReverseInt(IoBuffer in) {
        int value = in.getInt();
        value = (value & 0xFF) << 24 | (value >> 8 & 0xFF) << 16 | (value >>> 16 & 0xFF) << 8 | value >>> 24 & 0xFF;
        return value;
    }

    public static final void debug(Logger log, String msg, IoBuffer buf) {
        if (log.isDebugEnabled()) {
            log.debug(msg);
            log.debug("Size: {}", (Object)buf.remaining());
            log.debug("Data:\n{}", (Object)HexDump.formatHexDump(buf.getHexDump()));
            log.debug("\n{}\n", (Object)IOUtils.toString(buf));
        }
    }

    public static final String toString(IoBuffer buf) {
        int pos = buf.position();
        int limit = buf.limit();
        ByteBuffer strBuf = buf.buf();
        String string = CHARSET.decode(strBuf).toString();
        buf.position(pos);
        buf.limit(limit);
        return string;
    }

    public static final byte[] hexStringToByteArray(String s) {
        s = s.replaceAll("\\s+", "");
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static void main(String[] args) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        IOUtils.writeExtendedMediumInt(buf, 1234567890);
        buf.flip();
        System.out.println("Result: " + IOUtils.readExtendedMediumInt(buf));
    }
}

