/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.webm;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.red5.io.matroska.ConverterException;
import org.red5.io.matroska.dtd.Tag;
import org.red5.io.matroska.parser.TagCrawler;
import org.red5.io.matroska.parser.TagHandler;
import org.red5.io.webm.TagConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebmReader
implements Closeable {
    private static Logger log = LoggerFactory.getLogger(WebmReader.class);
    private FileInputStream fis = null;
    private final TagConsumer processor;
    private TagCrawler crawler;

    public WebmReader(File file, TagConsumer processor) throws FileNotFoundException {
        this.fis = new FileInputStream(file);
        this.processor = processor;
        final TagHandler valueTagHandler = new TagHandler(){

            @Override
            public void handle(Tag tag, InputStream input) throws IOException, ConverterException {
                tag.parse();
                WebmReader.this.processor.consume(tag);
            }
        };
        TagHandler masterTagHandler = new TagHandler(){

            @Override
            public void handle(Tag tag, InputStream input) throws IOException, ConverterException {
                WebmReader.this.processor.consume(tag);
            }
        };
        this.crawler = new TagCrawler(){

            @Override
            public TagHandler createSkipHandler() {
                return valueTagHandler;
            }
        };
        this.crawler.addHandler("EBML", masterTagHandler);
        this.crawler.addHandler("CRC32", masterTagHandler);
        this.crawler.addHandler("Segment", masterTagHandler);
        this.crawler.addHandler("SeekHead", masterTagHandler);
        this.crawler.addHandler("Seek", masterTagHandler);
        this.crawler.addHandler("Info", masterTagHandler);
        this.crawler.addHandler("Tracks", masterTagHandler);
        this.crawler.addHandler("TrackEntry", masterTagHandler);
        this.crawler.addHandler("Video", masterTagHandler);
        this.crawler.addHandler("Audio", masterTagHandler);
        this.crawler.addHandler("ContentEncodings", masterTagHandler);
        this.crawler.addHandler("ContentEncoding", masterTagHandler);
        this.crawler.addHandler("ContentCompression", masterTagHandler);
        this.crawler.addHandler("ContentEncryption", masterTagHandler);
        this.crawler.addHandler("Cluster", masterTagHandler);
        this.crawler.addHandler("BlockGroup", masterTagHandler);
        this.crawler.addHandler("BlockAdditions", masterTagHandler);
        this.crawler.addHandler("BlockMore", masterTagHandler);
        this.crawler.addHandler("Slices", masterTagHandler);
        this.crawler.addHandler("TimeSlice", masterTagHandler);
        this.crawler.addHandler("Cues", masterTagHandler);
        this.crawler.addHandler("CuePoint", masterTagHandler);
        this.crawler.addHandler("CueTrackPositions", masterTagHandler);
        this.crawler.addHandler("CueReference", masterTagHandler);
        this.crawler.addHandler("Tags", masterTagHandler);
        this.crawler.addHandler("Tag", masterTagHandler);
        this.crawler.addHandler("Targets", masterTagHandler);
        this.crawler.addHandler("SimpleTag", masterTagHandler);
        this.crawler.addHandler("Chapters", masterTagHandler);
        this.crawler.addHandler("EditionEntry", masterTagHandler);
        this.crawler.addHandler("ChapterAtom", masterTagHandler);
        this.crawler.addHandler("ChapterTrack", masterTagHandler);
        this.crawler.addHandler("ChapterDisplay", masterTagHandler);
        this.crawler.addHandler("Attachments", masterTagHandler);
        this.crawler.addHandler("AttachedFile", masterTagHandler);
    }

    public void process() throws IOException, ConverterException {
        this.crawler.process(this.fis);
    }

    @Override
    public void close() throws IOException {
        if (this.fis != null) {
            try {
                this.fis.close();
                this.fis = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

