/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.lang3.StringUtils;
import org.red5.server.Client;
import org.red5.server.ClientList;
import org.red5.server.api.IClient;
import org.red5.server.api.IClientRegistry;
import org.red5.server.exception.ClientNotFoundException;
import org.red5.server.exception.ClientRejectedException;
import org.red5.server.jmx.mxbeans.ClientRegistryMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(objectName="org.red5.server:type=ClientRegistry,name=default", description="ClientRegistry")
public class ClientRegistry
implements IClientRegistry,
ClientRegistryMXBean {
    private Logger log = LoggerFactory.getLogger(ClientRegistry.class);
    private ConcurrentMap<String, IClient> clients = new ConcurrentHashMap<String, IClient>(6, 0.9f, 2);
    private AtomicInteger nextId = new AtomicInteger(0);
    private String name;

    public ClientRegistry() {
    }

    public ClientRegistry(String name) {
        this.name = name;
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            try {
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName oName = new ObjectName("org.red5.server:type=ClientRegistry,name=" + name);
                mbeanServer.registerMBean(new StandardMBean(this, ClientRegistryMXBean.class, true), oName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addClient(IClient client) {
        this.addClient(client.getId(), client);
    }

    private void addClient(String id, IClient client) {
        if (!this.hasClient(id)) {
            this.clients.put(id, client);
        } else {
            this.log.debug("Client id: {} already registered", (Object)id);
        }
    }

    @Override
    public Client getClient(String id) throws ClientNotFoundException {
        Client result = (Client)this.clients.get(id);
        if (result == null) {
            throw new ClientNotFoundException(id);
        }
        return result;
    }

    public ClientList<Client> getClientList() {
        ClientList<Client> list = new ClientList<Client>();
        for (IClient c : this.clients.values()) {
            list.add((Client)c);
        }
        return list;
    }

    protected boolean hasClients() {
        return !this.clients.isEmpty();
    }

    protected Collection<IClient> getClients() {
        if (!this.hasClients()) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableCollection(this.clients.values());
    }

    @Override
    public boolean hasClient(String id) {
        if (id == null) {
            return false;
        }
        return this.clients.containsKey(id);
    }

    @Override
    public IClient lookupClient(String id) throws ClientNotFoundException {
        return this.getClient(id);
    }

    @Override
    public IClient newClient(Object[] params) throws ClientNotFoundException, ClientRejectedException {
        String id = this.nextId();
        Client client = new Client(id, this);
        this.addClient(id, client);
        return client;
    }

    @Override
    public String nextId() {
        String id = "-1";
        do {
            if (this.nextId.get() != Integer.MAX_VALUE) continue;
            this.nextId.set(0);
        } while (this.hasClient(id = String.format("%d", this.nextId.getAndIncrement())));
        return id;
    }

    @Override
    public String previousId() {
        return String.format("%d", this.nextId.get());
    }

    protected void removeClient(IClient client) {
        this.clients.remove(client.getId());
    }
}

