/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.codec;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.amf3.Output;
import org.red5.io.object.Serializer;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.exception.ClientDetailsException;
import org.red5.server.net.ICommand;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPUtils;
import org.red5.server.net.rtmp.codec.IEventEncoder;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.Aggregate;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BytesRead;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.ClientBW;
import org.red5.server.net.rtmp.event.FlexMessage;
import org.red5.server.net.rtmp.event.FlexStreamSend;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.SWFResponse;
import org.red5.server.net.rtmp.event.ServerBW;
import org.red5.server.net.rtmp.event.SetBuffer;
import org.red5.server.net.rtmp.event.Unknown;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmp.message.SharedObjectTypeMapping;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.net.rtmp.status.StatusObject;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.ISharedObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPProtocolEncoder
implements Constants,
IEventEncoder {
    protected Logger log = LoggerFactory.getLogger(RTMPProtocolEncoder.class);
    private long baseTolerance = 15000L;
    private long midTolerance = this.baseTolerance + (long)((double)this.baseTolerance * 0.3);
    private long highestTolerance = this.baseTolerance + (long)((double)this.baseTolerance * 0.6);
    private boolean dropLiveFuture;
    private boolean dropEncoded;

    public IoBuffer encode(Object message) throws Exception {
        block6: {
            if (message != null) {
                try {
                    return this.encodePacket((Packet)message);
                }
                catch (Exception e) {
                    this.log.error("Error encoding", (Throwable)e);
                    break block6;
                }
            }
            if (this.log.isDebugEnabled()) {
                try {
                    String callingMethod = Thread.currentThread().getStackTrace()[4].getMethodName();
                    this.log.debug("Message is null at encode, expecting a Packet from: {}", (Object)callingMethod);
                }
                catch (Throwable t) {
                    this.log.warn("Problem getting current calling method from stacktrace", t);
                }
            }
        }
        return null;
    }

    public IoBuffer encodePacket(Packet packet) {
        IoBuffer data;
        IoBuffer out = null;
        Header header = packet.getHeader();
        int channelId = header.getChannelId();
        IRTMPEvent message = packet.getMessage();
        if (message instanceof ChunkSize) {
            ChunkSize chunkSizeMsg = (ChunkSize)message;
            ((RTMPConnection)Red5.getConnectionLocal()).getState().setWriteChunkSize(chunkSizeMsg.getSize());
        }
        if (!this.dropMessage(channelId, message) && (data = this.encodeMessage(header, message)) != null) {
            RTMP rtmp = ((RTMPConnection)Red5.getConnectionLocal()).getState();
            rtmp.setLastWritePacket(channelId, packet);
            if (data.position() != 0) {
                data.flip();
            } else {
                data.rewind();
            }
            int dataLen = data.limit();
            header.setSize(dataLen);
            int chunkSize = rtmp.getWriteChunkSize();
            int numChunks = (int)Math.ceil((float)dataLen / (float)chunkSize);
            Header lastHeader = rtmp.getLastWriteHeader(channelId);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Channel id: {} chunkSize: {}", (Object)channelId, (Object)chunkSize);
            }
            int bufSize = dataLen + 18 + numChunks * 2;
            out = IoBuffer.allocate((int)bufSize, (boolean)false);
            out.setAutoExpand(true);
            do {
                this.encodeHeader(header, lastHeader, out);
                byte[] buf = new byte[Math.min(chunkSize, data.remaining())];
                data.get(buf);
                out.put(buf);
                lastHeader = header.clone();
            } while (data.hasRemaining());
            lastHeader.setTimerBase(lastHeader.getTimer());
            lastHeader.setTimerDelta(0);
            rtmp.setLastWriteHeader(channelId, lastHeader);
            data.free();
            out.flip();
            data = null;
        }
        message.release();
        return out;
    }

    protected boolean dropMessage(int channelId, IRTMPEvent message) {
        boolean isDroppable;
        boolean isLiveStream;
        if (!this.dropEncoded) {
            this.log.trace("Not dropping due to flag, source type: {} (0=vod,1=live)", (Object)message.getSourceType());
            return false;
        }
        boolean bl = isLiveStream = message.getSourceType() == 1;
        if (!isLiveStream) {
            this.log.trace("Not dropping due to vod");
            return false;
        }
        RTMPConnection conn = (RTMPConnection)Red5.getConnectionLocal();
        if (message instanceof Ping) {
            Ping pingMessage = (Ping)message;
            if (pingMessage.getEventType() == 1) {
                int channel = conn.getChannelIdForStreamId(pingMessage.getValue2());
                this.log.trace("Ping stream id: {} channel id: {}", (Object)pingMessage.getValue2(), (Object)channel);
                conn.getState().clearLastTimestampMapping(channel, channel + 1, channel + 2);
            }
            return false;
        }
        boolean drop = false;
        boolean bl2 = isDroppable = message instanceof VideoData || message instanceof AudioData;
        if (isDroppable) {
            int lastPingPongInterval;
            if (message.getTimestamp() == 0) {
                return false;
            }
            if (this.log.isDebugEnabled()) {
                String sourceType = isLiveStream ? "LIVE" : "VOD";
                this.log.debug("Connection: {} connType={}", (Object)conn.getSessionId(), (Object)sourceType);
            }
            RTMP rtmp = conn.getState();
            long timestamp = (long)message.getTimestamp() & 0xFFFFFFFFL;
            RTMP.LiveTimestampMapping mapping = rtmp.getLastTimestampMapping(channelId);
            long now = System.currentTimeMillis();
            if (mapping == null || timestamp < mapping.getLastStreamTime()) {
                this.log.trace("Resetting clock time ({}) to stream time ({})", (Object)now, (Object)timestamp);
                RTMP rTMP = rtmp;
                rTMP.getClass();
                mapping = new RTMP.LiveTimestampMapping(rTMP, now, timestamp);
                rtmp.setLastTimestampMapping(channelId, mapping);
            }
            mapping.setLastStreamTime(timestamp);
            long clockTimeOfMessage = mapping.getClockStartTime() + timestamp - mapping.getStreamStartTime();
            long incomingLatency = clockTimeOfMessage - now;
            if (this.log.isDebugEnabled()) {
                this.log.debug("incomingLatency={} clockTimeOfMessage={} getClockStartTime={} timestamp={} getStreamStartTime={} now={}", new Object[]{incomingLatency, clockTimeOfMessage, mapping.getClockStartTime(), timestamp, mapping.getStreamStartTime(), now});
            }
            if (isLiveStream && this.dropLiveFuture) {
                incomingLatency = Math.abs(incomingLatency);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("incomingLatency={} clockTimeOfMessage={} now={}", new Object[]{incomingLatency, clockTimeOfMessage, now});
                }
            }
            long outgoingLatency = 0L;
            if (conn != null && (lastPingPongInterval = conn.getLastPingSentAndLastPongReceivedInterval()) > 0) {
                outgoingLatency = (long)lastPingPongInterval - incomingLatency;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("outgoingLatency={} lastPingTime={}", new Object[]{outgoingLatency, lastPingPongInterval});
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Packet timestamp: {}; latency: {}; now: {}; message clock time: {}, dropLiveFuture: {}", new Object[]{timestamp, incomingLatency, now, clockTimeOfMessage, this.dropLiveFuture});
            }
            if (outgoingLatency >= this.baseTolerance) {
                if (outgoingLatency > this.highestTolerance) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Outgoing direction congested. outgoingLatency={} highestTolerance={}", new Object[]{outgoingLatency, this.highestTolerance});
                    }
                    if (isDroppable) {
                        mapping.setKeyFrameNeeded(true);
                    }
                    drop = true;
                } else if (isDroppable && message instanceof VideoData) {
                    VideoData video = (VideoData)message;
                    if (video.getFrameType() == VideoData.FrameType.KEYFRAME) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Resuming stream with key frame; message: {}", (Object)message);
                        }
                        mapping.setKeyFrameNeeded(false);
                    } else if (incomingLatency >= this.baseTolerance && incomingLatency < this.midTolerance) {
                        if (video.getFrameType() == VideoData.FrameType.DISPOSABLE_INTERFRAME) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Dropping disposible frame; message: {}", (Object)message);
                            }
                            drop = true;
                        }
                    } else if (incomingLatency >= this.midTolerance && incomingLatency <= this.highestTolerance) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Dropping disposible or inter frame; message: {}", (Object)message);
                        }
                        drop = true;
                    }
                }
            }
        }
        if (this.log.isDebugEnabled() && drop) {
            this.log.debug("Message was dropped");
        }
        return drop;
    }

    private byte getHeaderType(Header header, Header lastHeader) {
        if (lastHeader == null || header.getStreamId() != lastHeader.getStreamId() || header.getTimer() < lastHeader.getTimer()) {
            return 0;
        }
        if (header.getSize() != lastHeader.getSize() || header.getDataType() != lastHeader.getDataType()) {
            return 1;
        }
        if (header.getTimer() != lastHeader.getTimer()) {
            return 2;
        }
        return 3;
    }

    private int calculateHeaderSize(Header header, Header lastHeader) {
        byte headerType = this.getHeaderType(header, lastHeader);
        int channelIdAdd = 0;
        int channelId = header.getChannelId();
        if (channelId > 320) {
            channelIdAdd = 2;
        } else if (channelId > 63) {
            channelIdAdd = 1;
        }
        return RTMPUtils.getHeaderLength(headerType) + channelIdAdd;
    }

    public IoBuffer encodeHeader(Header header, Header lastHeader) {
        IoBuffer result = IoBuffer.allocate((int)this.calculateHeaderSize(header, lastHeader));
        this.encodeHeader(header, lastHeader, result);
        return result;
    }

    public void encodeHeader(Header header, Header lastHeader, IoBuffer buf) {
        byte headerType = this.getHeaderType(header, lastHeader);
        RTMPUtils.encodeHeaderByte(buf, headerType, header.getChannelId());
        if (this.log.isTraceEnabled()) {
            this.log.trace("{} lastHeader: {}", (Object)Header.HeaderType.values()[headerType], (Object)lastHeader);
        }
        int timeBase = 0;
        int timeDelta = 0;
        int headerSize = header.getSize();
        switch (headerType) {
            case 0: {
                RTMPConnection conn;
                timeBase = header.getTimerBase();
                RTMPUtils.writeMediumInt(buf, Math.min(timeBase, 0xFFFFFF));
                RTMPUtils.writeMediumInt(buf, headerSize);
                buf.put(header.getDataType());
                RTMPUtils.writeReverseInt(buf, header.getStreamId().intValue());
                header.setTimerDelta(timeDelta);
                if (timeBase >= 0xFFFFFF) {
                    buf.putInt(timeBase);
                    header.setExtended(true);
                }
                if ((conn = (RTMPConnection)Red5.getConnectionLocal()) == null) break;
                conn.getState().setLastFullTimestampWritten(header.getChannelId(), timeBase);
                break;
            }
            case 1: {
                timeDelta = (int)RTMPUtils.diffTimestamps(header.getTimer(), lastHeader.getTimer());
                header.setTimerDelta(timeDelta);
                RTMPUtils.writeMediumInt(buf, Math.min(timeDelta, 0xFFFFFF));
                RTMPUtils.writeMediumInt(buf, headerSize);
                buf.put(header.getDataType());
                if (timeDelta >= 0xFFFFFF) {
                    buf.putInt(timeDelta);
                    header.setExtended(true);
                }
                timeBase = header.getTimerBase() - timeDelta;
                header.setTimerBase(timeBase);
                break;
            }
            case 2: {
                timeDelta = (int)RTMPUtils.diffTimestamps(header.getTimer(), lastHeader.getTimer());
                header.setTimerDelta(timeDelta);
                RTMPUtils.writeMediumInt(buf, Math.min(timeDelta, 0xFFFFFF));
                if (timeDelta >= 0xFFFFFF) {
                    buf.putInt(timeDelta);
                    header.setExtended(true);
                }
                timeBase = header.getTimerBase() - timeDelta;
                header.setTimerBase(timeBase);
                break;
            }
            case 3: {
                timeBase = header.getTimerBase() - timeDelta;
                if (!lastHeader.isExtended()) break;
                buf.putInt(timeBase);
                break;
            }
        }
        this.log.trace("Encoded chunk {} {}", (Object)Header.HeaderType.values()[headerType], (Object)header);
    }

    public IoBuffer encodeMessage(Header header, IRTMPEvent message) {
        IServiceCall call = null;
        switch (header.getDataType()) {
            case 1: {
                return this.encodeChunkSize((ChunkSize)message);
            }
            case 20: {
                this.log.trace("Invoke {}", (Object)message);
                call = ((Invoke)message).getCall();
                if (call != null) {
                    Status status;
                    Object a0;
                    this.log.debug("{}", (Object)call.toString());
                    Object[] args = call.getArguments();
                    if (args != null && args.length > 0 && (a0 = args[0]) instanceof Status && "NetStream.Seek.Notify".equals((status = (Status)a0).getCode())) {
                        int seekTime = Integer.valueOf(status.getDescription().split(" ")[1]);
                        this.log.trace("Seek to time: {}", (Object)seekTime);
                        int[] channels = new int[]{5, 6};
                        RTMP rtmp = ((RTMPConnection)Red5.getConnectionLocal()).getState();
                        for (int channelId : channels) {
                            RTMP.LiveTimestampMapping mapping = rtmp.getLastTimestampMapping(channelId);
                            if (mapping != null) {
                                long timestamp = mapping.getClockStartTime() + ((long)seekTime & 0xFFFFFFFFL);
                                this.log.trace("Setting last stream time to: {}", (Object)timestamp);
                                mapping.setLastStreamTime(timestamp);
                                continue;
                            }
                            this.log.trace("No ts mapping for channel id: {}", (Object)channelId);
                        }
                    }
                }
                return this.encodeInvoke((Invoke)message);
            }
            case 18: {
                this.log.trace("Notify {}", (Object)message);
                call = ((Notify)message).getCall();
                if (call == null) {
                    return this.encodeStreamMetadata((Notify)message);
                }
                return this.encodeNotify((Notify)message);
            }
            case 4: {
                if (message instanceof SetBuffer) {
                    return this.encodePing((SetBuffer)message);
                }
                if (message instanceof SWFResponse) {
                    return this.encodePing((SWFResponse)message);
                }
                return this.encodePing((Ping)message);
            }
            case 3: {
                return this.encodeBytesRead((BytesRead)message);
            }
            case 22: {
                this.log.trace("Encode aggregate message");
                return this.encodeAggregate((Aggregate)message);
            }
            case 8: {
                this.log.trace("Encode audio message");
                return this.encodeAudioData((AudioData)message);
            }
            case 9: {
                this.log.trace("Encode video message");
                return this.encodeVideoData((VideoData)message);
            }
            case 16: {
                return this.encodeFlexSharedObject((ISharedObjectMessage)message);
            }
            case 19: {
                return this.encodeSharedObject((ISharedObjectMessage)message);
            }
            case 5: {
                return this.encodeServerBW((ServerBW)message);
            }
            case 6: {
                return this.encodeClientBW((ClientBW)message);
            }
            case 17: {
                return this.encodeFlexMessage((FlexMessage)message);
            }
            case 15: {
                return this.encodeFlexStreamSend((FlexStreamSend)message);
            }
        }
        this.log.warn("Unknown object type: {}", (Object)header.getDataType());
        return null;
    }

    private IoBuffer encodeServerBW(ServerBW serverBW) {
        IoBuffer out = IoBuffer.allocate((int)4);
        out.putInt(serverBW.getBandwidth());
        return out;
    }

    private IoBuffer encodeClientBW(ClientBW clientBW) {
        IoBuffer out = IoBuffer.allocate((int)5);
        out.putInt(clientBW.getBandwidth());
        out.put(clientBW.getLimitType());
        return out;
    }

    @Override
    public IoBuffer encodeChunkSize(ChunkSize chunkSize) {
        IoBuffer out = IoBuffer.allocate((int)4);
        out.putInt(chunkSize.getSize());
        return out;
    }

    @Override
    public IoBuffer encodeFlexSharedObject(ISharedObjectMessage so) {
        IoBuffer out = IoBuffer.allocate((int)128);
        out.setAutoExpand(true);
        out.put((byte)0);
        this.doEncodeSharedObject(so, out);
        return out;
    }

    @Override
    public IoBuffer encodeSharedObject(ISharedObjectMessage so) {
        IoBuffer out = IoBuffer.allocate((int)128);
        out.setAutoExpand(true);
        this.doEncodeSharedObject(so, out);
        return out;
    }

    private void doEncodeSharedObject(ISharedObjectMessage so, IoBuffer out) {
        IConnection.Encoding encoding = Red5.getConnectionLocal().getEncoding();
        org.red5.io.amf.Output output = new org.red5.io.amf.Output(out);
        Output amf3output = new Output(out);
        output.putString(so.getName());
        out.putInt(so.getVersion());
        out.putInt(so.isPersistent() ? 2 : 0);
        out.putInt(0);
        block9: for (ISharedObjectEvent event : so.getEvents()) {
            ISharedObjectEvent.Type eventType = event.getType();
            byte type = SharedObjectTypeMapping.toByte(eventType);
            switch (eventType) {
                case SERVER_CONNECT: 
                case CLIENT_INITIAL_DATA: 
                case CLIENT_CLEAR_DATA: {
                    out.put(type);
                    out.putInt(0);
                    break;
                }
                case SERVER_DELETE_ATTRIBUTE: 
                case CLIENT_DELETE_DATA: 
                case CLIENT_UPDATE_ATTRIBUTE: {
                    out.put(type);
                    int mark = out.position();
                    out.skip(4);
                    output.putString(event.getKey());
                    int len = out.position() - mark - 4;
                    out.putInt(mark, len);
                    break;
                }
                case SERVER_SET_ATTRIBUTE: 
                case CLIENT_UPDATE_DATA: {
                    int len;
                    int mark;
                    if (event.getKey() == null) {
                        Map initialData = (Map)event.getValue();
                        for (Object o : initialData.keySet()) {
                            out.put(type);
                            mark = out.position();
                            out.skip(4);
                            String key = (String)o;
                            output.putString(key);
                            if (encoding == IConnection.Encoding.AMF3) {
                                Serializer.serialize((org.red5.io.object.Output)amf3output, initialData.get(key));
                            } else {
                                Serializer.serialize((org.red5.io.object.Output)output, initialData.get(key));
                            }
                            len = out.position() - mark - 4;
                            out.putInt(mark, len);
                        }
                        continue block9;
                    }
                    out.put(type);
                    mark = out.position();
                    out.skip(4);
                    output.putString(event.getKey());
                    if (encoding == IConnection.Encoding.AMF3) {
                        Serializer.serialize((org.red5.io.object.Output)amf3output, (Object)event.getValue());
                    } else {
                        Serializer.serialize((org.red5.io.object.Output)output, (Object)event.getValue());
                    }
                    len = out.position() - mark - 4;
                    out.putInt(mark, len);
                    break;
                }
                case CLIENT_SEND_MESSAGE: 
                case SERVER_SEND_MESSAGE: {
                    out.put(type);
                    int mark = out.position();
                    out.skip(4);
                    Serializer.serialize((org.red5.io.object.Output)output, (Object)event.getKey());
                    try {
                        List arguments = (List)event.getValue();
                        if (arguments != null) {
                            for (Object arg : arguments) {
                                if (encoding == IConnection.Encoding.AMF3) {
                                    Serializer.serialize((org.red5.io.object.Output)amf3output, (Object)arg);
                                    continue;
                                }
                                Serializer.serialize((org.red5.io.object.Output)output, (Object)arg);
                            }
                        } else if (encoding == IConnection.Encoding.AMF3) {
                            Serializer.serialize((org.red5.io.object.Output)amf3output, null);
                        } else {
                            Serializer.serialize((org.red5.io.object.Output)output, null);
                        }
                    }
                    catch (Exception ex) {
                        this.log.warn("Exception encoding args for event: {}", (Object)event, (Object)ex);
                    }
                    int len = out.position() - mark - 4;
                    out.putInt(mark, len);
                    break;
                }
                case CLIENT_STATUS: {
                    out.put(type);
                    String status = event.getKey();
                    String message = (String)event.getValue();
                    out.putInt(message.length() + status.length() + 4);
                    output.putString(message);
                    output.putString(status);
                    break;
                }
                default: {
                    this.log.warn("Unknown event: {}", (Object)eventType);
                    out.put(type);
                    int mark = out.position();
                    out.skip(4);
                    output.putString(event.getKey());
                    if (encoding == IConnection.Encoding.AMF3) {
                        Serializer.serialize((org.red5.io.object.Output)amf3output, (Object)event.getValue());
                    } else {
                        Serializer.serialize((org.red5.io.object.Output)output, (Object)event.getValue());
                    }
                    int len = out.position() - mark - 4;
                    out.putInt(mark, len);
                }
            }
        }
    }

    @Override
    public IoBuffer encodeNotify(Notify notify) {
        return this.encodeCommand(notify);
    }

    @Override
    public IoBuffer encodeInvoke(Invoke invoke) {
        return this.encodeCommand(invoke);
    }

    protected IoBuffer encodeCommand(Notify invoke) {
        IoBuffer out = IoBuffer.allocate((int)1024);
        out.setAutoExpand(true);
        this.encodeCommand(out, invoke);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeCommand(IoBuffer out, ICommand command) {
        Object output = new org.red5.io.amf.Output(out);
        IServiceCall call = command.getCall();
        boolean isPending = call.getStatus() == 1;
        this.log.debug("Call: {} pending: {}", (Object)call, (Object)isPending);
        if (!isPending) {
            this.log.debug("Call has been executed, send result");
            Serializer.serialize((org.red5.io.object.Output)output, (Object)(call.isSuccess() ? "_result" : "_error"));
        } else {
            this.log.debug("This is a pending call, send request");
            String action = call.getServiceName() == null ? call.getServiceMethodName() : call.getServiceName() + '.' + call.getServiceMethodName();
            Serializer.serialize((org.red5.io.object.Output)output, (Object)action);
        }
        if (command instanceof Invoke) {
            Serializer.serialize((org.red5.io.object.Output)output, (Object)command.getTransactionId());
            Serializer.serialize((org.red5.io.object.Output)output, command.getConnectionParams());
        }
        output = call.getServiceName() == null && "connect".equals(call.getServiceMethodName()) ? new org.red5.io.amf.Output(out) : (Red5.getConnectionLocal().getEncoding() == IConnection.Encoding.AMF3 ? new Output(out) : new org.red5.io.amf.Output(out));
        if (!isPending && command instanceof Invoke) {
            IPendingServiceCall pendingCall = (IPendingServiceCall)call;
            if (!call.isSuccess()) {
                this.log.debug("Call was not successful");
                StatusObject status = this.generateErrorResult("NetConnection.Call.Failed", call.getException());
                pendingCall.setResult(status);
            }
            Object res = pendingCall.getResult();
            this.log.debug("Writing result: {}", res);
            Serializer.serialize((org.red5.io.object.Output)output, (Object)res);
        } else {
            this.log.debug("Writing params");
            Object[] args = call.getArguments();
            if (args != null) {
                for (Object element : args) {
                    if (element instanceof ByteBuffer) {
                        ByteBuffer buf = (ByteBuffer)element;
                        buf.mark();
                        try {
                            out.put(buf);
                            continue;
                        }
                        finally {
                            buf.reset();
                        }
                    }
                    Serializer.serialize((org.red5.io.object.Output)output, (Object)element);
                }
            }
        }
        if (command.getData() != null) {
            out.setAutoExpand(true);
            out.put(command.getData());
        }
    }

    @Override
    public IoBuffer encodePing(Ping ping) {
        int len;
        short type = ping.getEventType();
        switch (type) {
            case 3: {
                len = 10;
                break;
            }
            case 27: {
                len = 44;
                break;
            }
            default: {
                len = 6;
            }
        }
        IoBuffer out = IoBuffer.allocate((int)len);
        out.putShort(type);
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 31: 
            case 32: {
                out.putInt(ping.getValue2().intValue());
                break;
            }
            case 3: {
                if (ping instanceof SetBuffer) {
                    SetBuffer setBuffer = (SetBuffer)ping;
                    out.putInt(setBuffer.getStreamId());
                    out.putInt(setBuffer.getBufferLength());
                    break;
                }
                out.putInt(ping.getValue2().intValue());
                out.putInt(ping.getValue3());
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                out.put(((SWFResponse)ping).getBytes());
            }
        }
        if (ping.getValue4() != -1) {
            out.putInt(ping.getValue4());
        }
        return out;
    }

    @Override
    public IoBuffer encodeBytesRead(BytesRead bytesRead) {
        IoBuffer out = IoBuffer.allocate((int)4);
        out.putInt(bytesRead.getBytesRead());
        return out;
    }

    @Override
    public IoBuffer encodeAggregate(Aggregate aggregate) {
        IoBuffer result = aggregate.getData();
        return result;
    }

    @Override
    public IoBuffer encodeAudioData(AudioData audioData) {
        IoBuffer result = audioData.getData();
        return result;
    }

    @Override
    public IoBuffer encodeVideoData(VideoData videoData) {
        IoBuffer result = videoData.getData();
        return result;
    }

    @Override
    public IoBuffer encodeUnknown(Unknown unknown) {
        IoBuffer result = unknown.getData();
        return result;
    }

    public IoBuffer encodeStreamMetadata(Notify metaData) {
        IoBuffer result = metaData.getData();
        return result;
    }

    protected StatusObject generateErrorResult(String code, Throwable error) {
        String message = "";
        while (error != null && error.getCause() != null) {
            error = error.getCause();
        }
        if (error != null && error.getMessage() != null) {
            message = error.getMessage();
        }
        StatusObject status = new StatusObject(code, "error", message);
        if (error instanceof ClientDetailsException) {
            status.setApplication(((ClientDetailsException)error).getParameters());
            if (((ClientDetailsException)error).includeStacktrace()) {
                ArrayList<String> stack = new ArrayList<String>();
                for (StackTraceElement element : error.getStackTrace()) {
                    stack.add(element.toString());
                }
                status.setAdditional("stacktrace", stack);
            }
        } else if (error != null) {
            status.setApplication(error.getClass().getCanonicalName());
            ArrayList<String> stack = new ArrayList<String>();
            for (StackTraceElement element : error.getStackTrace()) {
                stack.add(element.toString());
            }
            status.setAdditional("stacktrace", stack);
        }
        return status;
    }

    public IoBuffer encodeFlexMessage(FlexMessage msg) {
        IoBuffer out = IoBuffer.allocate((int)1024);
        out.setAutoExpand(true);
        out.put((byte)0);
        this.encodeCommand(out, msg);
        return out;
    }

    public IoBuffer encodeFlexStreamSend(FlexStreamSend msg) {
        IoBuffer result = msg.getData();
        return result;
    }

    private void updateTolerance() {
        this.midTolerance = this.baseTolerance + (long)((double)this.baseTolerance * 0.3);
        this.highestTolerance = this.baseTolerance + (long)((double)this.baseTolerance * 0.6);
    }

    public void setBaseTolerance(long baseTolerance) {
        this.baseTolerance = baseTolerance;
        this.updateTolerance();
    }

    public void setDropLiveFuture(boolean dropLiveFuture) {
        this.dropLiveFuture = dropLiveFuture;
    }

    public void setDropEncoded(boolean dropEncoded) {
        this.dropEncoded = dropEncoded;
    }

    public long getBaseTolerance() {
        return this.baseTolerance;
    }
}

