/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AudioCodec;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.stream.IStreamData;

public class AudioData
extends BaseEvent
implements IStreamData<AudioData>,
IStreamPacket {
    private static final long serialVersionUID = -4102940670913999407L;
    protected IoBuffer data;
    private byte dataType = (byte)8;
    protected int codecId = -1;
    protected boolean config;

    public AudioData() {
        this(IoBuffer.allocate((int)0).flip());
    }

    public AudioData(IoBuffer data) {
        super(IEvent.Type.STREAM_DATA);
        this.setData(data);
    }

    public AudioData(IoBuffer data, boolean copy) {
        super(IEvent.Type.STREAM_DATA);
        if (copy) {
            byte[] array = new byte[data.limit()];
            data.mark();
            data.get(array);
            data.reset();
            this.setData(array);
        } else {
            this.setData(data);
        }
    }

    @Override
    public byte getDataType() {
        return this.dataType;
    }

    public void setDataType(byte dataType) {
        this.dataType = dataType;
    }

    @Override
    public IoBuffer getData() {
        return this.data;
    }

    public void setData(IoBuffer data) {
        if (data != null && data.limit() > 0) {
            data.mark();
            this.codecId = (data.get(0) & 0xFF & 0xF0) >> 4;
            if (this.codecId == AudioCodec.AAC.getId()) {
                this.config = data.get() == 0;
            }
            data.reset();
        }
        this.data = data;
    }

    public void setData(byte[] data) {
        this.data = IoBuffer.allocate((int)data.length);
        this.data.put(data).flip();
    }

    public int getCodecId() {
        return this.codecId;
    }

    public boolean isConfig() {
        return this.config;
    }

    @Override
    protected void releaseInternal() {
        if (this.data != null) {
            this.data.free();
            this.data = null;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte[] byteBuf = (byte[])in.readObject();
        if (byteBuf != null) {
            this.setData(IoBuffer.wrap((byte[])byteBuf));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.data != null) {
            out.writeObject(this.data.array());
        } else {
            out.writeObject(null);
        }
    }

    public AudioData duplicate() throws IOException, ClassNotFoundException {
        AudioData result = new AudioData();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        this.writeExternal(oos);
        oos.close();
        byte[] buf = baos.toByteArray();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bais);
        result.readExternal(ois);
        ois.close();
        bais.close();
        if (this.header != null) {
            result.setHeader(this.header.clone());
        }
        result.setSourceType(this.sourceType);
        return result;
    }

    public String toString() {
        return String.format("Audio - ts: %s length: %s", this.getTimestamp(), this.data != null ? this.data.limit() : 48);
    }
}

