/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.lang.ref.WeakReference;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.event.Invoke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferredResult {
    protected static Logger log = LoggerFactory.getLogger(DeferredResult.class);
    private WeakReference<Channel> channel;
    private IPendingServiceCall call;
    private int transactionId;
    private boolean resultSent = false;

    public void setResult(Object result) {
        if (this.resultSent) {
            throw new RuntimeException("You can only set the result once.");
        }
        this.resultSent = true;
        Channel channel = (Channel)this.channel.get();
        if (channel == null) {
            log.warn("The client is no longer connected.");
            return;
        }
        this.call.setResult(result);
        Invoke reply = new Invoke();
        reply.setCall(this.call);
        reply.setTransactionId(this.transactionId);
        channel.write(reply);
        channel.getConnection().unregisterDeferredResult(this);
    }

    public boolean wasSent() {
        return this.resultSent;
    }

    public void setTransactionId(int id) {
        this.transactionId = id;
    }

    public void setServiceCall(IPendingServiceCall call) {
        this.call = call;
    }

    public void setChannel(Channel channel) {
        this.channel = new WeakReference<Channel>(channel);
    }
}

