/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.scope;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import org.apache.commons.lang3.StringUtils;
import org.red5.server.AttributeStore;
import org.red5.server.Server;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.IServer;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.persistence.PersistenceUtils;
import org.red5.server.api.scope.IBasicScope;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IGlobalScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.IScopeAware;
import org.red5.server.api.scope.IScopeHandler;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.api.statistics.IScopeStatistics;
import org.red5.server.api.statistics.support.StatisticsCounter;
import org.red5.server.exception.ScopeException;
import org.red5.server.jmx.mxbeans.ScopeMXBean;
import org.red5.server.scope.BasicScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(objectName="org.red5.server:type=Scope", description="Scope")
public class Scope
extends BasicScope
implements IScope,
IScopeStatistics,
ScopeMXBean {
    protected static Logger log = LoggerFactory.getLogger(Scope.class);
    private static final int UNSET = -1;
    private long creationTime;
    private int depth = -1;
    private boolean enabled = true;
    private boolean running;
    private boolean autoStart = true;
    private transient IContext context;
    private transient IScopeHandler handler;
    private volatile transient ConcurrentMap<String, Object> serviceHandlers;
    private final transient ConcurrentScopeSet children;
    private final transient CopyOnWriteArraySet<IClient> clients;
    protected final transient StatisticsCounter connectionStats = new StatisticsCounter();
    protected final transient StatisticsCounter subscopeStats = new StatisticsCounter();
    protected final AttributeStore attributes = new AttributeStore();
    protected ObjectName oName;

    @ConstructorProperties(value={""})
    public Scope() {
        super(null, ScopeType.UNDEFINED, null, false);
        this.creationTime = System.currentTimeMillis();
        this.children = new ConcurrentScopeSet();
        this.clients = new CopyOnWriteArraySet();
    }

    @ConstructorProperties(value={"builder"})
    public Scope(Builder builder) {
        super(builder.parent, builder.type, builder.name, builder.persistent);
        this.creationTime = System.currentTimeMillis();
        this.children = new ConcurrentScopeSet();
        this.clients = new CopyOnWriteArraySet();
    }

    @Override
    public boolean addChildScope(IBasicScope scope) {
        boolean added;
        block9: {
            log.debug("Add child: {}", (Object)scope);
            added = false;
            if (scope.isValid()) {
                try {
                    if (!this.children.containsKey(scope)) {
                        log.debug("Adding child scope: {} to {}", (Object)scope, (Object)this);
                        added = this.children.add(scope);
                        break block9;
                    }
                    log.warn("Child scope already exists");
                }
                catch (Exception e) {
                    log.warn("Exception on add subscope", (Throwable)e);
                }
            } else {
                log.warn("Invalid scope rejected: {}", (Object)scope);
            }
        }
        if (added && scope.getStore() == null) {
            try {
                if (scope instanceof Scope) {
                    ((Scope)scope).setPersistenceClass(this.persistenceClass);
                }
            }
            catch (Exception error) {
                log.error("Could not set persistence class", (Throwable)error);
            }
        }
        return added;
    }

    @Override
    public boolean connect(IConnection conn) {
        return this.connect(conn, null);
    }

    @Override
    public boolean connect(IConnection conn, Object[] params) {
        log.debug("Connect - scope: {} connection: {}", (Object)this, (Object)conn);
        if (this.enabled) {
            if (this.hasParent() && !this.parent.connect(conn, params)) {
                log.debug("Connection to parent failed");
                return false;
            }
            if (this.hasHandler() && !this.getHandler().connect(conn, this, params)) {
                log.debug("Connection to handler failed");
                return false;
            }
            if (!conn.isConnected()) {
                log.debug("Connection is not connected");
                return false;
            }
            IClient client = conn.getClient();
            if (this.hasHandler() && !this.getHandler().join(client, this)) {
                return false;
            }
            if (!conn.isConnected()) {
                return false;
            }
            if (this.clients.add(client) && this.addEventListener(conn)) {
                IServer server;
                log.debug("Added client");
                this.connectionStats.increment();
                IScope connScope = conn.getScope();
                log.trace("Connection scope: {}", (Object)connScope);
                if (this.equals(connScope) && (server = this.getServer()) instanceof Server) {
                    ((Server)server).notifyConnected(conn);
                }
                return true;
            }
        } else {
            log.debug("Connection failed, scope is disabled");
        }
        return false;
    }

    @Override
    public boolean createChildScope(String name) {
        log.debug("createChildScope: {}", (Object)name);
        if (!this.children.hasName(name)) {
            return this.addChildScope(new Builder(this, ScopeType.ROOM, name, false).build());
        }
        log.debug("Scope: {} already exists, children: {}", (Object)name, this.children.getNames());
        return false;
    }

    @Override
    public void destroy() throws Exception {
        log.debug("Destroy scope");
        if (this.hasParent()) {
            this.parent.removeChildScope(this);
        }
        if (this.hasHandler()) {
            this.getHandler().stop(this);
        }
        for (IBasicScope child : this.children.keySet()) {
            this.removeChildScope(child);
            if (!(child instanceof Scope)) continue;
            ((Scope)child).uninit();
        }
    }

    @Override
    public void disconnect(IConnection conn) {
        log.debug("Disconnect: {}", (Object)conn);
        IClient client = conn.getClient();
        if (client == null) {
            this.removeEventListener(conn);
            this.connectionStats.decrement();
            if (this.hasParent()) {
                this.parent.disconnect(conn);
            }
            return;
        }
        if (this.clients.remove(client)) {
            IServer server;
            IScopeHandler handler = this.getHandler();
            if (handler != null) {
                try {
                    handler.disconnect(conn, this);
                }
                catch (Exception e) {
                    log.error("Error while executing \"disconnect\" for connection {} on handler {}. {}", new Object[]{conn, handler, e});
                }
                try {
                    handler.leave(client, this);
                }
                catch (Exception e) {
                    log.error("Error while executing \"leave\" for client {} on handler {}. {}", new Object[]{conn, handler, e});
                }
            }
            this.removeEventListener(conn);
            this.connectionStats.decrement();
            if (this.equals(conn.getScope()) && (server = this.getServer()) instanceof Server) {
                ((Server)server).notifyDisconnected(conn);
            }
        }
        if (this.hasParent()) {
            this.parent.disconnect(conn);
        }
    }

    @Override
    public void dispatchEvent(IEvent event) {
        Set<IConnection> conns = this.getClientConnections();
        for (IConnection conn : conns) {
            try {
                conn.dispatchEvent(event);
            }
            catch (RuntimeException e) {
                log.error("Exception during dispatching event: {}", (Object)event, (Object)e);
            }
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.getAttribute(name);
    }

    @Override
    public boolean setAttribute(String name, Object value) {
        return this.attributes.setAttribute(name, value);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributes.hasAttribute(name);
    }

    @Override
    public boolean removeAttribute(String name) {
        return this.attributes.removeAttribute(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributes.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes.getAttributes();
    }

    @Override
    public int getActiveClients() {
        return this.clients.size();
    }

    @Override
    public int getActiveConnections() {
        return this.connectionStats.getCurrent();
    }

    @Override
    public int getActiveSubscopes() {
        return this.subscopeStats.getCurrent();
    }

    @Override
    public IBroadcastScope getBroadcastScope(String name) {
        return (IBroadcastScope)this.children.getBasicScope(ScopeType.BROADCAST, name);
    }

    @Override
    public IBasicScope getBasicScope(ScopeType type, String name) {
        return this.children.getBasicScope(type, name);
    }

    @Override
    public Set<String> getBasicScopeNames(ScopeType type) {
        if (type != null) {
            HashSet<String> names = new HashSet<String>();
            for (IBasicScope child : this.children.keySet()) {
                if (!child.getType().equals((Object)type)) continue;
                names.add(child.getName());
            }
            return names;
        }
        return this.getScopeNames();
    }

    public ClassLoader getClassLoader() {
        return this.getContext().getClassLoader();
    }

    @Override
    public Set<IClient> getClients() {
        return this.clients;
    }

    @Override
    @Deprecated
    public Collection<Set<IConnection>> getConnections() {
        ArrayList<Set<IConnection>> result = new ArrayList<Set<IConnection>>(3);
        result.add(this.getClientConnections());
        return result;
    }

    @Override
    public Set<IConnection> getClientConnections() {
        HashSet<IConnection> result = new HashSet<IConnection>(3);
        log.debug("Client count: {}", (Object)this.clients.size());
        for (IClient cli : this.clients) {
            Set<IConnection> set = cli.getConnections();
            log.debug("Client connection count: {}", (Object)set.size());
            if (set.size() > 1) {
                log.warn("Client connections exceeded expected single count; size: {}", (Object)set.size());
            }
            for (IConnection conn : set) {
                result.add(conn);
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public Set<IConnection> lookupConnections(IClient client) {
        HashSet<IConnection> result = new HashSet<IConnection>(1);
        if (this.clients.contains(client)) {
            for (IClient cli : this.clients) {
                if (!cli.equals(client)) continue;
                Set<IConnection> set = cli.getConnections();
                if (set.size() > 1) {
                    log.warn("Client connections exceeded expected single count; size: {}", (Object)set.size());
                }
                result.add(set.iterator().next());
                break;
            }
        }
        return result;
    }

    @Override
    public IConnection lookupConnection(IClient client) {
        for (IClient cli : this.clients) {
            if (!cli.equals(client)) continue;
            Set<IConnection> set = cli.getConnections();
            if (set.size() > 1) {
                log.warn("Client connections exceeded expected single count; size: {}", (Object)set.size());
            }
            return set.iterator().next();
        }
        return null;
    }

    @Override
    public IContext getContext() {
        if (!this.hasContext() && this.hasParent()) {
            return this.parent.getContext();
        }
        return this.context;
    }

    @Override
    public String getContextPath() {
        if (this.hasContext()) {
            return "";
        }
        if (this.hasParent()) {
            return this.parent.getContextPath() + '/' + this.name;
        }
        return null;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public int getDepth() {
        if (this.depth == -1) {
            this.depth = this.hasParent() ? this.parent.getDepth() + 1 : 0;
        }
        return this.depth;
    }

    @Override
    public IScopeHandler getHandler() {
        log.trace("getHandler from {}", (Object)this.name);
        if (this.handler != null) {
            return this.handler;
        }
        if (this.hasParent()) {
            return this.getParent().getHandler();
        }
        return null;
    }

    @Override
    @Deprecated
    public int getMaxClients() {
        return this.connectionStats.getMax();
    }

    @Override
    public int getMaxConnections() {
        return this.connectionStats.getMax();
    }

    @Override
    public int getMaxSubscopes() {
        return this.subscopeStats.getMax();
    }

    @Override
    public IScope getParent() {
        return this.parent;
    }

    @Override
    public String getPath() {
        if (this.hasParent()) {
            return this.parent.getPath() + '/' + this.parent.getName();
        }
        return "";
    }

    public Resource getResource(String path) {
        if (this.hasContext()) {
            return this.context.getResource(path);
        }
        return this.getContext().getResource(this.getContextPath() + '/' + path);
    }

    public Resource[] getResources(String path) throws IOException {
        if (this.hasContext()) {
            return this.context.getResources(path);
        }
        return this.getContext().getResources(this.getContextPath() + '/' + path);
    }

    @Override
    public IScope getScope(String name) {
        IBasicScope child = this.children.getBasicScope(ScopeType.UNDEFINED, name);
        log.debug("Child of {}: {}", (Object)this.name, (Object)child);
        if (child != null) {
            if (child instanceof IScope) {
                return (IScope)child;
            }
            log.warn("Requested scope: {} is not of IScope type: {}", (Object)name, (Object)child.getClass().getName());
        }
        return null;
    }

    @Override
    public Set<String> getScopeNames() {
        log.debug("Children: {}", (Object)this.children);
        return this.children.getNames();
    }

    @Override
    public Object getServiceHandler(String name) {
        Map<String, Object> serviceHandlers = this.getServiceHandlers(false);
        if (serviceHandlers == null) {
            return null;
        }
        return serviceHandlers.get(name);
    }

    @Override
    public Set<String> getServiceHandlerNames() {
        Map<String, Object> serviceHandlers = this.getServiceHandlers(false);
        if (serviceHandlers == null) {
            return Collections.EMPTY_SET;
        }
        return serviceHandlers.keySet();
    }

    protected Map<String, Object> getServiceHandlers() {
        return this.getServiceHandlers(true);
    }

    protected Map<String, Object> getServiceHandlers(boolean allowCreate) {
        if (this.serviceHandlers == null && allowCreate) {
            this.serviceHandlers = new ConcurrentHashMap<String, Object>(3, 0.9f, 1);
        }
        return this.serviceHandlers;
    }

    @Override
    public IScopeStatistics getStatistics() {
        return this;
    }

    @Override
    @Deprecated
    public int getTotalClients() {
        return this.connectionStats.getTotal();
    }

    @Override
    public int getTotalConnections() {
        return this.connectionStats.getTotal();
    }

    @Override
    public int getTotalSubscopes() {
        return this.subscopeStats.getTotal();
    }

    @Override
    public boolean handleEvent(IEvent event) {
        return false;
    }

    @Override
    public boolean hasChildScope(String name) {
        log.debug("Has child scope? {} in {}", (Object)name, (Object)this);
        return this.children.hasName(name);
    }

    @Override
    public boolean hasChildScope(ScopeType type, String name) {
        log.debug("Has child scope? {} in {}", (Object)name, (Object)this);
        return this.children.getBasicScope(type, name) != null;
    }

    @Override
    public boolean hasContext() {
        return this.context != null;
    }

    @Override
    public boolean hasHandler() {
        return this.handler != null || this.hasParent() && this.getParent().hasHandler();
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void init() {
        log.debug("Init scope: {} parent: {}", (Object)this.name, (Object)this.parent);
        if (this.hasParent()) {
            if (this.parent.hasChildScope(this.name)) {
                throw new ScopeException("Scope already exists in parent");
            }
            if (!this.parent.addChildScope(this)) {
                log.warn("Scope not added to parent");
                return;
            }
            log.debug("Scope added to parent");
        } else {
            log.debug("Scope has no parent");
        }
        if (this.autoStart) {
            this.start();
        }
    }

    public void uninit() {
        log.debug("Un-init scope");
        for (IBasicScope child : this.children.keySet()) {
            if (!(child instanceof Scope)) continue;
            ((Scope)child).uninit();
        }
        this.stop();
        this.setEnabled(false);
        if (this.hasParent() && this.parent.hasChildScope(this.name)) {
            this.parent.removeChildScope(this);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.isEnabled();
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean getRunning() {
        return this.isRunning();
    }

    @Override
    public void registerServiceHandler(String name, Object handler) {
        Map<String, Object> serviceHandlers = this.getServiceHandlers();
        serviceHandlers.put(name, handler);
    }

    @Override
    public void removeChildScope(IBasicScope scope) {
        log.debug("removeChildScope: {}", (Object)scope);
        if (this.children.containsKey(scope)) {
            this.children.remove(scope);
            if (scope instanceof Scope) {
                this.unregisterJMX();
            }
        }
    }

    @Override
    public void removeChildren() {
        log.trace("removeChildren of {}", (Object)this.name);
        for (IBasicScope child : this.children.keySet()) {
            this.removeChildScope(child);
        }
    }

    @Override
    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    @Override
    public void setChildLoadPath(String pattern) {
    }

    public void setContext(IContext context) {
        log.debug("Set context: {}", (Object)context);
        this.context = context;
    }

    @Override
    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setHandler(IScopeHandler handler) {
        log.debug("setHandler: {} on {}", (Object)handler, (Object)this.name);
        this.handler = handler;
        if (handler instanceof IScopeAware) {
            ((IScopeAware)((Object)handler)).setScope(this);
        }
    }

    @Override
    public final void setName(String name) {
        log.debug("Set name: {}", (Object)name);
        if (this.name == null && StringUtils.isNotBlank((CharSequence)name)) {
            this.name = name;
            if (this.oName != null) {
                this.unregisterJMX();
            }
            this.registerJMX();
        } else {
            log.info("Scope {} name reset to: {} disallowed", (Object)this.name, (Object)name);
        }
    }

    public void setParent(IScope parent) {
        log.debug("Set parent scope: {}", (Object)parent);
        this.parent = parent;
    }

    @Override
    public void setPersistenceClass(String persistenceClass) throws Exception {
        this.persistenceClass = persistenceClass;
        if (persistenceClass != null) {
            this.store = PersistenceUtils.getPersistenceStore(this, persistenceClass);
        }
    }

    @Override
    public boolean start() {
        log.debug("Start scope");
        boolean result = false;
        if (this.enabled && !this.running) {
            if (this.handler != null) {
                log.debug("Scope {} has a handler {}", (Object)this.getName(), (Object)this.handler);
            } else {
                log.debug("{} has no handler, adding parent handler", (Object)this);
                this.handler = this.parent.getHandler();
            }
            try {
                if (this.handler != null) {
                    result = this.handler.start(this);
                } else {
                    log.debug("{} has no handler of its own, allowing start", (Object)this);
                    result = true;
                }
            }
            catch (Throwable e) {
                log.error("Could not start scope {}", (Object)this, (Object)e);
            }
            finally {
                ((Server)this.getServer()).notifyScopeCreated(this);
            }
            this.running = result;
        }
        return result;
    }

    @Override
    public void stop() {
        log.debug("stop: {}", (Object)this.name);
        if (this.enabled && this.running && this.handler != null) {
            try {
                this.handler.stop(this);
            }
            catch (Throwable e) {
                log.error("Could not stop scope {}", (Object)this, (Object)e);
            }
            finally {
                ((Server)this.getServer()).notifyScopeRemoved(this);
            }
            this.removeChildren();
        }
        this.running = false;
    }

    public String toString() {
        return "Scope [name=" + this.getName() + ", path=" + this.getPath() + ", type=" + (Object)((Object)this.type) + ", autoStart=" + this.autoStart + ", creationTime=" + this.creationTime + ", depth=" + this.getDepth() + ", enabled=" + this.enabled + ", running=" + this.running + "]";
    }

    @Override
    public void unregisterServiceHandler(String name) {
        Map<String, Object> serviceHandlers = this.getServiceHandlers(false);
        if (serviceHandlers != null) {
            serviceHandlers.remove(name);
        }
    }

    public IServer getServer() {
        if (this.hasParent()) {
            IScope parent = this.getParent();
            if (parent instanceof Scope) {
                return ((Scope)parent).getServer();
            }
            if (parent instanceof IGlobalScope) {
                return ((IGlobalScope)parent).getServer();
            }
        }
        return null;
    }

    public void dump() {
        if (log.isTraceEnabled()) {
            log.trace("Scope: {} {}", (Object)this.getClass().getName(), (Object)this);
            log.trace("Running: {}", (Object)this.running);
            if (this.hasParent()) {
                log.trace("Parent: {}", (Object)this.parent);
                Set<String> names = this.parent.getBasicScopeNames(null);
                log.trace("Sibling count: {}", (Object)names.size());
                for (String sib : names) {
                    log.trace("Siblings - {}", (Object)sib);
                }
                Iterator iterator = null;
            }
            log.trace("Handler: {}", (Object)this.handler);
            log.trace("Child count: {}", (Object)this.children.size());
            for (IBasicScope child : this.children.keySet()) {
                log.trace("Child: {}", (Object)child);
            }
        }
    }

    protected void registerJMX() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            String cName = this.getClass().getName();
            if (cName.indexOf(46) != -1) {
                cName = cName.substring(cName.lastIndexOf(46)).replaceFirst("[\\.]", "");
            }
            this.oName = new ObjectName(String.format("org.red5.server:type=%s,name=%s", cName, this.name));
            if (!mbs.isRegistered(this.oName)) {
                mbs.registerMBean(new StandardMBean(this, ScopeMXBean.class, true), this.oName);
            }
        }
        catch (Exception e) {
            log.warn("Error on jmx registration", (Throwable)e);
        }
    }

    protected void unregisterJMX() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (this.oName != null && mbs.isRegistered(this.oName)) {
            try {
                mbs.unregisterMBean(this.oName);
            }
            catch (Exception e) {
                log.warn("Exception unregistering: {}", (Object)this.oName, (Object)e);
            }
            this.oName = null;
        }
    }

    public static Scope from(CompositeData cd) {
        IScope parent = null;
        ScopeType type = ScopeType.UNDEFINED;
        String name = null;
        boolean persistent = false;
        if (cd.containsKey("parent")) {
            parent = (IScope)cd.get("parent");
        }
        if (cd.containsKey("type")) {
            type = (ScopeType)((Object)cd.get("type"));
        }
        if (cd.containsKey("name")) {
            name = (String)cd.get("name");
        }
        if (cd.containsKey("persistent")) {
            persistent = (Boolean)cd.get("persistent");
        }
        return new Scope(new Builder(parent, type, name, persistent));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getPath() == null ? 0 : this.getPath().hashCode());
        result = 31 * result + this.getDepth();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Scope other = (Scope)obj;
        return this.hashCode() == other.hashCode();
    }

    public static final class Builder {
        private IScope parent;
        private ScopeType type;
        private String name;
        private boolean persistent;

        public Builder(IScope parent, ScopeType type, String name, boolean persistent) {
            this.parent = parent;
            this.type = type;
            this.name = name;
            this.persistent = persistent;
        }

        public Scope build() {
            return new Scope(this);
        }
    }

    private final class ConcurrentScopeSet
    extends ConcurrentHashMap<IBasicScope, Boolean> {
        private static final long serialVersionUID = -6702012956307490749L;

        ConcurrentScopeSet() {
            super(3, 0.9f);
        }

        public boolean add(IBasicScope scope) {
            boolean added = false;
            if (!this.containsKey(scope)) {
                log.debug("Adding child scope: {} to {}", (Object)scope.getName(), (Object)this);
                if (Scope.this.hasHandler()) {
                    IScopeHandler hdlr = Scope.this.getHandler();
                    if (!hdlr.addChildScope(scope)) {
                        log.warn("Failed to add child scope: {} to {}", (Object)scope, (Object)this);
                        return false;
                    }
                } else {
                    log.debug("No handler found for {}", (Object)this);
                }
                try {
                    if (!this.containsKey(scope)) {
                        boolean bl = added = super.put(scope, Boolean.TRUE) == null;
                        if (added) {
                            Scope.this.subscopeStats.increment();
                        } else {
                            log.debug("Subscope was not added");
                        }
                    } else {
                        log.debug("Subscope already exists");
                    }
                }
                catch (Exception e) {
                    log.warn("Exception on add", (Throwable)e);
                }
                if (added && scope instanceof Scope) {
                    Scope scp = (Scope)scope;
                    if (scp.start()) {
                        log.debug("Child scope started");
                    } else {
                        log.debug("Failed to start child scope: {} in {}", (Object)scope, (Object)this);
                    }
                }
            }
            return added;
        }

        @Override
        public Boolean remove(Object scope) {
            log.debug("Remove child scope: {}", scope);
            if (Scope.this.hasHandler()) {
                IScopeHandler hdlr = Scope.this.getHandler();
                log.debug("Removing child scope: {}", (Object)((IBasicScope)scope).getName());
                hdlr.removeChildScope((IBasicScope)scope);
                if (scope instanceof Scope) {
                    Scope scp = (Scope)scope;
                    scp.stop();
                }
            } else {
                log.debug("No handler found for {}", (Object)this);
            }
            boolean removed = false;
            try {
                if (this.containsKey(scope)) {
                    removed = ((Boolean)super.remove(scope)).equals(Boolean.TRUE);
                    if (removed) {
                        Scope.this.subscopeStats.decrement();
                    } else {
                        log.debug("Subscope was not removed");
                    }
                } else {
                    log.debug("Subscope was not removed, it was not found");
                }
            }
            catch (Exception e) {
                log.warn("Exception on remove", (Throwable)e);
            }
            return removed;
        }

        @Override
        public boolean contains(Object scope) {
            return ((ConcurrentHashMap.KeySetView)this.keySet()).contains(scope);
        }

        public Set<String> getNames() {
            HashSet<String> names = new HashSet<String>();
            for (IBasicScope child : this.keySet()) {
                names.add(child.getName());
            }
            return names;
        }

        public boolean hasName(String name) {
            if (log.isDebugEnabled()) {
                log.debug("hasName: {}", (Object)name);
            }
            if (name != null) {
                for (IBasicScope child : this.keySet()) {
                    if (!name.equals(child.getName())) continue;
                    return true;
                }
            } else {
                log.info("Invalid scope name, null is not allowed");
            }
            return false;
        }

        public IBasicScope getBasicScope(ScopeType type, String name) {
            boolean skipTypeCheck = ScopeType.UNDEFINED.equals((Object)type);
            if (skipTypeCheck) {
                for (IBasicScope child : this.keySet()) {
                    if (!name.equals(child.getName())) continue;
                    log.debug("Returning basic scope: {}", (Object)child);
                    return child;
                }
            } else {
                for (IBasicScope child : this.keySet()) {
                    if (!child.getType().equals((Object)type) || !name.equals(child.getName())) continue;
                    log.debug("Returning basic scope: {}", (Object)child);
                    return child;
                }
            }
            return null;
        }
    }
}

