/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.red5.server.util.PropertyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static void copyFile(File source, File dest) throws IOException {
        log.debug("Copy from {} to {}", (Object)source.getAbsoluteFile(), (Object)dest.getAbsoluteFile());
        FileInputStream fi = new FileInputStream(source);
        FileChannel fic = fi.getChannel();
        MappedByteBuffer mbuf = fic.map(FileChannel.MapMode.READ_ONLY, 0L, source.length());
        fic.close();
        fi.close();
        fi = null;
        if (!dest.exists()) {
            String destPath = dest.getPath();
            log.debug("Destination path: {}", (Object)destPath);
            String destDir = destPath.substring(0, destPath.lastIndexOf(File.separatorChar));
            log.debug("Destination dir: {}", (Object)destDir);
            File dir = new File(destDir);
            if (!dir.exists()) {
                if (dir.mkdirs()) {
                    log.debug("Directory created");
                } else {
                    log.warn("Directory not created");
                }
            }
            dir = null;
        }
        FileOutputStream fo = new FileOutputStream(dest);
        FileChannel foc = fo.getChannel();
        foc.write(mbuf);
        foc.close();
        fo.close();
        fo = null;
        mbuf.clear();
        mbuf = null;
    }

    public static void copyFile(String source, String dest) throws IOException {
        FileUtil.copyFile(new File(source), new File(dest));
    }

    public static void moveFile(String source, String dest) throws IOException {
        FileUtil.copyFile(source, dest);
        File src = new File(source);
        if (src.exists() && src.canRead()) {
            if (src.delete()) {
                log.debug("Source file was deleted");
            } else {
                log.debug("Source file was not deleted, the file will be deleted on exit");
                src.deleteOnExit();
            }
        } else {
            log.warn("Source file could not be accessed for removal");
        }
        src = null;
    }

    public static boolean deleteDirectory(String directory) throws IOException {
        return FileUtil.deleteDirectory(directory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteDirectory(String directory, boolean useOSNativeDelete) throws IOException {
        boolean result = false;
        if (!useOSNativeDelete) {
            File dir = new File(directory);
            for (File file : dir.listFiles()) {
                if (file.delete()) {
                    log.debug("{} was deleted", (Object)file.getName());
                } else {
                    log.debug("{} was not deleted", (Object)file.getName());
                    file.deleteOnExit();
                }
                file = null;
            }
            if (dir.delete()) {
                log.debug("Directory was deleted");
                result = true;
            } else {
                log.debug("Directory was not deleted, it may be deleted on exit");
                dir.deleteOnExit();
            }
            dir = null;
        } else {
            Process p = null;
            Thread std = null;
            try {
                Runtime runTime = Runtime.getRuntime();
                log.debug("Execute runtime");
                p = File.separatorChar == '\\' ? runTime.exec("CMD /D /C \"RMDIR /Q /S " + directory.replace('/', '\\') + "\"") : runTime.exec("rm -rf " + directory.replace('\\', File.separatorChar));
                std = FileUtil.stdOut(p);
                while (std.isAlive()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception exception) {}
                }
                log.debug("Process threads wait exited");
                result = true;
            }
            catch (Exception e) {
                log.error("Error running delete script", (Throwable)e);
            }
            finally {
                if (null != p) {
                    log.debug("Destroying process");
                    p.destroy();
                    p = null;
                }
                std = null;
            }
        }
        return result;
    }

    public static void rename(String from, String to) {
        try {
            Files.move(Paths.get(from, new String[0]), Paths.get(to, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            log.error("Error renaming file", (Throwable)e);
        }
    }

    private static final Thread stdOut(final Process p) {
        final byte[] empty = new byte[128];
        for (int b = 0; b < empty.length; ++b) {
            empty[b] = 0;
        }
        Thread std = new Thread(){

            @Override
            public void run() {
                StringBuilder sb = new StringBuilder(1024);
                byte[] buf = new byte[128];
                BufferedInputStream bis = new BufferedInputStream(p.getInputStream());
                log.debug("Process output:");
                try {
                    while (bis.read(buf) != -1) {
                        sb.append(new String(buf).trim());
                        System.arraycopy(empty, 0, buf, 0, buf.length);
                    }
                    log.debug(sb.toString());
                    bis.close();
                }
                catch (Exception e) {
                    log.error("{}", (Throwable)e);
                }
            }
        };
        std.setDaemon(true);
        std.start();
        return std;
    }

    public static boolean makeDirectory(String directory) throws IOException {
        return FileUtil.makeDirectory(directory, false);
    }

    public static boolean makeDirectory(String directory, boolean createParents) throws IOException {
        boolean created = false;
        File dir = new File(directory);
        if (createParents) {
            created = dir.mkdirs();
            if (created) {
                log.debug("Directory created: {}", (Object)dir.getAbsolutePath());
            } else {
                log.debug("Directory was not created: {}", (Object)dir.getAbsolutePath());
            }
        } else {
            created = dir.mkdir();
            if (created) {
                log.debug("Directory created: {}", (Object)dir.getAbsolutePath());
            } else {
                log.debug("Directory was not created: {}", (Object)dir.getAbsolutePath());
            }
        }
        dir = null;
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String compressedFileName, String destinationDir) {
        String dirName = null;
        String applicationName = compressedFileName.substring(compressedFileName.lastIndexOf("/"));
        int dashIndex = applicationName.indexOf(45);
        dirName = dashIndex != -1 ? compressedFileName.substring(0, dashIndex) : compressedFileName.substring(0, compressedFileName.lastIndexOf(46));
        log.debug("Directory: {}", (Object)dirName);
        File zipDir = new File(compressedFileName);
        File parent = zipDir.getParentFile();
        log.debug("Parent: {}", (Object)(parent != null ? parent.getName() : null));
        File tmpDir = new File(destinationDir);
        log.debug("Making directory: {}", (Object)tmpDir.mkdirs());
        ZipFile zf = null;
        try {
            zf = new ZipFile(compressedFileName);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                log.debug("Unzipping {}", (Object)ze.getName());
                if (ze.isDirectory()) {
                    log.debug("is a directory");
                    File dir = new File(tmpDir + "/" + ze.getName());
                    Boolean tmp = dir.mkdir();
                    log.debug("{}", (Object)tmp);
                    continue;
                }
                if (ze.getName().lastIndexOf("/") != -1) {
                    String zipName = ze.getName();
                    String zipDirStructure = zipName.substring(0, zipName.lastIndexOf("/"));
                    File completeDirectory = new File(tmpDir + "/" + zipDirStructure);
                    if (!completeDirectory.exists() && !completeDirectory.mkdirs()) {
                        log.error("could not create complete directory structure");
                    }
                }
                FileOutputStream fout = new FileOutputStream(tmpDir + "/" + ze.getName());
                InputStream in = zf.getInputStream(ze);
                FileUtil.copy(in, fout);
                in.close();
                fout.close();
            }
            e = null;
        }
        catch (IOException e) {
            log.error("Errored unzipping", (Throwable)e);
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        InputStream inputStream = in;
        synchronized (inputStream) {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                byte[] buffer = new byte[256];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }

    public static String formatPath(String absWebappsPath, String contextDirName) {
        StringBuilder path = new StringBuilder(absWebappsPath.length() + contextDirName.length());
        path.append(absWebappsPath);
        if (log.isTraceEnabled()) {
            log.trace("Path start: {}", (Object)path.toString());
        }
        int idx = -1;
        if (File.separatorChar != '/') {
            while ((idx = path.indexOf(File.separator)) != -1) {
                path.deleteCharAt(idx);
                path.insert(idx, '/');
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Path step 1: {}", (Object)path.toString());
        }
        if ((idx = path.indexOf("./")) != -1) {
            path.delete(idx, idx + 2);
        }
        if (log.isTraceEnabled()) {
            log.trace("Path step 2: {}", (Object)path.toString());
        }
        if (path.charAt(path.length() - 1) != '/') {
            path.append('/');
        }
        if (log.isTraceEnabled()) {
            log.trace("Path step 3: {}", (Object)path.toString());
        }
        if (contextDirName.charAt(0) == '/' && path.charAt(path.length() - 1) == '/') {
            path.append(contextDirName.substring(1));
        } else {
            path.append(contextDirName);
        }
        if (log.isTraceEnabled()) {
            log.trace("Path step 4: {}", (Object)path.toString());
        }
        return path.toString();
    }

    public static String generateCustomName() {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        sb.append(PropertyConverter.getCurrentTimeSeconds());
        sb.append('_');
        int i = random.nextInt(99999);
        if (i < 10) {
            sb.append("0000");
        } else if (i < 100) {
            sb.append("000");
        } else if (i < 1000) {
            sb.append("00");
        } else if (i < 10000) {
            sb.append('0');
        }
        sb.append(i);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAsByteArray(File localSwfFile) {
        byte[] fileBytes = new byte[(int)localSwfFile.length()];
        byte[] b = new byte[1];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(localSwfFile);
            for (int i = 0; i < Integer.MAX_VALUE && fis.read(b) != -1; ++i) {
                fileBytes[i] = b[0];
            }
        }
        catch (IOException e) {
            log.warn("Exception reading file bytes", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return fileBytes;
    }
}

