/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.api.statistics.support;

import java.util.concurrent.atomic.AtomicInteger;

public class StatisticsCounter {
    private AtomicInteger current = new AtomicInteger();
    private AtomicInteger total = new AtomicInteger();
    private AtomicInteger max = new AtomicInteger();

    public void increment() {
        this.total.incrementAndGet();
        this.max.compareAndSet(this.current.intValue(), this.current.incrementAndGet());
    }

    public void decrement() {
        this.current.decrementAndGet();
    }

    public int getCurrent() {
        return this.current.intValue();
    }

    public int getTotal() {
        return this.total.intValue();
    }

    public int getMax() {
        return this.max.intValue();
    }

    public String toString() {
        return "StatisticsCounter [current=" + this.current + ", total=" + this.total + ", max=" + this.max + "]";
    }
}

