/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.openmbean.CompositeData;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.ICastingAttributeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeStore
implements ICastingAttributeStore {
    protected static Logger log = LoggerFactory.getLogger(AttributeStore.class);
    protected ConcurrentMap<String, Object> attributes = new ConcurrentAttributesMap<String, Object>(1);

    public AttributeStore() {
    }

    public AttributeStore(Map<String, Object> values) {
        this.setAttributes(values);
    }

    public AttributeStore(IAttributeStore values) {
        this.setAttributes(values);
    }

    protected Map<String, Object> filterNull(Map<String, Object> values) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (key == null || (value = entry.getValue()) == null) continue;
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Object getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Object getAttribute(Enum<?> enm) {
        return this.getAttribute(enm.name());
    }

    @Override
    public Object getAttribute(String name, Object defaultValue) {
        if (name == null) {
            return null;
        }
        if (defaultValue == null) {
            throw new NullPointerException("the default value may not be null");
        }
        Object result = this.attributes.put(name, defaultValue);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public boolean hasAttribute(String name) {
        if (name == null) {
            return false;
        }
        return this.attributes.containsKey(name);
    }

    public boolean hasAttribute(Enum<?> enm) {
        return this.hasAttribute(enm.name());
    }

    @Override
    public boolean setAttribute(String name, Object value) {
        boolean result = false;
        if (name != null && value != null) {
            Object previous = this.attributes.get(name);
            if (log.isTraceEnabled()) {
                log.trace("setAttribute\nprevious: {}\nnew: {}", previous, value);
            }
            this.attributes.put(name, value);
            if (previous != null) {
                if (value instanceof Collection) {
                    Collection prevCollection = (Collection)previous;
                    Collection newCollection = (Collection)value;
                    for (Object newCollectionEntry : newCollection) {
                        int freq = Collections.frequency(prevCollection, newCollectionEntry);
                        if (freq != 0) continue;
                        result = true;
                        break;
                    }
                } else if (value instanceof Map) {
                    Map prevMap = (Map)previous;
                    Map newMap = (Map)value;
                    if (!prevMap.keySet().containsAll(newMap.keySet())) {
                        result = true;
                    } else {
                        for (Map.Entry newMapEntry : newMap.entrySet()) {
                            Object prevValue = prevMap.get(newMapEntry.getKey());
                            if (prevValue == null) {
                                result = true;
                            } else {
                                if (prevValue.equals(newMapEntry.getValue())) continue;
                                result = true;
                            }
                            break;
                        }
                    }
                } else {
                    boolean bl = result = !value.equals(previous);
                    if (log.isTraceEnabled()) {
                        log.trace("Equality check - modified: {} -> {} = {}", new Object[]{result, value, previous});
                    }
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    public boolean setAttribute(Enum<?> enm, Object value) {
        return this.setAttribute(enm.name(), value);
    }

    @Override
    public boolean setAttributes(Map<String, Object> values) {
        this.attributes.putAll(this.filterNull(values));
        return true;
    }

    @Override
    public boolean setAttributes(IAttributeStore values) {
        return this.setAttributes(values.getAttributes());
    }

    @Override
    public boolean removeAttribute(String name) {
        if (name != null) {
            return this.attributes.remove(name) != null;
        }
        return false;
    }

    public boolean removeAttribute(Enum<?> enm) {
        return this.removeAttribute(enm.name());
    }

    @Override
    public void removeAttributes() {
        this.attributes.clear();
    }

    @Override
    public int size() {
        return this.attributes != null ? this.attributes.size() : 0;
    }

    @Override
    public Boolean getBoolAttribute(String name) {
        return (Boolean)this.getAttribute(name);
    }

    @Override
    public Byte getByteAttribute(String name) {
        return (Byte)this.getAttribute(name);
    }

    @Override
    public Double getDoubleAttribute(String name) {
        return (Double)this.getAttribute(name);
    }

    @Override
    public Integer getIntAttribute(String name) {
        return (Integer)this.getAttribute(name);
    }

    @Override
    public List<?> getListAttribute(String name) {
        return (List)this.getAttribute(name);
    }

    @Override
    public Long getLongAttribute(String name) {
        return (Long)this.getAttribute(name);
    }

    @Override
    public Map<?, ?> getMapAttribute(String name) {
        return (Map)this.getAttribute(name);
    }

    @Override
    public Set<?> getSetAttribute(String name) {
        return (Set)this.getAttribute(name);
    }

    @Override
    public Short getShortAttribute(String name) {
        return (Short)this.getAttribute(name);
    }

    @Override
    public String getStringAttribute(String name) {
        return (String)this.getAttribute(name);
    }

    public static AttributeStore from(CompositeData cd) {
        AttributeStore instance = null;
        if (cd.containsKey("attributes")) {
            Object cn = cd.get("attributes");
            if (cn != null) {
                if (cn instanceof IAttributeStore) {
                    instance = new AttributeStore((IAttributeStore)cn);
                } else if (cn instanceof Map) {
                    instance = new AttributeStore((Map)cn);
                }
            } else {
                instance = new AttributeStore();
            }
        } else {
            instance = new AttributeStore();
        }
        return instance;
    }

    private final class ConcurrentAttributesMap<K, V>
    extends ConcurrentHashMap<K, V> {
        ConcurrentAttributesMap(int size) {
            super(size, 0.75f, 1);
        }

        @Override
        public V get(Object key) {
            if (log.isTraceEnabled()) {
                log.trace("get key: {}", key);
            }
            return super.get(key);
        }

        @Override
        public V put(K key, V value) {
            if (log.isTraceEnabled()) {
                log.trace("put key: {} value: {}", key, value);
            }
            return super.put(key, value);
        }

        @Override
        public V putIfAbsent(K key, V value) {
            if (log.isTraceEnabled()) {
                log.trace("putIfAbsent key: {} value: {}", key, value);
            }
            return super.putIfAbsent(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            if (log.isTraceEnabled()) {
                log.trace("putAll map: {}", m);
            }
            super.putAll(m);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            if (log.isTraceEnabled()) {
                log.trace("replace key: {} old value: {} new value: {}", new Object[]{key, oldValue, newValue});
            }
            return super.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            if (log.isTraceEnabled()) {
                log.trace("replace key: {} value: {}", key, value);
            }
            return super.replace(key, value);
        }
    }
}

