/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.codec;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.red5.server.api.Red5;
import org.red5.server.net.IConnectionManager;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMPProtocolDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPMinaProtocolDecoder
extends ProtocolDecoderAdapter {
    protected static Logger log = LoggerFactory.getLogger(RTMPMinaProtocolDecoder.class);
    private RTMPProtocolDecoder decoder = new RTMPProtocolDecoder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws ProtocolCodecException {
        String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        log.trace("Session id: {}", (Object)sessionId);
        IConnectionManager connManager = (IConnectionManager)((WeakReference)session.getAttribute((Object)"rtmp.connection.manager")).get();
        RTMPConnection conn = (RTMPConnection)connManager.getConnectionBySessionId(sessionId);
        RTMPConnection connLocal = (RTMPConnection)Red5.getConnectionLocal();
        if ((connLocal == null || !conn.getSessionId().equals(connLocal.getSessionId())) && log.isDebugEnabled() && connLocal != null) {
            log.debug("Connection local didn't match session");
        }
        if (conn != null) {
            Red5.setConnectionLocal(conn);
            if (log.isTraceEnabled()) {
                log.trace("Incoming: in.position {}, in.limit {}, in.remaining {}", new Object[]{in.position(), in.limit(), in.remaining()});
            }
            byte[] arr = new byte[in.remaining()];
            in.get(arr);
            IoBuffer buf = (IoBuffer)session.getAttribute((Object)"buffer");
            if (buf == null) {
                buf = IoBuffer.allocate((int)arr.length);
                buf.setAutoExpand(true);
                session.setAttribute((Object)"buffer", (Object)buf);
            }
            buf.put(arr);
            buf.flip();
            if (log.isTraceEnabled()) {
                log.trace("Buffers info before: buf.position {}, buf.limit {}, buf.remaining {}", new Object[]{buf.position(), buf.limit(), buf.remaining()});
            }
            Semaphore lock = conn.getDecoderLock();
            try {
                lock.acquire();
                List<Object> objects = this.decoder.decodeBuffer(conn, buf);
                log.trace("Decoded: {}", objects);
                if (objects != null) {
                    int writeCount = 0;
                    for (Object object : objects) {
                        out.write(object);
                        ++writeCount;
                    }
                    log.trace("Wrote {} objects", (Object)writeCount);
                }
            }
            catch (Exception e) {
                log.error("Error during decode", (Throwable)e);
            }
            finally {
                lock.release();
                Red5.setConnectionLocal(null);
            }
            if (log.isTraceEnabled()) {
                log.trace("Buffers info after: buf.position {}, buf.limit {}, buf.remaining {}", new Object[]{buf.position(), buf.limit(), buf.remaining()});
            }
        } else {
            log.debug("Closing and skipping decode for unregistered connection: {}", (Object)sessionId);
            session.closeNow();
            log.debug("Session closing: {} reading: {} writing: {}", new Object[]{session.isClosing(), session.isReadSuspended(), session.isWriteSuspended()});
        }
    }

    public void setDecoder(RTMPProtocolDecoder decoder) {
        this.decoder = decoder;
    }

    public RTMPProtocolDecoder getDecoder() {
        return this.decoder;
    }
}

