/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.IoConstants;
import org.red5.io.utils.IOUtils;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.SerializeUtils;
import org.red5.server.net.rtmp.event.Unknown;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.stream.IStreamData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aggregate
extends BaseEvent
implements IoConstants,
IStreamData<Aggregate>,
IStreamPacket {
    private static final long serialVersionUID = 5538859593815804830L;
    private static Logger log = LoggerFactory.getLogger(Aggregate.class);
    protected IoBuffer data;
    private byte dataType = (byte)22;

    public Aggregate() {
        this(IoBuffer.allocate((int)0).flip());
    }

    public Aggregate(IoBuffer data) {
        super(IEvent.Type.STREAM_DATA);
        this.setData(data);
    }

    public Aggregate(IoBuffer data, boolean copy) {
        super(IEvent.Type.STREAM_DATA);
        if (copy) {
            byte[] array = new byte[data.remaining()];
            data.mark();
            data.get(array);
            data.reset();
            this.setData(array);
        } else {
            this.setData(data);
        }
    }

    @Override
    public byte getDataType() {
        return this.dataType;
    }

    public void setDataType(byte dataType) {
        this.dataType = dataType;
    }

    @Override
    public IoBuffer getData() {
        return this.data;
    }

    public void setData(IoBuffer data) {
        this.data = data;
    }

    public void setData(byte[] data) {
        this.data = IoBuffer.allocate((int)data.length);
        this.data.put(data).flip();
    }

    public LinkedList<IRTMPEvent> getParts() {
        LinkedList<IRTMPEvent> parts = new LinkedList<IRTMPEvent>();
        log.trace("Aggregate data length: {}", (Object)this.data.limit());
        int position = this.data.position();
        do {
            try {
                byte subType = this.data.get();
                if (subType == 0) {
                    log.debug("Subtype 0 encountered within this aggregate, processing with exit");
                    break;
                }
                int size = IOUtils.readUnsignedMediumInt((IoBuffer)this.data);
                log.debug("Data subtype: {} size: {}", (Object)subType, (Object)size);
                int timestamp = IOUtils.readExtendedMediumInt((IoBuffer)this.data);
                int streamId = IOUtils.readUnsignedMediumInt((IoBuffer)this.data);
                log.debug("Data timestamp: {} stream id: {}", (Object)timestamp, (Object)streamId);
                Header partHeader = new Header();
                partHeader.setChannelId(this.header.getChannelId());
                partHeader.setDataType(subType);
                partHeader.setSize(size);
                partHeader.setStreamId(this.header.getStreamId());
                partHeader.setTimer(timestamp);
                int backPointer = 0;
                switch (subType) {
                    case 8: {
                        AudioData audio = new AudioData(this.data.getSlice(size));
                        audio.setTimestamp(timestamp);
                        audio.setHeader(partHeader);
                        log.debug("Audio header: {}", (Object)audio.getHeader());
                        parts.add(audio);
                        if (this.data.position() >= this.data.limit() - 4 || (backPointer = this.data.getInt()) == size + 11) break;
                        log.debug("Data size ({}) and back pointer ({}) did not match", (Object)size, (Object)backPointer);
                        break;
                    }
                    case 9: {
                        VideoData video = new VideoData(this.data.getSlice(size));
                        video.setTimestamp(timestamp);
                        video.setHeader(partHeader);
                        log.debug("Video header: {}", (Object)video.getHeader());
                        parts.add(video);
                        if (this.data.position() >= this.data.limit() - 4 || (backPointer = this.data.getInt()) == size + 11) break;
                        log.debug("Data size ({}) and back pointer ({}) did not match", (Object)size, (Object)backPointer);
                        break;
                    }
                    default: {
                        log.debug("Non-A/V subtype: {}", (Object)subType);
                        Unknown unk = new Unknown(subType, this.data.getSlice(size));
                        unk.setTimestamp(timestamp);
                        unk.setHeader(partHeader);
                        parts.add(unk);
                        if (this.data.position() >= this.data.limit() - 4) break;
                        backPointer = this.data.getInt();
                    }
                }
                position = this.data.position();
            }
            catch (Exception e) {
                log.error("Exception decoding aggregate parts", (Throwable)e);
                break;
            }
            log.trace("Data position: {}", (Object)position);
        } while (position < this.data.limit());
        log.trace("Aggregate processing complete, {} parts extracted", (Object)parts.size());
        return parts;
    }

    public String toString() {
        return String.format("Aggregate - ts: %s length: %s", this.getTimestamp(), this.data != null ? this.data.limit() : 48);
    }

    @Override
    protected void releaseInternal() {
        if (this.data != null) {
            IoBuffer localData = this.data;
            this.data = null;
            localData.clear();
            localData.free();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte[] byteBuf = (byte[])in.readObject();
        if (byteBuf != null) {
            this.data = IoBuffer.allocate((int)byteBuf.length);
            this.data.setAutoExpand(true);
            SerializeUtils.ByteArrayToByteBuffer(byteBuf, this.data);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.data != null) {
            out.writeObject(SerializeUtils.ByteBufferToByteArray(this.data));
        } else {
            out.writeObject(null);
        }
    }

    public Aggregate duplicate() throws IOException, ClassNotFoundException {
        Aggregate result = new Aggregate();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        this.writeExternal(oos);
        oos.close();
        byte[] buf = baos.toByteArray();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bais);
        result.readExternal(ois);
        ois.close();
        bais.close();
        if (this.header != null) {
            result.setHeader(this.header.clone());
        }
        result.setSourceType(this.sourceType);
        result.setSource(this.source);
        result.setTimestamp(this.timestamp);
        return result;
    }
}

