/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.server.net.protocol.ProtocolException;
import org.red5.server.net.rtmp.message.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkHeader
implements Constants,
Cloneable,
Externalizable {
    protected static final Logger log = LoggerFactory.getLogger(ChunkHeader.class);
    private byte format;
    private byte size;
    private int channelId;

    public byte getFormat() {
        return this.format;
    }

    public void setFormat(byte format) {
        this.format = format;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public byte getSize() {
        return this.size;
    }

    public void setSize(byte size) {
        this.size = size;
    }

    public static ChunkHeader read(IoBuffer in) {
        int remaining = in.remaining();
        if (remaining > 0) {
            byte headerByte = in.get();
            ChunkHeader h = new ChunkHeader();
            h.format = (byte)((0xC0 & headerByte) >> 6);
            int fmt = headerByte & 0x3F;
            switch (fmt) {
                case 0: {
                    h.size = (byte)2;
                    if (remaining < 2) {
                        throw new ProtocolException("Bad chunk header, at least 2 bytes are expected");
                    }
                    h.channelId = 64 + (in.get() & 0xFF);
                    break;
                }
                case 1: {
                    h.size = (byte)3;
                    if (remaining < 3) {
                        throw new ProtocolException("Bad chunk header, at least 3 bytes are expected");
                    }
                    byte b1 = in.get();
                    byte b2 = in.get();
                    h.channelId = 64 + ((b2 & 0xFF) << 8 | b1 & 0xFF);
                    break;
                }
                default: {
                    h.size = 1;
                    h.channelId = 0x3F & headerByte;
                }
            }
            if (h.channelId < 0) {
                throw new ProtocolException("Bad channel id: " + h.channelId);
            }
            log.trace("CHUNK header byte {}, count {}, header {}, channel {}", new Object[]{String.format("%02x", headerByte), h.size, 0, h.channelId});
            return h;
        }
        throw new ProtocolException("Bad chunk header, at least 1 byte is expected");
    }

    public boolean equals(Object other) {
        if (other instanceof ChunkHeader) {
            ChunkHeader header = (ChunkHeader)other;
            return header.getChannelId() == this.channelId && header.getFormat() == this.format;
        }
        return false;
    }

    public ChunkHeader clone() {
        ChunkHeader header = new ChunkHeader();
        header.setChannelId(this.channelId);
        header.setSize(this.size);
        header.setFormat(this.format);
        return header;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.format = in.readByte();
        this.channelId = in.readInt();
        this.size = (byte)(this.channelId > 319 ? 3 : (this.channelId > 63 ? 2 : 1));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.format);
        out.writeInt(this.channelId);
    }

    public String toString() {
        if ((double)(this.channelId + this.format) > 0.0) {
            return "ChunkHeader [type=" + this.format + ", channelId=" + this.channelId + ", size=" + this.size + "]";
        }
        return "empty";
    }
}

