/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.message;

import org.red5.server.so.ISharedObjectEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedObjectTypeMapping {
    protected static Logger log = LoggerFactory.getLogger(SharedObjectTypeMapping.class);
    public static final ISharedObjectEvent.Type[] typeMap = new ISharedObjectEvent.Type[]{null, ISharedObjectEvent.Type.SERVER_CONNECT, ISharedObjectEvent.Type.SERVER_DISCONNECT, ISharedObjectEvent.Type.SERVER_SET_ATTRIBUTE, ISharedObjectEvent.Type.CLIENT_UPDATE_DATA, ISharedObjectEvent.Type.CLIENT_UPDATE_ATTRIBUTE, ISharedObjectEvent.Type.SERVER_SEND_MESSAGE, ISharedObjectEvent.Type.CLIENT_STATUS, ISharedObjectEvent.Type.CLIENT_CLEAR_DATA, ISharedObjectEvent.Type.CLIENT_DELETE_DATA, ISharedObjectEvent.Type.SERVER_DELETE_ATTRIBUTE, ISharedObjectEvent.Type.CLIENT_INITIAL_DATA};

    public static ISharedObjectEvent.Type toType(byte rtmpType) {
        return typeMap[rtmpType];
    }

    public static byte toByte(ISharedObjectEvent.Type type) {
        switch (type) {
            case SERVER_CONNECT: {
                return 1;
            }
            case SERVER_DISCONNECT: {
                return 2;
            }
            case SERVER_SET_ATTRIBUTE: {
                return 3;
            }
            case CLIENT_UPDATE_DATA: {
                return 4;
            }
            case CLIENT_UPDATE_ATTRIBUTE: {
                return 5;
            }
            case SERVER_SEND_MESSAGE: {
                return 6;
            }
            case CLIENT_SEND_MESSAGE: {
                return 6;
            }
            case CLIENT_STATUS: {
                return 7;
            }
            case CLIENT_CLEAR_DATA: {
                return 8;
            }
            case CLIENT_DELETE_DATA: {
                return 9;
            }
            case SERVER_DELETE_ATTRIBUTE: {
                return 10;
            }
            case CLIENT_INITIAL_DATA: {
                return 11;
            }
        }
        log.error("Unknown type " + (Object)((Object)type));
        return 0;
    }

    public static String toString(ISharedObjectEvent.Type type) {
        switch (type) {
            case SERVER_CONNECT: {
                return "server connect";
            }
            case SERVER_DISCONNECT: {
                return "server disconnect";
            }
            case SERVER_SET_ATTRIBUTE: {
                return "server_set_attribute";
            }
            case CLIENT_UPDATE_DATA: {
                return "client_update_data";
            }
            case CLIENT_UPDATE_ATTRIBUTE: {
                return "client_update_attribute";
            }
            case SERVER_SEND_MESSAGE: {
                return "server_send_message";
            }
            case CLIENT_SEND_MESSAGE: {
                return "client_send_message";
            }
            case CLIENT_STATUS: {
                return "client_status";
            }
            case CLIENT_CLEAR_DATA: {
                return "client_clear_data";
            }
            case CLIENT_DELETE_DATA: {
                return "client_delete_data";
            }
            case SERVER_DELETE_ATTRIBUTE: {
                return "server_delete_attribute";
            }
            case CLIENT_INITIAL_DATA: {
                return "client_initial_data";
            }
        }
        log.error("Unknown type " + (Object)((Object)type));
        return "unknown";
    }
}

