/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.scheduling;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.jmx.mxbeans.QuartzSchedulingServiceMXBean;
import org.red5.server.scheduling.QuartzSchedulingServiceJob;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SimpleTriggerFactoryBean;

@ManagedResource(objectName="org.red5.server:name=schedulingService,type=QuartzSchedulingService")
public class QuartzSchedulingService
implements ISchedulingService,
QuartzSchedulingServiceMXBean,
InitializingBean,
DisposableBean {
    private static Logger log = Red5LoggerFactory.getLogger(QuartzSchedulingService.class);
    protected String configFile;
    protected AtomicLong jobDetailCounter = new AtomicLong(0L);
    protected SchedulerFactory factory;
    protected JobDetailFactoryBean jobDetailfactory;
    protected SimpleTriggerFactoryBean triggerfactory;
    protected Scheduler scheduler;
    protected String instanceId;
    protected String threadCount = "10";
    protected ConcurrentMap<String, ScheduledJobKey> keyMap = new ConcurrentHashMap<String, ScheduledJobKey>();

    public void afterPropertiesSet() throws Exception {
        log.debug("Initializing...");
        try {
            if (this.factory == null) {
                if (this.configFile != null) {
                    this.factory = new StdSchedulerFactory(this.configFile);
                } else {
                    Properties props = new Properties();
                    props.put("org.quartz.scheduler.instanceName", "Red5_Scheduler");
                    props.put("org.quartz.scheduler.instanceId", "AUTO");
                    props.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
                    props.put("org.quartz.threadPool.threadCount", this.threadCount);
                    props.put("org.quartz.threadPool.threadPriority", "5");
                    props.put("org.quartz.jobStore.misfireThreshold", "60000");
                    props.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
                    this.factory = new StdSchedulerFactory(props);
                }
            }
            this.scheduler = this.instanceId == null ? this.factory.getScheduler() : this.factory.getScheduler(this.instanceId);
            if (this.scheduler != null) {
                this.scheduler.start();
            } else {
                log.error("Scheduler was not started");
            }
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setFactory(SchedulerFactory factory) {
        this.factory = factory;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(String threadCount) {
        this.threadCount = threadCount;
    }

    @Override
    public String addScheduledJob(int interval, IScheduledJob job) {
        String name = this.getJobName();
        JobDataMap jobData = new JobDataMap();
        jobData.put("scheduling_service", (Object)this);
        jobData.put("scheduled_job", (Object)job);
        JobDetail jobDetail = JobBuilder.newJob(QuartzSchedulingServiceJob.class).withIdentity(name).usingJobData(jobData).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(String.format("Trigger_%s", name)).startAt(DateBuilder.futureDate((int)1, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MILLISECOND)).forJob(jobDetail).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)interval).repeatForever()).build();
        TriggerKey tKey = trigger.getKey();
        JobKey jKey = trigger.getJobKey();
        log.debug("Job key: {} Trigger key: {}", (Object)jKey, (Object)tKey);
        ScheduledJobKey key = new ScheduledJobKey(tKey, jKey);
        this.keyMap.put(name, key);
        this.scheduleJob(trigger, jobDetail);
        return name;
    }

    @Override
    public String addScheduledOnceJob(Date date, IScheduledJob job) {
        String name = this.getJobName();
        JobDataMap jobData = new JobDataMap();
        jobData.put("scheduling_service", (Object)this);
        jobData.put("scheduled_job", (Object)job);
        JobDetail jobDetail = JobBuilder.newJob(QuartzSchedulingServiceJob.class).withIdentity(name).usingJobData(jobData).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(String.format("Trigger_%s", name)).startAt(date).forJob(jobDetail).build();
        log.debug("Job key: {} Trigger key: {}", (Object)trigger.getJobKey(), (Object)trigger.getKey());
        TriggerKey tKey = trigger.getKey();
        JobKey jKey = trigger.getJobKey();
        log.debug("Job key: {} Trigger key: {}", (Object)jKey, (Object)tKey);
        ScheduledJobKey key = new ScheduledJobKey(tKey, jKey);
        this.keyMap.put(name, key);
        this.scheduleJob(trigger, jobDetail);
        return name;
    }

    @Override
    public String addScheduledOnceJob(long timeDelta, IScheduledJob job) {
        return this.addScheduledOnceJob(new Date(System.currentTimeMillis() + timeDelta), job);
    }

    @Override
    public String addScheduledJobAfterDelay(int interval, IScheduledJob job, int delay) {
        String name = this.getJobName();
        JobDataMap jobData = new JobDataMap();
        jobData.put("scheduling_service", (Object)this);
        jobData.put("scheduled_job", (Object)job);
        JobDetail jobDetail = JobBuilder.newJob(QuartzSchedulingServiceJob.class).withIdentity(name, null).usingJobData(jobData).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(String.format("Trigger_%s", name)).startAt(DateBuilder.futureDate((int)delay, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MILLISECOND)).forJob(jobDetail).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)interval).repeatForever()).build();
        TriggerKey tKey = trigger.getKey();
        JobKey jKey = trigger.getJobKey();
        log.debug("Job key: {} Trigger key: {}", (Object)jKey, (Object)tKey);
        ScheduledJobKey key = new ScheduledJobKey(tKey, jKey);
        this.keyMap.put(name, key);
        this.scheduleJob(trigger, jobDetail);
        return name;
    }

    @Override
    public String getJobName() {
        return String.format("ScheduledJob_%d", this.jobDetailCounter.getAndIncrement());
    }

    @Override
    public List<String> getScheduledJobNames() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.scheduler != null) {
            try {
                for (JobKey jobKey : this.scheduler.getJobKeys(null)) {
                    result.add(jobKey.getName());
                }
            }
            catch (SchedulerException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            log.warn("No scheduler is available");
        }
        return result;
    }

    @Override
    public void pauseScheduledJob(String name) {
        try {
            this.scheduler.pauseJob(((ScheduledJobKey)this.keyMap.get((Object)name)).jKey);
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void resumeScheduledJob(String name) {
        try {
            this.scheduler.resumeJob(((ScheduledJobKey)this.keyMap.get((Object)name)).jKey);
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void pauseScheduledTrigger(String name) {
        try {
            this.scheduler.pauseTrigger(((ScheduledJobKey)this.keyMap.get((Object)name)).tKey);
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void resumeScheduledTrigger(String name) {
        try {
            this.scheduler.resumeTrigger(((ScheduledJobKey)this.keyMap.get((Object)name)).tKey);
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void removeScheduledJob(String name) {
        try {
            ScheduledJobKey key = (ScheduledJobKey)this.keyMap.remove(name);
            if (key != null) {
                this.scheduler.deleteJob(key.jKey);
            } else {
                log.debug("No key found for job: {}", (Object)name);
            }
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void scheduleJob(Trigger trigger, JobDetail jobDetail) {
        if (this.scheduler != null) {
            try {
                this.scheduler.scheduleJob(jobDetail, trigger);
            }
            catch (SchedulerException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            log.warn("No scheduler is available");
        }
    }

    public void destroy() throws Exception {
        if (this.scheduler != null) {
            log.debug("Destroying...");
            this.scheduler.shutdown(false);
        }
        this.keyMap.clear();
    }

    protected final class ScheduledJobKey {
        TriggerKey tKey;
        JobKey jKey;

        public ScheduledJobKey(TriggerKey tKey, JobKey jKey) {
            this.tKey = tKey;
            this.jKey = jKey;
        }
    }
}

