/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.beans.ConstructorProperties;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.openmbean.CompositeData;
import org.red5.server.AttributeStore;
import org.red5.server.ClientRegistry;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IScope;
import org.red5.server.stream.bandwidth.ClientServerDetection;
import org.red5.server.stream.bandwidth.ServerClientDetection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
extends AttributeStore
implements IClient {
    protected static Logger log = LoggerFactory.getLogger(Client.class);
    protected static final String PERMISSIONS = "_transient_red5_permissions";
    protected transient WeakReference<ClientRegistry> registry;
    protected transient CopyOnWriteArraySet<IConnection> connections = new CopyOnWriteArraySet();
    protected final long creationTime;
    protected final String id;
    protected boolean bandwidthChecked;
    protected AtomicBoolean disconnected = new AtomicBoolean(false);

    @ConstructorProperties(value={"id", "registry"})
    public Client(String id, ClientRegistry registry) {
        this.id = id != null ? id : registry.nextId();
        this.creationTime = System.currentTimeMillis();
        this.registry = new WeakReference<ClientRegistry>(registry);
    }

    @ConstructorProperties(value={"id", "creationTime", "registry"})
    public Client(String id, Long creationTime, ClientRegistry registry) {
        this.id = id != null ? id : registry.nextId();
        this.creationTime = creationTime != null ? creationTime : System.currentTimeMillis();
        this.registry = new WeakReference<ClientRegistry>(registry);
    }

    @Override
    public void disconnect() {
        if (this.disconnected.compareAndSet(false, true)) {
            log.debug("Disconnect - id: {}", (Object)this.id);
            if (this.connections != null && !this.connections.isEmpty()) {
                log.debug("Closing {} scope connections", (Object)this.connections.size());
                for (IConnection con : this.getConnections()) {
                    try {
                        con.close();
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception closing connection {}", (Throwable)e);
                    }
                }
            } else {
                log.debug("Connection map is empty or null");
            }
            this.removeInstance();
        }
    }

    @Override
    public Set<IConnection> getConnections() {
        return Collections.unmodifiableSet(this.connections);
    }

    @Override
    public Set<IConnection> getConnections(IScope scope) {
        if (scope == null) {
            return this.getConnections();
        }
        Set<IClient> scopeClients = scope.getClients();
        if (scopeClients.contains(this)) {
            for (IClient cli : scopeClients) {
                if (!this.equals(cli)) continue;
                return cli.getConnections();
            }
        }
        return Collections.emptySet();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Collection<IScope> getScopes() {
        HashSet<IScope> scopes = new HashSet<IScope>();
        for (IConnection conn : this.connections) {
            scopes.add(conn.getScope());
        }
        return scopes;
    }

    public List<String> iterateScopeNameList() {
        log.debug("iterateScopeNameList called");
        Collection<IScope> scopes = this.getScopes();
        log.debug("Scopes: {}", (Object)scopes.size());
        ArrayList<String> scopeNames = new ArrayList<String>(scopes.size());
        for (IScope scope : scopes) {
            log.debug("Client scope: {}", (Object)scope);
            scopeNames.add(scope.getName());
            if (!log.isDebugEnabled()) continue;
            for (Map.Entry<String, Object> entry : scope.getAttributes().entrySet()) {
                log.debug("Client scope attr: {} = {}", (Object)entry.getKey(), entry.getValue());
            }
        }
        return scopeNames;
    }

    public boolean isRegistered(IConnection conn) {
        return this.connections.contains(conn);
    }

    protected void register(IConnection conn) {
        if (log.isDebugEnabled()) {
            if (conn == null) {
                log.debug("Register null connection, client id: {}", (Object)this.id);
            } else {
                log.debug("Register connection ({}:{}) client id: {}", new Object[]{conn.getRemoteAddress(), conn.getRemotePort(), this.id});
            }
        }
        if (conn != null) {
            IScope scope = conn.getScope();
            if (scope != null) {
                log.debug("Registering for scope: {}", (Object)scope);
                this.connections.add(conn);
            } else {
                log.warn("Clients scope is null. Id: {}", (Object)this.id);
            }
        } else {
            log.warn("Clients connection is null. Id: {}", (Object)this.id);
        }
    }

    protected void unregister(IConnection conn) {
        this.unregister(conn, true);
    }

    protected void unregister(IConnection conn, boolean deleteIfNoConns) {
        log.debug("Unregister connection ({}:{}) client id: {}", new Object[]{conn.getRemoteAddress(), conn.getRemotePort(), this.id});
        this.connections.remove(conn);
        if (deleteIfNoConns && this.connections.isEmpty()) {
            this.removeInstance();
        }
    }

    @Override
    public boolean isBandwidthChecked() {
        return this.bandwidthChecked;
    }

    @Override
    public Collection<String> getPermissions(IConnection conn) {
        Set<String> result = (Set<String>)conn.getAttribute(PERMISSIONS);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    @Override
    public boolean hasPermission(IConnection conn, String permissionName) {
        Collection<String> permissions = this.getPermissions(conn);
        return permissions.contains(permissionName);
    }

    @Override
    public void setPermissions(IConnection conn, Collection<String> permissions) {
        if (permissions == null) {
            conn.removeAttribute(PERMISSIONS);
        } else {
            conn.setAttribute(PERMISSIONS, permissions);
        }
    }

    @Override
    public void checkBandwidth() {
        log.debug("Check bandwidth");
        this.bandwidthChecked = true;
        ServerClientDetection detection = new ServerClientDetection();
        detection.checkBandwidth(Red5.getConnectionLocal());
    }

    @Override
    public Map<String, Object> checkBandwidthUp(Object[] params) {
        if (log.isDebugEnabled()) {
            log.debug("Check bandwidth: {}", (Object)Arrays.toString(params));
        }
        this.bandwidthChecked = true;
        ClientServerDetection detection = new ClientServerDetection();
        return detection.checkBandwidth(params);
    }

    public static Client from(CompositeData cd) {
        AttributeStore instance = null;
        if (cd.containsKey("id")) {
            String id = (String)cd.get("id");
            instance = new Client(id, (Long)cd.get("creationTime"), null);
            instance.setAttribute(PERMISSIONS, cd.get(PERMISSIONS));
        }
        if (cd.containsKey("attributes")) {
            AttributeStore attrs = (AttributeStore)cd.get("attributes");
            instance.setAttributes(attrs);
        }
        return instance;
    }

    private void removeInstance() {
        ClientRegistry ref = (ClientRegistry)this.registry.get();
        if (ref != null) {
            ref.removeClient(this);
        } else {
            log.warn("Client registry reference was not accessable, removal failed");
        }
    }

    public int hashCode() {
        if (this.id == null) {
            return -1;
        }
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Client) {
            return ((Client)obj).getId().equals(this.id);
        }
        return false;
    }

    public String toString() {
        return "Client: " + this.id;
    }
}

