/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.mina.core.buffer.IoBuffer;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.BigIntegers;
import org.red5.server.net.IHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RTMPHandshake
implements IHandshake {
    protected Logger log = LoggerFactory.getLogger(RTMPHandshake.class);
    public static final String[] HANDSHAKE_TYPES = new String[]{"Undefined0", "Undefined1", "Undefined2", "RTMP", "Undefined4", "Undefined5", "RTMPE", "Undefined7", "RTMPE XTEA", "RTMPE BLOWFISH"};
    public static final byte[] GENUINE_FMS_KEY = new byte[]{71, 101, 110, 117, 105, 110, 101, 32, 65, 100, 111, 98, 101, 32, 70, 108, 97, 115, 104, 32, 77, 101, 100, 105, 97, 32, 83, 101, 114, 118, 101, 114, 32, 48, 48, 49, -16, -18, -62, 74, -128, 104, -66, -24, 46, 0, -48, -47, 2, -98, 126, 87, 110, -20, 93, 45, 41, -128, 111, -85, -109, -72, -26, 54, -49, -21, 49, -82};
    public static final byte[] GENUINE_FP_KEY = new byte[]{71, 101, 110, 117, 105, 110, 101, 32, 65, 100, 111, 98, 101, 32, 70, 108, 97, 115, 104, 32, 80, 108, 97, 121, 101, 114, 32, 48, 48, 49, -16, -18, -62, 74, -128, 104, -66, -24, 46, 0, -48, -47, 2, -98, 126, 87, 110, -20, 93, 45, 41, -128, 111, -85, -109, -72, -26, 54, -49, -21, 49, -82};
    protected static final byte[] DH_MODULUS_BYTES = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47, 41, 2, 78, 8, -118, 103, -52, 116, 2, 11, -66, -90, 59, 19, -101, 34, 81, 74, 8, 121, -114, 52, 4, -35, -17, -107, 25, -77, -51, 58, 67, 27, 48, 43, 10, 109, -14, 95, 20, 55, 79, -31, 53, 109, 109, 81, -62, 69, -28, -123, -75, 118, 98, 94, 126, -58, -12, 76, 66, -23, -90, 55, -19, 107, 11, -1, 92, -74, -12, 6, -73, -19, -18, 56, 107, -5, 90, -119, -97, -91, -82, -97, 36, 17, 124, 75, 31, -26, 73, 40, 102, 81, -20, -26, 83, -127, -1, -1, -1, -1, -1, -1, -1, -1};
    protected static final int[][] XTEA_KEYS = new int[][]{{-1074776910, 299436063, -857753707, 1955456818}, {141188790, 390269198, 1861245624, -27641374}, {2064684399, 1993213217, 596158266, 1140935073}, {-1455164649, -336520270, -1500404242, 401826617}, {2050023434, -1255546324, -1601720667, -1060406868}, {-1110569949, 803987199, 486190614, 287515549}, {1440563067, 2011686446, -1682389863, -918020380}, {1081849524, 1911066934, -1481719979, -902580167}, {-50938429, -1237567849, 2095380517, 81353138}, {685806077, 1100303436, 2142755584, -476027144}, {1468291958, 1327831811, 1188322253, -1564275415}, {181202680, -631917242, 54998098, 1482912059}, {-1205832228, -1486938130, -666736408, -1490402100}, {131034782, -1586660571, -1616400788, -651209175}, {-21894428, -1936966431, 1308648615, 1782086698}, {-1992649689, -869264478, -251250597, -1473644249}};
    protected static final byte[][] BLOWFISH_KEYS = new byte[][]{{121, 52, 119, 76, 103, -47, 56, 58, -33, -77, 86, -66, -117, 123, -48, 36, 56, -32, 115, 88, 65, 93, 105, 103}, {70, -10, -76, -52, 1, -109, -29, -95, -98, 125, 60, 101, 85, -122, -3, 9, -113, -9, -77, -60, 111, 65, -54, 92}, {26, -25, -30, -13, -7, 20, 121, -108, -64, -45, -105, 67, 8, 123, -77, -124, 67, 47, -99, -124, 63, 33, 1, -101}, {-45, -29, 84, -80, -9, 29, -10, 43, 90, 67, 77, 4, -125, 100, 62, 13, 89, 47, 97, -53, -79, 106, 89, 13}, {-56, -63, -23, -72, 22, 86, -103, 33, 123, 91, 54, -73, -75, -101, -33, 6, 73, 44, -105, -11, -107, 72, -123, 126}, {-21, -27, -26, 46, -92, -70, -44, 44, -14, 22, -32, -113, 102, 35, -87, 67, 65, -50, 56, 20, -124, -107, 0, 83}, {102, -37, -112, -16, 59, 79, -11, 111, -28, -100, 32, -119, 53, 94, -46, -78, -61, -98, -97, 127, 99, -78, 40, -127}, {-69, 32, -84, -19, 42, 4, 106, 25, -108, -104, -101, -56, -1, -51, -109, -17, -58, 13, 86, -89, -21, 19, -39, 48}, {-68, -14, 67, -126, 9, 64, -118, -121, 37, 67, 109, -26, -69, -92, -71, 68, 88, 63, 33, 124, -103, -69, 63, 36}, {-20, 26, -86, -51, -50, -67, 83, 17, -46, -5, -125, -74, -61, -70, -85, 79, 98, 121, -24, 101, -87, -110, 40, 118}, {-58, 12, 48, 3, -111, 24, 45, 123, 121, -38, -31, -43, 100, 119, -102, 18, -59, -79, -41, -111, 79, -106, 76, -93}, {-41, 124, 42, -65, -90, -25, -123, 124, 69, -83, -1, 18, -108, -40, -34, -92, 92, 61, 121, -92, 68, 2, 93, 34}, {22, 25, 13, -127, 106, 76, -57, -8, -72, -7, 78, -51, 44, -98, -112, -124, -78, 8, 37, 96, -31, 30, -82, 24}, {-23, 124, 88, 38, 27, 81, -98, 73, -126, 96, 97, -4, -96, -96, 27, -51, -11, 5, -42, -90, 109, 7, -120, -93}, {43, -105, 17, -117, -39, 78, -39, -33, 32, -29, -100, 16, -26, -95, 53, 33, 17, -7, 19, 13, 11, 36, 101, -78}, {83, 106, 76, 84, -84, -117, -101, -72, -105, 41, -4, 96, 44, 91, 58, -123, 104, -75, -86, 106, 68, -51, 63, -89}};
    protected static final BigInteger DH_MODULUS = new BigInteger(1, DH_MODULUS_BYTES);
    protected static final BigInteger DH_BASE = BigInteger.valueOf(2L);
    protected static final int DIGEST_LENGTH = 32;
    protected static final int KEY_LENGTH = 128;
    protected static final Random random = new Random();
    protected KeyAgreement keyAgreement;
    protected Cipher cipherOut;
    protected Cipher cipherIn;
    protected byte handshakeType;
    protected byte[] handshakeBytes;
    protected byte[] incomingPublicKey;
    protected byte[] outgoingPublicKey;
    protected int swfSize;
    protected byte[] swfVerificationBytes;
    protected int algorithm = 1;
    protected boolean fp9Handshake = true;
    protected IoBuffer buffer;

    public RTMPHandshake() {
        this(0);
    }

    public RTMPHandshake(byte handshakeType) {
        this.setHandshakeType(handshakeType);
        this.fp9Handshake = "true".equals(System.getProperty("use.fp9.handshake", "true"));
        this.createHandshakeBytes();
        this.buffer = IoBuffer.allocate((int)1536);
        this.buffer.setAutoExpand(true);
    }

    protected void initRC4Encryption(byte[] sharedSecret) {
        this.log.debug("Shared secret: {}", (Object)Hex.encodeHexString((byte[])sharedSecret));
        this.log.debug("Outgoing public key [{}]: {}", (Object)this.outgoingPublicKey.length, (Object)Hex.encodeHexString((byte[])this.outgoingPublicKey));
        byte[] rc4keyOut = new byte[32];
        this.calculateHMAC_SHA256(this.outgoingPublicKey, 0, this.outgoingPublicKey.length, sharedSecret, 128, rc4keyOut, 0);
        this.log.debug("RC4 Out Key: {}", (Object)Hex.encodeHexString((byte[])Arrays.copyOfRange(rc4keyOut, 0, 16)));
        try {
            this.cipherOut = Cipher.getInstance("RC4");
            this.cipherOut.init(1, new SecretKeySpec(rc4keyOut, 0, 16, "RC4"));
        }
        catch (Exception e) {
            this.log.warn("Encryption cipher creation failed", (Throwable)e);
        }
        this.log.debug("Incoming public key [{}]: {}", (Object)this.incomingPublicKey.length, (Object)Hex.encodeHexString((byte[])this.incomingPublicKey));
        byte[] rc4keyIn = new byte[32];
        this.calculateHMAC_SHA256(this.incomingPublicKey, 0, this.incomingPublicKey.length, sharedSecret, 128, rc4keyIn, 0);
        this.log.debug("RC4 In Key: {}", (Object)Hex.encodeHexString((byte[])Arrays.copyOfRange(rc4keyIn, 0, 16)));
        try {
            this.cipherIn = Cipher.getInstance("RC4");
            this.cipherIn.init(2, new SecretKeySpec(rc4keyIn, 0, 16, "RC4"));
        }
        catch (Exception e) {
            this.log.warn("Decryption cipher creation failed", (Throwable)e);
        }
    }

    protected KeyPair generateKeyPair() {
        KeyPair keyPair = null;
        DHParameterSpec keySpec = new DHParameterSpec(DH_MODULUS, DH_BASE);
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DH");
            keyGen.initialize(keySpec);
            keyPair = keyGen.generateKeyPair();
            this.keyAgreement = KeyAgreement.getInstance("DH");
            this.keyAgreement.init(keyPair.getPrivate());
        }
        catch (Exception e) {
            this.log.error("Error generating keypair", (Throwable)e);
        }
        return keyPair;
    }

    protected byte[] getPublicKey(KeyPair keyPair) {
        DHPublicKey incomingPublicKey = (DHPublicKey)keyPair.getPublic();
        BigInteger dhY = incomingPublicKey.getY();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Public key: {}", (Object)Hex.encodeHexString((byte[])BigIntegers.asUnsignedByteArray((BigInteger)dhY)));
        }
        return Arrays.copyOfRange(BigIntegers.asUnsignedByteArray((BigInteger)dhY), 0, 128);
    }

    protected byte[] getSharedSecret(byte[] publicKeyBytes, KeyAgreement agreement) {
        BigInteger otherPublicKeyInt = new BigInteger(1, publicKeyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DH");
            DHPublicKeySpec otherPublicKeySpec = new DHPublicKeySpec(otherPublicKeyInt, DH_MODULUS, DH_BASE);
            PublicKey otherPublicKey = keyFactory.generatePublic(otherPublicKeySpec);
            agreement.doPhase(otherPublicKey, true);
        }
        catch (Exception e) {
            this.log.error("Exception getting the shared secret", (Throwable)e);
        }
        byte[] sharedSecret = agreement.generateSecret();
        this.log.debug("Shared secret [{}]: {}", (Object)sharedSecret.length, (Object)Hex.encodeHexString((byte[])sharedSecret));
        return sharedSecret;
    }

    protected abstract void createHandshakeBytes();

    @Override
    public abstract boolean validate(byte[] var1);

    public void calculateDigest(int digestPos, byte[] handshakeMessage, int handshakeOffset, byte[] key, int keyLen, byte[] digest, int digestOffset) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("calculateDigest - digestPos: {} handshakeOffset: {} keyLen: {} digestOffset: {}", new Object[]{digestPos, handshakeOffset, keyLen, digestOffset});
        }
        int messageLen = 1504;
        byte[] message = new byte[messageLen];
        System.arraycopy(handshakeMessage, handshakeOffset, message, 0, digestPos);
        System.arraycopy(handshakeMessage, handshakeOffset + digestPos + 32, message, digestPos, messageLen - digestPos);
        this.calculateHMAC_SHA256(message, 0, messageLen, key, keyLen, digest, digestOffset);
    }

    public boolean verifyDigest(int digestPos, byte[] handshakeMessage, byte[] key, int keyLen) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("verifyDigest - digestPos: {} keyLen: {} handshake size: {} ", new Object[]{digestPos, keyLen, handshakeMessage.length});
        }
        byte[] calcDigest = new byte[32];
        this.calculateDigest(digestPos, handshakeMessage, 0, key, keyLen, calcDigest, 0);
        return Arrays.equals(Arrays.copyOfRange(handshakeMessage, digestPos, digestPos + 32), calcDigest);
    }

    public void calculateHMAC_SHA256(byte[] message, int messageOffset, int messageLen, byte[] key, int keyLen, byte[] digest, int digestOffset) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("calculateHMAC_SHA256 - messageOffset: {} messageLen: {}", (Object)messageOffset, (Object)messageLen);
            this.log.trace("calculateHMAC_SHA256 - message: {}", (Object)Hex.encodeHexString((byte[])Arrays.copyOfRange(message, messageOffset, messageOffset + messageLen)));
            this.log.trace("calculateHMAC_SHA256 - keyLen: {} key: {}", (Object)keyLen, (Object)Hex.encodeHexString((byte[])Arrays.copyOf(key, keyLen)));
        }
        try {
            Mac hmac = Mac.getInstance("Hmac-SHA256", "BC");
            hmac.init(new SecretKeySpec(Arrays.copyOf(key, keyLen), "HmacSHA256"));
            byte[] actualMessage = Arrays.copyOfRange(message, messageOffset, messageOffset + messageLen);
            byte[] calcDigest = hmac.doFinal(actualMessage);
            System.arraycopy(calcDigest, 0, digest, digestOffset, 32);
        }
        catch (InvalidKeyException e) {
            this.log.error("Invalid key", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("Hash calculation failed", (Throwable)e);
        }
    }

    public void calculateSwfVerification(byte[] handshakeMessage, byte[] swfHash, int swfSize) {
        byte[] swfHashKey = new byte[32];
        System.arraycopy(handshakeMessage, 1504, swfHashKey, 0, 32);
        byte[] bytesFromServerHash = new byte[32];
        this.calculateHMAC_SHA256(swfHash, 0, swfHash.length, swfHashKey, 32, bytesFromServerHash, 0);
        ByteBuffer swfv = ByteBuffer.allocate(42);
        swfv.put((byte)1);
        swfv.put((byte)1);
        swfv.putInt(swfSize);
        swfv.putInt(swfSize);
        swfv.put(bytesFromServerHash);
        swfv.flip();
        this.swfVerificationBytes = new byte[42];
        swfv.get(this.swfVerificationBytes);
        this.log.debug("initialized swf verification response from swfSize: {} swfHash:\n{}\n{}", new Object[]{swfSize, Hex.encodeHexString((byte[])swfHash), Hex.encodeHexString((byte[])this.swfVerificationBytes)});
    }

    public int getDHOffset(int algorithm, byte[] handshake, int bufferOffset) {
        switch (algorithm) {
            case 1: {
                return this.getDHOffset2(handshake, bufferOffset);
            }
        }
        return this.getDHOffset1(handshake, bufferOffset);
    }

    protected int getDHOffset1(byte[] handshake, int bufferOffset) {
        int res;
        int offset = handshake[bufferOffset += 1532] & 0xFF;
        offset += handshake[++bufferOffset] & 0xFF;
        offset += handshake[++bufferOffset] & 0xFF;
        if ((res = (offset += handshake[++bufferOffset] & 0xFF) % 632 + 772) + 128 > 1531) {
            this.log.error("Invalid DH offset");
        }
        return res;
    }

    protected int getDHOffset2(byte[] handshake, int bufferOffset) {
        int res;
        int offset = handshake[bufferOffset += 768] & 0xFF;
        offset += handshake[++bufferOffset] & 0xFF;
        offset += handshake[++bufferOffset] & 0xFF;
        if ((res = (offset += handshake[++bufferOffset] & 0xFF) % 632 + 8) + 128 > 767) {
            this.log.error("Invalid DH offset");
        }
        return res;
    }

    public int getDigestOffset(int algorithm, byte[] handshake, int bufferOffset) {
        switch (algorithm) {
            case 1: {
                return this.getDigestOffset2(handshake, bufferOffset);
            }
        }
        return this.getDigestOffset1(handshake, bufferOffset);
    }

    protected int getDigestOffset1(byte[] handshake, int bufferOffset) {
        int res;
        int offset = handshake[bufferOffset += 8] & 0xFF;
        offset += handshake[++bufferOffset] & 0xFF;
        offset += handshake[++bufferOffset] & 0xFF;
        if ((res = (offset += handshake[++bufferOffset] & 0xFF) % 728 + 12) + 32 > 771) {
            this.log.error("Invalid digest offset calc: {}", (Object)res);
        }
        return res;
    }

    protected int getDigestOffset2(byte[] handshake, int bufferOffset) {
        int res;
        int offset = handshake[bufferOffset += 772] & 0xFF;
        offset += handshake[++bufferOffset] & 0xFF;
        offset += handshake[++bufferOffset] & 0xFF;
        if ((res = Math.abs((offset += handshake[++bufferOffset] & 0xFF) % 728 + 776)) + 32 > 1535) {
            this.log.error("Invalid digest offset calc: {}", (Object)res);
        }
        return res;
    }

    public static final void getXteaSignature(byte[] array, int offset, int keyid) {
        int num_rounds = 32;
        int sum = 0;
        int delta = -1640531527;
        int[] k = XTEA_KEYS[keyid];
        int v0 = ByteBuffer.wrap(array, offset, 4).getInt();
        int v1 = ByteBuffer.wrap(array, offset + 4, 4).getInt();
        for (int i = 0; i < num_rounds; ++i) {
            v1 += ((v0 += (v1 << 4 ^ v1 >> 5) + v1 ^ sum + k[sum & 3]) << 4 ^ v0 >> 5) + v0 ^ (sum += delta) + k[sum >> 11 & 3];
        }
        ByteBuffer tmp = ByteBuffer.allocate(4);
        tmp.putInt(v0);
        tmp.flip();
        System.arraycopy(tmp.array(), 0, array, offset, 4);
        tmp.clear();
        tmp.putInt(v1);
        tmp.flip();
        System.arraycopy(tmp.array(), 0, array, offset + 4, 4);
    }

    public static final void getBlowfishSignature(byte[] array, int offset, int keyid) {
        BlowfishEngine bf = new BlowfishEngine();
        bf.init(true, (CipherParameters)new KeyParameter(BLOWFISH_KEYS[keyid]));
        byte[] output = new byte[8];
        bf.processBlock(array, offset, output, 0);
        System.arraycopy(output, 0, array, offset, 8);
    }

    public static final boolean validHandshakeType(byte handshakeType) {
        switch (handshakeType) {
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean useEncryption() {
        switch (this.handshakeType) {
            case 6: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void setHandshakeType(byte handshakeType) {
        if (this.log.isTraceEnabled()) {
            if (handshakeType < HANDSHAKE_TYPES.length) {
                this.log.trace("Setting handshake type: {}", (Object)HANDSHAKE_TYPES[handshakeType]);
            } else {
                this.log.trace("Invalid handshake type: {}", (Object)handshakeType);
            }
        }
        this.handshakeType = handshakeType;
    }

    public byte getHandshakeType() {
        return this.handshakeType;
    }

    public Cipher getCipherOut() {
        return this.cipherOut;
    }

    public Cipher getCipherIn() {
        return this.cipherIn;
    }

    public byte[] getSwfVerificationBytes() {
        return this.swfVerificationBytes;
    }

    public int getBufferSize() {
        return this.buffer.limit() - this.buffer.remaining();
    }

    public void addBuffer(byte[] in) {
        this.buffer.put(in);
    }

    public void addBuffer(IoBuffer in) {
        byte[] tmp = new byte[in.remaining()];
        in.get(tmp);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addBuffer - pos: {} limit: {} remain: {}", new Object[]{this.buffer.position(), this.buffer.limit(), this.buffer.remaining()});
        }
        if (this.buffer.remaining() == 0) {
            this.buffer.clear();
        }
        this.buffer.put(tmp);
    }

    public IoBuffer getBufferAsIoBuffer() {
        return this.buffer.flip();
    }

    public byte[] getBuffer() {
        this.buffer.flip();
        byte[] tmp = new byte[this.buffer.remaining()];
        this.buffer.get(tmp);
        this.buffer.clear();
        return tmp;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

