/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.red5.server.Server;
import org.red5.server.api.plugin.IRed5Plugin;
import org.red5.server.plugin.PluginRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class PluginLauncher
implements ApplicationContextAware,
InitializingBean {
    protected static Logger log = LoggerFactory.getLogger(PluginLauncher.class);
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        ApplicationContext common = (ApplicationContext)this.applicationContext.getBean("red5.common");
        Server server = (Server)common.getBean("red5.server");
        File pluginsDir = new File(System.getProperty("red5.root"), "plugins");
        File[] plugins = pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String tmp = name.toLowerCase();
                return tmp.endsWith(".jar") || tmp.endsWith(".zip");
            }
        });
        if (plugins != null) {
            IRed5Plugin red5Plugin = null;
            log.debug("{} plugins to launch", (Object)plugins.length);
            for (File plugin : plugins) {
                Class<?> pluginClass;
                String pluginMainClass;
                Attributes attributes;
                Manifest manifest = null;
                try (JarFile jar = null;){
                    jar = new JarFile(plugin, false);
                    manifest = jar.getManifest();
                }
                if (manifest == null || (attributes = manifest.getMainAttributes()) == null || (pluginMainClass = attributes.getValue("Red5-Plugin-Main-Class")) == null || pluginMainClass.length() <= 0) continue;
                ClassLoader loader = common.getClassLoader();
                String pluginMainMethod = null;
                try {
                    pluginClass = Class.forName(pluginMainClass, true, loader);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                try {
                    pluginMainMethod = attributes.getValue("Red5-Plugin-Main-Method");
                    if (pluginMainMethod == null || pluginMainMethod.length() <= 0) {
                        red5Plugin = (IRed5Plugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    } else {
                        Method method = pluginClass.getMethod(pluginMainMethod, null);
                        Object o = method.invoke(null, (Object[])null);
                        if (o != null && o instanceof IRed5Plugin) {
                            red5Plugin = (IRed5Plugin)o;
                        }
                    }
                    if (red5Plugin != null) {
                        red5Plugin.setApplicationContext(this.applicationContext);
                        red5Plugin.setServer(server);
                        PluginRegistry.register(red5Plugin);
                        red5Plugin.doStart();
                    }
                    log.info("Loaded plugin: {}", (Object)pluginMainClass);
                }
                catch (Throwable t) {
                    log.warn("Error loading plugin: {}; Method: {}", (Object)pluginMainClass, (Object)pluginMainMethod);
                    log.error("", t);
                }
            }
        } else {
            log.info("Plugins directory cannot be accessed or doesnt exist");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        log.trace("Setting application context");
        this.applicationContext = applicationContext;
    }
}

