/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.consumer;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IPushableConsumer;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.BytesRead;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.FlexStreamSend;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.stream.message.RTMPMessage;
import org.red5.server.stream.message.ResetMessage;
import org.red5.server.stream.message.StatusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConsumer
implements IPushableConsumer,
IPipeConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(ConnectionConsumer.class);
    public static final String KEY = ConnectionConsumer.class.getName();
    private RTMPConnection conn;
    private Channel video;
    private Channel audio;
    private Channel data;
    private int chunkSize = 1024;
    private AtomicBoolean chunkSizeSent = new AtomicBoolean(false);

    public ConnectionConsumer(RTMPConnection conn, Channel videoChannel, Channel audioChannel, Channel dataChannel) {
        log.debug("Channel ids - video: {} audio: {} data: {}", new Object[]{videoChannel, audioChannel, dataChannel});
        this.conn = conn;
        this.video = videoChannel;
        this.audio = audioChannel;
        this.data = dataChannel;
    }

    public ConnectionConsumer(Channel videoChannel, Channel audioChannel, Channel dataChannel) {
        this.video = videoChannel;
        this.audio = audioChannel;
        this.data = dataChannel;
    }

    @Override
    public void pushMessage(IPipe pipe, IMessage message) {
        if (!(message instanceof ResetMessage)) {
            if (message instanceof StatusMessage) {
                StatusMessage statusMsg = (StatusMessage)message;
                this.data.sendStatus(statusMsg.getBody());
            } else if (message instanceof RTMPMessage) {
                this.sendChunkSize();
                RTMPMessage rtmpMsg = (RTMPMessage)message;
                IRTMPEvent msg = rtmpMsg.getBody();
                int eventTime = msg.getTimestamp();
                log.debug("Message timestamp: {}", (Object)eventTime);
                if (eventTime < 0) {
                    eventTime += eventTime * -1;
                    log.debug("Message has negative timestamp, flipping it to positive: {}", (Object)Integer.MIN_VALUE, (Object)eventTime);
                    msg.setTimestamp(eventTime);
                }
                byte dataType = msg.getDataType();
                if (log.isTraceEnabled()) {
                    log.trace("Data type: {} source type: {}", (Object)dataType, (Object)((BaseEvent)msg).getSourceType());
                }
                Header header = Optional.ofNullable(msg.getHeader()).orElse(new Header());
                header.setTimerBase(eventTime);
                IoBuffer buf = null;
                switch (dataType) {
                    case 22: {
                        this.data.write(msg);
                        break;
                    }
                    case 8: {
                        buf = ((AudioData)msg).getData();
                        if (buf != null) {
                            AudioData audioData = new AudioData(buf.asReadOnlyBuffer());
                            audioData.setHeader(header);
                            audioData.setTimestamp(header.getTimer());
                            audioData.setSourceType(((AudioData)msg).getSourceType());
                            this.audio.write(audioData);
                            break;
                        }
                        log.warn("Audio data was not found");
                        break;
                    }
                    case 9: {
                        buf = ((VideoData)msg).getData();
                        if (buf != null) {
                            VideoData videoData = new VideoData(buf.asReadOnlyBuffer());
                            videoData.setHeader(header);
                            videoData.setTimestamp(header.getTimer());
                            videoData.setSourceType(((VideoData)msg).getSourceType());
                            this.video.write(videoData);
                            break;
                        }
                        log.warn("Video data was not found");
                        break;
                    }
                    case 4: {
                        Ping ping = (Ping)msg;
                        ping.setHeader(header);
                        this.conn.ping(ping);
                        break;
                    }
                    case 18: {
                        if (log.isTraceEnabled()) {
                            log.trace("Meta data: {}", (Object)((Notify)msg));
                        }
                        Notify notify = (Notify)msg;
                        notify.setHeader(header);
                        notify.setTimestamp(header.getTimer());
                        this.data.write(notify);
                        break;
                    }
                    case 15: {
                        FlexStreamSend send = null;
                        send = msg instanceof FlexStreamSend ? (FlexStreamSend)msg : new FlexStreamSend(((Notify)msg).getData().asReadOnlyBuffer());
                        send.setHeader(header);
                        send.setTimestamp(header.getTimer());
                        this.data.write(send);
                        break;
                    }
                    case 3: {
                        BytesRead bytesRead = (BytesRead)msg;
                        bytesRead.setHeader(header);
                        bytesRead.setTimestamp(header.getTimer());
                        this.conn.getChannel(2).write(bytesRead);
                        break;
                    }
                    default: {
                        this.data.write(msg);
                        break;
                    }
                }
            } else {
                log.debug("Unhandled push message: {}", (Object)message);
                if (log.isTraceEnabled()) {
                    Class<?> clazz = message.getClass();
                    log.trace("Class info - name: {} declaring: {} enclosing: {}", new Object[]{clazz.getName(), clazz.getDeclaringClass(), clazz.getEnclosingClass()});
                }
            }
        }
    }

    @Override
    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        if (event.getType().equals((Object)PipeConnectionEvent.EventType.PROVIDER_DISCONNECT)) {
            this.closeChannels();
        }
    }

    @Override
    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
        if ("ConnectionConsumer".equals(oobCtrlMsg.getTarget())) {
            int newSize;
            String serviceName = oobCtrlMsg.getServiceName();
            log.trace("Service name: {}", (Object)serviceName);
            if ("pendingCount".equals(serviceName)) {
                oobCtrlMsg.setResult(this.conn.getPendingMessages());
            } else if ("pendingVideoCount".equals(serviceName)) {
                IClientStream stream = this.conn.getStreamByChannelId(this.video.getId());
                if (stream != null) {
                    oobCtrlMsg.setResult(this.conn.getPendingVideoMessages(stream.getStreamId()));
                } else {
                    oobCtrlMsg.setResult(0L);
                }
            } else if ("writeDelta".equals(serviceName)) {
                long maxStream = 122880L;
                oobCtrlMsg.setResult(new Long[]{this.conn.getWrittenBytes() - this.conn.getClientBytesRead(), maxStream / 2L});
            } else if ("chunkSize".equals(serviceName) && (newSize = ((Integer)oobCtrlMsg.getServiceParamMap().get("chunkSize")).intValue()) != this.chunkSize) {
                this.chunkSize = newSize;
                this.chunkSizeSent.set(false);
                this.sendChunkSize();
            }
        }
    }

    private void sendChunkSize() {
        if (this.chunkSizeSent.compareAndSet(false, true)) {
            log.debug("Sending chunk size: {}", (Object)this.chunkSize);
            ChunkSize chunkSizeMsg = new ChunkSize(this.chunkSize);
            this.conn.getChannel(2).write(chunkSizeMsg);
        }
    }

    private void closeChannels() {
        this.conn.closeChannel(this.video.getId());
        this.conn.closeChannel(this.audio.getId());
        this.conn.closeChannel(this.data.getId());
    }
}

