/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.consumer;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.ITag;

public class ImmutableTag
implements ITag {
    private final byte dataType;
    private int timestamp;
    private final byte[] body;
    private final int previousTagSize;

    private ImmutableTag(byte dataType, int timestamp, byte[] data) {
        this.dataType = dataType;
        this.timestamp = timestamp;
        this.body = data;
        this.previousTagSize = 0;
    }

    private ImmutableTag(byte dataType, int timestamp, byte[] data, int previousTagSize) {
        this.dataType = dataType;
        this.timestamp = timestamp;
        this.body = data;
        this.previousTagSize = previousTagSize;
    }

    public byte getDataType() {
        return this.dataType;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public IoBuffer getData() {
        return IoBuffer.wrap((byte[])this.body);
    }

    public IoBuffer getBody() {
        return IoBuffer.wrap((byte[])this.body);
    }

    public int getBodySize() {
        return this.body.length;
    }

    public int getPreviousTagSize() {
        return this.previousTagSize;
    }

    public void setBody(IoBuffer body) {
    }

    public void setBodySize(int size) {
    }

    public void setDataType(byte datatype) {
    }

    public void setPreviousTagSize(int size) {
    }

    public String toString() {
        String ret = "Data Type\t=" + this.dataType + "\n";
        ret = ret + "Prev. Tag Size\t=" + this.previousTagSize + "\n";
        ret = ret + "Body size\t=" + this.body.length + "\n";
        ret = ret + "timestamp\t=" + this.timestamp + "\n";
        ret = ret + "Body Data\t=" + this.body + "\n";
        return ret;
    }

    public static ImmutableTag build(byte dataType, int timestamp) {
        return ImmutableTag.build(dataType, timestamp, null);
    }

    public static ImmutableTag build(byte dataType, int timestamp, Object data) {
        if (data != null) {
            if (data instanceof IoBuffer) {
                IoBuffer buf = (IoBuffer)data;
                byte[] body = new byte[buf.limit()];
                int pos = buf.position();
                buf.get(body);
                buf.position(pos);
                return new ImmutableTag(dataType, timestamp, body);
            }
            byte[] buf = (byte[])data;
            byte[] body = new byte[buf.length];
            System.arraycopy(buf, 0, body, 0, body.length);
            return new ImmutableTag(dataType, timestamp, body);
        }
        return new ImmutableTag(dataType, timestamp, null);
    }

    public static ImmutableTag build(byte dataType, int timestamp, IoBuffer data) {
        if (data != null) {
            byte[] body = new byte[data.limit()];
            int pos = data.position();
            data.get(body);
            data.position(pos);
            return new ImmutableTag(dataType, timestamp, body);
        }
        return new ImmutableTag(dataType, timestamp, null);
    }

    public static ImmutableTag build(byte dataType, int timestamp, byte[] data, int previousTagSize) {
        if (data != null) {
            byte[] body = new byte[data.length];
            System.arraycopy(data, 0, body, 0, body.length);
            return new ImmutableTag(dataType, timestamp, body, previousTagSize);
        }
        return new ImmutableTag(dataType, timestamp, null, previousTagSize);
    }

    public static ImmutableTag build(byte dataType, int timestamp, IoBuffer data, int previousTagSize) {
        if (data != null) {
            byte[] body = new byte[data.limit()];
            int pos = data.position();
            data.get(body);
            data.position(pos);
            return new ImmutableTag(dataType, timestamp, body, previousTagSize);
        }
        return new ImmutableTag(dataType, timestamp, null, previousTagSize);
    }
}

