/*
 * Decompiled with CFR 0.152.
 */
package org.red5.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusPrinter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.red5.logging.Red5LoggerFactory;

public class LoggingContextSelector
implements ContextSelector {
    private static final Semaphore lock = new Semaphore(1, true);
    private static final ConcurrentMap<String, LoggerContext> contextMap = new ConcurrentHashMap<String, LoggerContext>(6, 0.9f, 1);
    private static LoggerContext DEFAULT_CONTEXT;
    private final ThreadLocal<LoggerContext> threadLocal = new ThreadLocal();
    private volatile String contextConfigFile;
    public static final String KEY_APP_NAME = "application-name";

    public LoggingContextSelector(LoggerContext context) {
        if (DEFAULT_CONTEXT == null) {
            if (Red5LoggerFactory.DEBUG) {
                System.out.printf("Setting default logging context: %s%n", context.getName());
            }
            DEFAULT_CONTEXT = context;
            context.addListener((LoggerContextListener)new Red5LoggerContextListener());
            String defaultContextName = DEFAULT_CONTEXT.getName();
            if (Red5LoggerFactory.DEBUG) {
                System.out.printf("defaultContextName: %s%n", defaultContextName);
            }
            if (defaultContextName == null) {
                DEFAULT_CONTEXT.setName("default");
            }
            DEFAULT_CONTEXT.putProperty(KEY_APP_NAME, "red5");
            this.attachLoggerContext(defaultContextName, DEFAULT_CONTEXT);
            this.threadLocal.set(DEFAULT_CONTEXT);
        } else {
            this.threadLocal.set(context);
        }
    }

    public LoggerContext getLoggerContext() {
        LoggerContext context;
        if (Red5LoggerFactory.DEBUG) {
            System.out.println("getLoggerContext request");
        }
        if ((context = this.threadLocal.get()) != null) {
            if (Red5LoggerFactory.DEBUG) {
                System.out.printf("Thread local found: %s%n", context.getName());
            }
        } else {
            context = DEFAULT_CONTEXT;
        }
        return context;
    }

    public LoggerContext getLoggerContext(String contextName) {
        LoggerContext context;
        block12: {
            if (Red5LoggerFactory.DEBUG) {
                System.out.printf("getLoggerContext request for %s in context map %s%n", contextName, contextMap.containsKey(contextName));
            }
            if ((context = (LoggerContext)contextMap.get(contextName)) == null) {
                try {
                    try {
                        ClassLoader classloader;
                        URL url;
                        lock.acquire();
                        String overrideProperty = System.getProperty("logback.configurationFile");
                        this.contextConfigFile = overrideProperty == null ? String.format("logback-%s.xml", contextName) : String.format(overrideProperty, contextName);
                        if (Red5LoggerFactory.DEBUG) {
                            System.out.printf("Context logger config file: %s%n", this.contextConfigFile);
                        }
                        if ((url = Loader.getResource((String)this.contextConfigFile, (ClassLoader)(classloader = Thread.currentThread().getContextClassLoader()))) != null) {
                            try {
                                JoranConfigurator configurator = new JoranConfigurator();
                                context = new LoggerContext();
                                context.setName(contextName);
                                context.addListener((LoggerContextListener)new Red5LoggerContextListener());
                                context.reset();
                                configurator.setContext((Context)context);
                                configurator.doConfigure(url);
                                context.start();
                            }
                            catch (JoranException e) {
                                StatusPrinter.print((Context)context);
                            }
                            break block12;
                        }
                        if (Red5LoggerFactory.DEBUG) {
                            System.out.printf("Skipping logger context configure for: %s%n", contextName);
                        }
                        context = DEFAULT_CONTEXT;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        lock.release();
                    }
                }
                finally {
                    lock.release();
                }
            }
        }
        return context;
    }

    public LoggerContext getLoggerContext(String contextName, URL url) {
        LoggerContext context;
        block9: {
            if (Red5LoggerFactory.DEBUG) {
                System.out.printf("getLoggerContext request for %s in context map %s url: %s%n", contextName, contextMap.containsKey(contextName), url);
            }
            if ((context = (LoggerContext)contextMap.get(contextName)) == null) {
                try {
                    try {
                        lock.acquire();
                        context = new LoggerContext();
                        context.setName(contextName);
                        context.addListener((LoggerContextListener)new Red5LoggerContextListener());
                        if (url == null) break block9;
                        try {
                            JoranConfigurator configurator = new JoranConfigurator();
                            context.reset();
                            configurator.setContext((Context)context);
                            configurator.doConfigure(url);
                            context.start();
                        }
                        catch (JoranException e) {
                            StatusPrinter.print((Context)context);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        lock.release();
                    }
                }
                finally {
                    lock.release();
                }
            }
        }
        return context;
    }

    public LoggerContext getDefaultLoggerContext() {
        return DEFAULT_CONTEXT;
    }

    public void attachLoggerContext(String contextName, LoggerContext loggerContext) {
        if (Red5LoggerFactory.DEBUG) {
            System.out.printf("Adding logger context: %s to map for context: %s%n", loggerContext.getName(), contextName);
        }
        contextMap.put(contextName, loggerContext);
    }

    public LoggerContext detachLoggerContext(String contextName) {
        return (LoggerContext)contextMap.remove(contextName);
    }

    public List<String> getContextNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(contextMap.keySet());
        return list;
    }

    public void setContextConfigFile(String contextConfigFile) {
        this.contextConfigFile = contextConfigFile;
    }

    public int getCount() {
        return contextMap.size();
    }

    public void setLocalContext(LoggerContext context) {
        this.threadLocal.set(context);
    }

    public void removeLocalContext() {
        this.threadLocal.remove();
    }

    class Red5LoggerContextListener
    implements LoggerContextListener {
        AtomicBoolean started = new AtomicBoolean(false);

        Red5LoggerContextListener() {
        }

        public boolean isResetResistant() {
            return true;
        }

        public void onStart(LoggerContext context) {
            String contextName = context.getName();
            if (Red5LoggerFactory.DEBUG) {
                System.out.printf("onStart: %s%n", contextName);
            }
            if (this.started.compareAndSet(false, true)) {
                LoggingContextSelector.this.attachLoggerContext(contextName, context);
            }
        }

        public void onReset(LoggerContext context) {
            String contextName = context.getName();
            if (Red5LoggerFactory.DEBUG) {
                System.out.printf("onReset: %s%n", contextName);
            }
        }

        public void onStop(LoggerContext context) {
            String contextName = context.getName();
            if (Red5LoggerFactory.DEBUG) {
                System.out.printf("onStop: %s%n", contextName);
            }
            if (this.started.compareAndSet(true, false)) {
                LoggingContextSelector.this.detachLoggerContext(contextName);
            }
        }

        public void onLevelChange(Logger logger, Level level) {
            if (Red5LoggerFactory.DEBUG) {
                System.out.printf("onLevelChange: %s level: %s%n", logger, level);
            }
        }
    }
}

