/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.beans.ConstructorProperties;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.RandomStringUtils;
import org.red5.server.AttributeStore;
import org.red5.server.Client;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.listeners.IConnectionListener;
import org.red5.server.api.scope.IBasicScope;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.scope.Scope;
import org.red5.server.so.SharedObjectScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConnection
extends AttributeStore
implements IConnection {
    private static final Logger log = LoggerFactory.getLogger(BaseConnection.class);
    protected final IConnection.Type type;
    protected volatile IConnection.Duty duty = IConnection.Duty.UNDEFINED;
    protected volatile String host;
    protected volatile String remoteAddress;
    protected volatile List<String> remoteAddresses;
    protected volatile int remotePort;
    protected volatile String path;
    protected final String sessionId;
    protected AtomicLong readMessages = new AtomicLong(0L);
    protected AtomicLong writtenMessages = new AtomicLong(0L);
    protected AtomicLong droppedMessages = new AtomicLong(0L);
    protected volatile Map<String, Object> params = null;
    protected volatile IClient client;
    protected volatile transient Scope scope;
    protected transient CopyOnWriteArraySet<IBasicScope> basicScopes = new CopyOnWriteArraySet();
    private volatile boolean closed;
    protected transient CopyOnWriteArraySet<IConnectionListener> connectionListeners = new CopyOnWriteArraySet();
    private final transient Semaphore writeLock = new Semaphore(1, true);
    private transient ThreadLocal<Number> streamLocal = new ThreadLocal();

    @ConstructorProperties(value={"persistent"})
    public BaseConnection() {
        this(IConnection.Type.PERSISTENT.name().toLowerCase());
    }

    @ConstructorProperties(value={"type"})
    public BaseConnection(String type) {
        log.debug("New BaseConnection - type: {}", (Object)type);
        this.type = type != null ? IConnection.Type.valueOf(type.toUpperCase()) : IConnection.Type.UNKNOWN;
        this.sessionId = RandomStringUtils.randomAlphanumeric((int)13).toUpperCase();
        log.debug("Generated session id: {}", (Object)this.sessionId);
    }

    @ConstructorProperties(value={"type", "host", "remoteAddress", "remotePort", "path", "sessionId"})
    public BaseConnection(String type, String host, String remoteAddress, int remotePort, String path, String sessionId, Map<String, Object> params) {
        log.debug("New BaseConnection - type: {} host: {} remoteAddress: {} remotePort: {} path: {} sessionId: {}", new Object[]{type, host, remoteAddress, remotePort, path, sessionId});
        log.debug("Params: {}", params);
        this.type = type != null ? IConnection.Type.valueOf(type.toUpperCase()) : IConnection.Type.UNKNOWN;
        this.host = host;
        this.remoteAddress = remoteAddress;
        this.remoteAddresses = new ArrayList<String>(1);
        this.remoteAddresses.add(remoteAddress);
        this.remoteAddresses = Collections.unmodifiableList(this.remoteAddresses);
        this.remotePort = remotePort;
        this.path = path;
        this.sessionId = sessionId;
        this.params = params;
        log.debug("Generated session id: {}", (Object)sessionId);
    }

    @Override
    public void addListener(IConnectionListener listener) {
        if (this.connectionListeners != null) {
            this.connectionListeners.add(listener);
        }
    }

    @Override
    public void removeListener(IConnectionListener listener) {
        if (this.connectionListeners != null) {
            this.connectionListeners.remove(listener);
        }
    }

    public void notifyPropertyChanged(PropertyChangeEvent evt) {
        if (this.connectionListeners != null) {
            this.connectionListeners.forEach(listener -> listener.propertyChange(evt));
        }
    }

    public Semaphore getLock() {
        return this.writeLock;
    }

    @Override
    public Number getStreamId() {
        return this.streamLocal.get();
    }

    @Override
    public void setStreamId(Number id) {
        this.streamLocal.set(id);
    }

    @Override
    public void initialize(IClient client) {
        if (log.isDebugEnabled()) {
            log.debug("initialize - client: {}", (Object)client);
        }
        if (this.client != null && this.client instanceof Client && !this.client.equals(client)) {
            if (log.isTraceEnabled()) {
                log.trace("Unregistering previous client: {}", (Object)this.client);
            }
            ((Client)this.client).unregister(this, false);
        }
        this.client = client;
        if (this.client instanceof Client && !((Client)this.client).isRegistered(this)) {
            if (log.isTraceEnabled()) {
                log.trace("Registering client: {}", (Object)this.client);
            }
            ((Client)this.client).register(this);
        }
    }

    @Override
    public String getType() {
        return this.type.name().toLowerCase();
    }

    @Override
    public IConnection.Duty getDuty() {
        return this.duty;
    }

    public void setDuty(IConnection.Duty duty) {
        this.duty = duty;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public List<String> getRemoteAddresses() {
        return this.remoteAddresses;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public Map<String, Object> getConnectParams() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    @Override
    public IClient getClient() {
        return this.client;
    }

    @Override
    public boolean isConnected() {
        return this.scope != null;
    }

    @Override
    public boolean connect(IScope newScope) {
        return this.connect(newScope, null);
    }

    @Override
    public boolean connect(IScope newScope, Object[] params) {
        if (log.isDebugEnabled()) {
            log.debug("Connect Params: {}", params);
            if (params != null) {
                Object[] objectArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    Object e = objectArray[n2];
                    log.debug("Param: {}", e);
                    ++n2;
                }
            }
        }
        this.scope = (Scope)newScope;
        return this.scope.connect(this, params);
    }

    @Override
    public IScope getScope() {
        return this.scope;
    }

    @Override
    public void close() {
        if (this.closed) {
            log.debug("Already closed, nothing to do");
            return;
        }
        this.closed = true;
        if (this.scope != null) {
            log.debug("Close, disconnect from scope, and children");
            try {
                for (IBasicScope basicScope : this.basicScopes) {
                    this.unregisterBasicScope(basicScope);
                }
            }
            catch (Exception err) {
                log.error("Error while unregistering basic scopes", (Throwable)err);
            }
            if (this.scope != null) {
                try {
                    this.scope.disconnect(this);
                }
                catch (Exception err) {
                    log.error("Error while disconnecting from scope: {}. {}", (Object)this.scope, (Object)err);
                }
                this.scope = null;
            }
        }
        if (this.client != null && this.client instanceof Client) {
            ((Client)this.client).unregister(this);
        }
        if (this.connectionListeners != null) {
            for (IConnectionListener listener : this.connectionListeners) {
                listener.notifyDisconnected(this);
            }
            this.connectionListeners.clear();
            this.connectionListeners = null;
        }
    }

    @Override
    public void notifyEvent(IEvent event) {
        log.debug("Event notify was not handled: {}", (Object)event);
    }

    @Override
    public void dispatchEvent(IEvent event) {
        log.debug("Event notify was not dispatched: {}", (Object)event);
    }

    @Override
    public boolean handleEvent(IEvent event) {
        return this.getScope().handleEvent(event);
    }

    @Override
    public Iterator<IBasicScope> getBasicScopes() {
        return this.basicScopes.iterator();
    }

    public void registerBasicScope(IBroadcastScope basicScope) {
        this.basicScopes.add(basicScope);
        basicScope.addEventListener(this);
    }

    public void registerBasicScope(SharedObjectScope basicScope) {
        this.basicScopes.add(basicScope);
        basicScope.addEventListener(this);
    }

    public void unregisterBasicScope(IBasicScope basicScope) {
        if (basicScope instanceof IBroadcastScope || basicScope instanceof SharedObjectScope) {
            this.basicScopes.remove(basicScope);
            basicScope.removeEventListener(this);
        }
    }

    @Override
    public abstract long getReadBytes();

    @Override
    public abstract long getWrittenBytes();

    @Override
    public long getReadMessages() {
        return this.readMessages.get();
    }

    @Override
    public long getWrittenMessages() {
        return this.writtenMessages.get();
    }

    @Override
    public long getDroppedMessages() {
        return this.droppedMessages.get();
    }

    public boolean isReaderIdle() {
        return false;
    }

    public boolean isWriterIdle() {
        return false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public long getPendingMessages() {
        return 0L;
    }

    public long getPendingVideoMessages(Number streamId) {
        return 0L;
    }

    @Override
    public long getClientBytesRead() {
        return 0L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 * this.sessionId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.sessionId.equals(((BaseConnection)obj).getSessionId());
    }
}

