/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.api.persistence;

import java.lang.reflect.Constructor;
import org.red5.server.api.persistence.IPersistenceStore;
import org.springframework.core.io.support.ResourcePatternResolver;

public class PersistenceUtils {
    private static Constructor<?> getPersistenceStoreConstructor(Class<?> theClass, Class<?>[] interfaces) throws Exception {
        Constructor<?> constructor = null;
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            try {
                constructor = theClass.getConstructor(interfaceClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (constructor != null || (constructor = PersistenceUtils.getPersistenceStoreConstructor(theClass, interfaceClass.getInterfaces())) != null) break;
            ++n2;
        }
        return constructor;
    }

    public static IPersistenceStore getPersistenceStore(ResourcePatternResolver resolver, String className) throws Exception {
        Class<?> persistenceClass = Class.forName(className);
        Constructor<?> constructor = PersistenceUtils.getPersistenceStoreConstructor(persistenceClass, resolver.getClass().getInterfaces());
        if (constructor == null) {
            Class<?> superClass = resolver.getClass().getSuperclass();
            while (superClass != null) {
                constructor = PersistenceUtils.getPersistenceStoreConstructor(persistenceClass, superClass.getInterfaces());
                if (constructor != null) break;
                superClass = superClass.getSuperclass();
            }
        }
        if (constructor == null) {
            throw new NoSuchMethodException();
        }
        return (IPersistenceStore)constructor.newInstance(resolver);
    }
}

