/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.persistence;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.red5.server.api.persistence.IPersistable;
import org.red5.server.api.persistence.IPersistenceStore;
import org.red5.server.api.scope.IScope;
import org.red5.server.util.ScopeUtils;
import org.springframework.core.io.support.ResourcePatternResolver;

public class RamPersistence
implements IPersistenceStore {
    protected static final String PERSISTENCE_NO_NAME = "__null__";
    protected ConcurrentMap<String, IPersistable> objects = new ConcurrentHashMap<String, IPersistable>();
    protected ResourcePatternResolver resources;

    public RamPersistence(ResourcePatternResolver resources) {
        this.resources = resources;
    }

    public RamPersistence(IScope scope) {
        this((ResourcePatternResolver)ScopeUtils.findApplication(scope));
    }

    protected String getObjectName(String id) {
        String result = id.substring(id.lastIndexOf(47) + 1);
        if (result.equals(PERSISTENCE_NO_NAME)) {
            result = null;
        }
        return result;
    }

    protected String getObjectPath(String id, String name) {
        if ((id = id.substring(id.indexOf(47) + 1)).charAt(0) == '/') {
            id = id.substring(1);
        }
        if (id.lastIndexOf(name) <= 0) {
            return id;
        }
        return id.substring(0, id.lastIndexOf(name) - 1);
    }

    protected String getObjectId(IPersistable object) {
        String name;
        String result = object.getType();
        if (object.getPath().charAt(0) != '/') {
            result = String.valueOf(result) + '/';
        }
        if (!(result = String.valueOf(result) + object.getPath()).endsWith("/")) {
            result = String.valueOf(result) + '/';
        }
        if ((name = object.getName()) == null) {
            name = PERSISTENCE_NO_NAME;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return String.valueOf(result) + name;
    }

    @Override
    public boolean save(IPersistable object) {
        String key = this.getObjectId(object);
        this.objects.put(key, object);
        return true;
    }

    @Override
    public IPersistable load(String name) {
        return (IPersistable)this.objects.get(name);
    }

    @Override
    public boolean load(IPersistable obj) {
        return obj.isPersistent();
    }

    @Override
    public boolean remove(IPersistable object) {
        return this.remove(this.getObjectId(object));
    }

    @Override
    public boolean remove(String name) {
        if (!this.objects.containsKey(name)) {
            return false;
        }
        this.objects.remove(name);
        return true;
    }

    @Override
    public Set<String> getObjectNames() {
        return this.objects.keySet();
    }

    @Override
    public Collection<IPersistable> getObjects() {
        return this.objects.values();
    }

    @Override
    public void notifyClose() {
        this.objects.clear();
    }
}

