/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.scheduling;

import java.util.Map;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDKSchedulingServiceJob
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(JDKSchedulingServiceJob.class);
    private final Map<String, Object> jobDataMap;
    private final String jobName;
    private final boolean autoRemove;

    public JDKSchedulingServiceJob(String name, Map<String, Object> dataMap) {
        this.jobDataMap = dataMap;
        log.debug("Set job data map: {}", this.jobDataMap);
        this.jobName = name;
        this.autoRemove = true;
    }

    public JDKSchedulingServiceJob(String name, Map<String, Object> dataMap, boolean autoRemove) {
        this.jobDataMap = dataMap;
        log.debug("Set job data map: {}", this.jobDataMap);
        this.jobName = name;
        this.autoRemove = autoRemove;
    }

    @Override
    public void run() {
        ISchedulingService service = (ISchedulingService)this.jobDataMap.get("scheduling_service");
        IScheduledJob job = null;
        try {
            try {
                job = (IScheduledJob)this.jobDataMap.get("scheduled_job");
                if (job != null) {
                    job.execute(service);
                }
            }
            catch (Throwable e) {
                if (job != null) {
                    log.warn("Job {} execution failed", (Object)job.toString(), (Object)e);
                }
                if (this.autoRemove) {
                    service.removeScheduledJob(this.jobName);
                }
                this.jobDataMap.clear();
            }
        }
        finally {
            if (this.autoRemove) {
                service.removeScheduledJob(this.jobName);
            }
            this.jobDataMap.clear();
        }
    }
}

