/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.red5.annotations.DeclarePrivate;
import org.red5.annotations.DeclareProtected;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.service.IServiceInvoker;
import org.red5.server.exception.ClientDetailsException;
import org.red5.server.service.IServiceResolver;
import org.red5.server.service.MethodNotFoundException;
import org.red5.server.service.NotAllowedException;
import org.red5.server.service.ReflectionUtils;
import org.red5.server.service.ServiceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInvoker
implements IServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(ServiceInvoker.class);
    public static final String SERVICE_NAME = "serviceInvoker";
    private Set<IServiceResolver> serviceResolvers = new HashSet<IServiceResolver>();

    public void setServiceResolvers(Set<IServiceResolver> resolvers) {
        this.serviceResolvers = resolvers;
    }

    private Object getServiceHandler(IScope scope, String serviceName) {
        Object service = scope.getHandler();
        if (serviceName == null || serviceName.equals("")) {
            log.trace("No service requested, return application scope handler: {}", service);
            return service;
        }
        for (IServiceResolver resolver : this.serviceResolvers) {
            service = resolver.resolveService(scope, serviceName);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    @Override
    public boolean invoke(IServiceCall call, IScope scope) {
        String serviceName = call.getServiceName();
        log.trace("Service name {}", (Object)serviceName);
        Object service = this.getServiceHandler(scope, serviceName);
        if (service == null) {
            call.setException(new ServiceNotFoundException(serviceName));
            call.setStatus((byte)16);
            log.warn("Service not found: {}", (Object)serviceName);
            return false;
        }
        log.trace("Service found: {}", (Object)serviceName);
        return this.invoke(call, service);
    }

    @Override
    public boolean invoke(IServiceCall call, Object service) {
        Object[] argsWithConnection;
        Object[] args;
        IConnection conn = Red5.getConnectionLocal();
        String methodName = call.getServiceMethodName();
        log.debug("Service: {} name: {} method: {}", new Object[]{service, call.getServiceName(), methodName});
        if (methodName.charAt(0) == '@') {
            log.debug("Method name contained an illegal prefix, it will be removed: {}", (Object)methodName);
            methodName = methodName.substring(1);
        }
        if ((args = call.getArguments()) != null) {
            argsWithConnection = new Object[args.length + 1];
            argsWithConnection[0] = conn;
            int i = 0;
            while (i < args.length) {
                log.debug("{} => {}", (Object)i, args[i]);
                if (args[i] != null) {
                    log.trace("Arg type: {}", (Object)args[i].getClass().getName());
                }
                argsWithConnection[i + 1] = args[i];
                ++i;
            }
        } else {
            argsWithConnection = new Object[]{conn};
        }
        Object[] methodResult = null;
        methodResult = ReflectionUtils.findMethodWithExactParameters(service, methodName, argsWithConnection);
        if (!(methodResult.length != 0 && methodResult[0] != null || (methodResult = ReflectionUtils.findMethodWithExactParameters(service, methodName, args)).length != 0 && methodResult[0] != null || (methodResult = ReflectionUtils.findMethodWithListParameters(service, methodName, argsWithConnection)).length != 0 && methodResult[0] != null || (methodResult = ReflectionUtils.findMethodWithListParameters(service, methodName, args)).length != 0 && methodResult[0] != null)) {
            log.error("Method {} with parameters {} not found in {}", new Object[]{methodName, args == null ? Collections.EMPTY_LIST : Arrays.asList(args), service});
            call.setStatus((byte)17);
            if (args != null && args.length > 0) {
                call.setException(new MethodNotFoundException(methodName, args));
            } else {
                call.setException(new MethodNotFoundException(methodName));
            }
            return false;
        }
        Object result = null;
        Method method = (Method)methodResult[0];
        Object[] params = (Object[])methodResult[1];
        try {
            if (method.isAnnotationPresent(DeclarePrivate.class)) {
                log.debug("Method {} is declared private.", (Object)method);
                throw new NotAllowedException("Access denied, method is private");
            }
            DeclareProtected annotation = method.getAnnotation(DeclareProtected.class);
            if (annotation != null && !conn.getClient().hasPermission(conn, annotation.permission())) {
                log.debug("Client {} doesn't have required permission {} to call {}", new Object[]{conn.getClient(), annotation.permission(), method});
                throw new NotAllowedException("Access denied, method is protected");
            }
            log.debug("Invoking method: {}", (Object)method.toString());
            if (method.getReturnType().equals(Void.TYPE)) {
                log.debug("result: void");
                method.invoke(service, params);
                call.setStatus((byte)4);
            } else {
                result = method.invoke(service, params);
                log.debug("result: {}", result);
                call.setStatus(result == null ? (byte)3 : 2);
            }
            if (call instanceof IPendingServiceCall) {
                ((IPendingServiceCall)call).setResult(result);
            }
        }
        catch (NotAllowedException e) {
            call.setException(e);
            call.setStatus((byte)18);
            return false;
        }
        catch (IllegalAccessException accessEx) {
            call.setException(accessEx);
            call.setStatus((byte)18);
            log.error("Error executing call: {}", (Object)call, (Object)accessEx);
            return false;
        }
        catch (InvocationTargetException invocationEx) {
            call.setException(invocationEx);
            call.setStatus((byte)19);
            if (!(invocationEx.getCause() instanceof ClientDetailsException)) {
                log.error("Error executing call: {}", (Object)call, (Object)invocationEx);
            }
            return false;
        }
        catch (Exception ex) {
            call.setException(ex);
            call.setStatus((byte)20);
            log.error("Error executing call: {}", (Object)call, (Object)ex);
            return false;
        }
        return true;
    }
}

