/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.so;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.red5.server.BaseConnection;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.IContext;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventListener;
import org.red5.server.api.persistence.IPersistenceStore;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.api.so.ISharedObject;
import org.red5.server.api.so.ISharedObjectBase;
import org.red5.server.api.so.ISharedObjectListener;
import org.red5.server.api.so.ISharedObjectSecurity;
import org.red5.server.api.so.ISharedObjectSecurityService;
import org.red5.server.api.statistics.ISharedObjectStatistics;
import org.red5.server.net.rtmp.status.StatusCodes;
import org.red5.server.scope.BasicScope;
import org.red5.server.service.ReflectionUtils;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.ISharedObjectMessage;
import org.red5.server.so.SharedObject;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedObjectScope
extends BasicScope
implements ISharedObject,
StatusCodes {
    private Logger log = LoggerFactory.getLogger(SharedObjectScope.class);
    private transient CopyOnWriteArraySet<ISharedObjectListener> serverListeners = new CopyOnWriteArraySet();
    private transient ConcurrentMap<String, Object> handlers = new ConcurrentHashMap<String, Object>(1, 0.9f, 1);
    private transient CopyOnWriteArraySet<ISharedObjectSecurity> securityHandlers = new CopyOnWriteArraySet();
    protected AtomicReference<SharedObject> so = new AtomicReference<Object>(null);
    private long lingerPeriod = 5000L;
    private String lingerJobName;

    public SharedObjectScope(IScope parent, String name, boolean persistent, IPersistenceStore store) {
        super(parent, ScopeType.SHARED_OBJECT, name, persistent);
        String path = parent.getContextPath();
        if ("".equals(path) || path.charAt(0) != '/') {
            path = String.valueOf('/') + path;
        }
        this.log.trace("Path+name: {}/{}", (Object)path, (Object)name);
        SharedObject tmp = null;
        Optional<SharedObject> opt = Optional.ofNullable((SharedObject)store.load((Object)((Object)ScopeType.SHARED_OBJECT) + path + '/' + name));
        if (opt.isPresent()) {
            tmp = opt.get();
            tmp.setPath(path);
        } else {
            tmp = new SharedObject(name, path, persistent, store);
            store.save(tmp);
        }
        this.so.set(tmp);
    }

    @Override
    public void acquire() {
        this.so.get().acquire();
    }

    @Override
    public boolean isAcquired() {
        return this.so.get().isAcquired();
    }

    @Override
    public void release() {
        this.so.get().release();
    }

    @Deprecated
    public boolean isLocked() {
        return false;
    }

    @Override
    @Deprecated
    public void setDirty(boolean dirty) {
        this.so.get().setDirty(dirty);
    }

    @Override
    public void setDirty(String name) {
        SharedObject sharedObject = this.so.get();
        sharedObject.setDirty(name);
        Object value = sharedObject.getAttribute(name);
        for (ISharedObjectListener listener : this.serverListeners) {
            listener.onSharedObjectUpdate(this, name, value);
        }
    }

    @Override
    public void beginUpdate() {
        this.so.get().beginUpdate();
    }

    @Override
    public void beginUpdate(IEventListener listener) {
        this.so.get().beginUpdate(listener);
    }

    @Override
    public void endUpdate() {
        this.so.get().endUpdate();
    }

    @Override
    public void registerSharedObjectSecurity(ISharedObjectSecurity handler) {
        this.securityHandlers.add(handler);
    }

    @Override
    public void unregisterSharedObjectSecurity(ISharedObjectSecurity handler) {
        this.securityHandlers.remove(handler);
    }

    @Override
    public Set<ISharedObjectSecurity> getSharedObjectSecurity() {
        return Collections.unmodifiableSet(this.securityHandlers);
    }

    @Override
    public IPersistenceStore getStore() {
        return this.so.get().getStore();
    }

    @Override
    public String getName() {
        return this.so.get().getName();
    }

    @Override
    public String getPath() {
        return this.so.get().getPath();
    }

    public void setPath(String path) {
        this.so.get().setPath(path);
    }

    @Override
    public boolean isPersistent() {
        return this.so.get().isPersistent();
    }

    @Override
    public int getVersion() {
        return this.so.get().getVersion();
    }

    @Override
    public void sendMessage(String handler, List<?> arguments) {
        if (this.so.get() != null) {
            String serviceMethod;
            String serviceName;
            this.so.get().sendMessage(handler, arguments);
            int dotPos = handler.lastIndexOf(46);
            if (dotPos != -1) {
                serviceName = handler.substring(0, dotPos);
                serviceMethod = handler.substring(dotPos + 1);
            } else {
                serviceName = "";
                serviceMethod = handler;
            }
            Object soHandler = this.getServiceHandler(serviceName);
            if (soHandler == null && this.hasParent()) {
                IContext context = this.getParent().getContext();
                String serviceId = null;
                try {
                    serviceId = String.format("%s.%s.soservice", this.getName(), serviceName);
                    if (context.hasBean(serviceId)) {
                        soHandler = context.getBean(serviceId);
                    }
                }
                catch (Exception err) {
                    this.log.debug("No such bean: {}", serviceId);
                }
            }
            if (soHandler != null) {
                Object[] methodResult = ReflectionUtils.findMethodWithExactParameters(soHandler, serviceMethod, arguments);
                if (methodResult.length == 0 || methodResult[0] == null) {
                    methodResult = ReflectionUtils.findMethodWithListParameters(soHandler, serviceMethod, arguments);
                }
                if (methodResult.length > 0 && methodResult[0] != null) {
                    Method method = (Method)methodResult[0];
                    Object[] params = (Object[])methodResult[1];
                    try {
                        method.invoke(soHandler, params);
                    }
                    catch (Exception err) {
                        this.log.error("Error while invoking method {} on shared object handler {}", (Object)new Object[]{serviceMethod, handler}, (Object)err);
                    }
                }
            }
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectSend(this, handler, arguments);
            }
        }
    }

    @Override
    public boolean removeAttribute(String name) {
        boolean success = this.so.get().removeAttribute(name);
        if (success) {
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectDelete(this, name);
            }
        }
        return success;
    }

    @Override
    public boolean removeAttribute(Enum<?> enm) {
        return this.removeAttribute(enm.name());
    }

    @Override
    public void removeAttributes() {
        this.so.get().removeAttributes();
        for (ISharedObjectListener listener : this.serverListeners) {
            listener.onSharedObjectClear(this);
        }
    }

    @Override
    public int size() {
        return this.so.get() != null ? this.so.get().getAttributeNames().size() : 0;
    }

    @Override
    public boolean addEventListener(IEventListener listener) {
        boolean result = super.addEventListener(listener) && this.so.get().register(listener);
        for (ISharedObjectListener soListener : this.serverListeners) {
            soListener.onSharedObjectConnect(this);
        }
        return result;
    }

    @Override
    public boolean removeEventListener(IEventListener listener) {
        this.so.get().unregister(listener);
        if (this.so.get().isAcquired()) {
            this.log.debug("Shared object has been aquired so setting keep on disconnect");
            this.keepOnDisconnect = true;
        }
        boolean result = super.removeEventListener(listener);
        this.serverListeners.forEach(soListener -> soListener.onSharedObjectDisconnect(this));
        if (this.lingerJobName == null) {
            ISchedulingService scheduler = (ISchedulingService)this.getParent().getContext().getBean("schedulingService");
            this.lingerJobName = scheduler.addScheduledOnceJob(this.lingerPeriod, new IScheduledJob(){

                @Override
                public void execute(ISchedulingService service) {
                    if (SharedObjectScope.this.so.get() != null && !SharedObjectScope.this.so.get().isClosed()) {
                        SharedObjectScope.this.so.get().checkRelease();
                    }
                }
            });
        }
        if (this.so.get().isClosed()) {
            this.log.debug("Removing scope: {}", (Object)this);
            this.getParent().removeChildScope(this);
        }
        return result;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.so.get().hasAttribute(name);
    }

    @Override
    public boolean hasAttribute(Enum<?> enm) {
        return this.hasAttribute(enm.name());
    }

    @Override
    public Object getAttribute(String name) {
        return this.so.get().getAttribute(name);
    }

    @Override
    public Object getAttribute(Enum<?> enm) {
        return this.getAttribute(enm.name());
    }

    @Override
    public Object getAttribute(String name, Object value) {
        return this.so.get().getAttribute(name, value);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.so.get().getAttributes();
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.so.get().getAttributeNames();
    }

    @Override
    public Boolean getBoolAttribute(String name) {
        return this.so.get().getBoolAttribute(name);
    }

    @Override
    public Byte getByteAttribute(String name) {
        return this.so.get().getByteAttribute(name);
    }

    @Override
    public Double getDoubleAttribute(String name) {
        return this.so.get().getDoubleAttribute(name);
    }

    @Override
    public Integer getIntAttribute(String name) {
        return this.so.get().getIntAttribute(name);
    }

    @Override
    public List<?> getListAttribute(String name) {
        return this.so.get().getListAttribute(name);
    }

    @Override
    public Long getLongAttribute(String name) {
        return this.so.get().getLongAttribute(name);
    }

    @Override
    public Map<?, ?> getMapAttribute(String name) {
        return this.so.get().getMapAttribute(name);
    }

    @Override
    public Set<?> getSetAttribute(String name) {
        return this.so.get().getSetAttribute(name);
    }

    @Override
    public Short getShortAttribute(String name) {
        return this.so.get().getShortAttribute(name);
    }

    @Override
    public String getStringAttribute(String name) {
        return this.so.get().getStringAttribute(name);
    }

    @Override
    public Map<String, Object> getData() {
        return this.so.get().getData();
    }

    private Set<ISharedObjectSecurity> getSecurityHandlers() {
        ISharedObjectSecurityService security = (ISharedObjectSecurityService)ScopeUtils.getScopeService(this.getParent(), ISharedObjectSecurityService.class);
        if (security == null) {
            return null;
        }
        return security.getSharedObjectSecurity();
    }

    protected boolean isConnectionAllowed() {
        for (ISharedObjectSecurity handler : this.securityHandlers) {
            if (handler.isConnectionAllowed(this)) continue;
            return false;
        }
        Set<ISharedObjectSecurity> handlers = this.getSecurityHandlers();
        if (handlers == null) {
            return true;
        }
        for (ISharedObjectSecurity handler : handlers) {
            if (handler.isConnectionAllowed(this)) continue;
            return false;
        }
        return true;
    }

    protected boolean isWriteAllowed(String key, Object value) {
        for (ISharedObjectSecurity handler : this.securityHandlers) {
            if (handler.isWriteAllowed(this, key, value)) continue;
            return false;
        }
        Set<ISharedObjectSecurity> handlers = this.getSecurityHandlers();
        if (handlers == null) {
            return true;
        }
        for (ISharedObjectSecurity handler : handlers) {
            if (handler.isWriteAllowed(this, key, value)) continue;
            return false;
        }
        return true;
    }

    protected boolean isDeleteAllowed(String key) {
        for (ISharedObjectSecurity handler : this.securityHandlers) {
            if (handler.isDeleteAllowed(this, key)) continue;
            return false;
        }
        Set<ISharedObjectSecurity> handlers = this.getSecurityHandlers();
        if (handlers == null) {
            return true;
        }
        for (ISharedObjectSecurity handler : handlers) {
            if (handler.isDeleteAllowed(this, key)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSendAllowed(String message, List<?> arguments) {
        for (ISharedObjectSecurity handler : this.securityHandlers) {
            if (handler.isSendAllowed(this, message, arguments)) continue;
            return false;
        }
        Set<ISharedObjectSecurity> handlers = this.getSecurityHandlers();
        if (handlers == null) {
            return true;
        }
        for (ISharedObjectSecurity handler : handlers) {
            if (handler.isSendAllowed(this, message, arguments)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispatchEvent(IEvent e) {
        if (e instanceof ISharedObjectMessage || e.getType() == IEvent.Type.SHARED_OBJECT) {
            try {
                IEventListener source = null;
                ISharedObjectMessage msg = (ISharedObjectMessage)e;
                if (msg.hasSource()) {
                    source = msg.getSource();
                    this.beginUpdate(source);
                } else {
                    this.beginUpdate();
                }
                block10: for (ISharedObjectEvent event : msg.getEvents()) {
                    String key = event.getKey();
                    switch (event.getType()) {
                        case SERVER_CONNECT: {
                            if (!this.isConnectionAllowed()) {
                                this.so.get().returnError("SharedObject.NoReadAccess");
                                break;
                            }
                            if (source == null) continue block10;
                            if (source instanceof BaseConnection) {
                                ((BaseConnection)source).registerBasicScope(this);
                                break;
                            }
                            this.addEventListener(source);
                            break;
                        }
                        case SERVER_DISCONNECT: {
                            if (source == null) continue block10;
                            if (source instanceof BaseConnection) {
                                ((BaseConnection)source).unregisterBasicScope(this);
                                break;
                            }
                            this.removeEventListener(source);
                            break;
                        }
                        case SERVER_SET_ATTRIBUTE: {
                            Object value = event.getValue();
                            if (!this.isWriteAllowed(key, value)) {
                                this.so.get().returnError("SharedObject.NoWriteAccess");
                                break;
                            }
                            this.setAttribute(key, value);
                            break;
                        }
                        case SERVER_DELETE_ATTRIBUTE: {
                            if (!this.isDeleteAllowed(key)) {
                                this.so.get().returnError("SharedObject.NoWriteAccess");
                                break;
                            }
                            this.removeAttribute(key);
                            break;
                        }
                        case SERVER_SEND_MESSAGE: {
                            List arguments = (List)event.getValue();
                            if (this.isSendAllowed(key, arguments)) {
                                this.sendMessage(key, arguments);
                                break;
                            }
                            this.log.debug("Send is not allowed for {}", (Object)key);
                            break;
                        }
                        default: {
                            this.log.warn("Unknown SO event: {}", (Object)event.getType());
                        }
                    }
                }
            }
            finally {
                this.endUpdate();
            }
        } else {
            super.dispatchEvent(e);
        }
    }

    @Override
    public boolean setAttribute(String name, Object value) {
        boolean success = this.so.get().setAttribute(name, value);
        if (success) {
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectUpdate(this, name, value);
            }
        }
        return success;
    }

    @Override
    public boolean setAttribute(Enum<?> enm, Object value) {
        return this.setAttribute(enm.name(), value);
    }

    @Override
    public boolean setAttributes(IAttributeStore values) {
        boolean success = this.so.get().setAttributes(values);
        if (success) {
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectUpdate((ISharedObjectBase)this, values);
            }
        }
        return success;
    }

    @Override
    public boolean setAttributes(Map<String, Object> values) {
        boolean success = this.so.get().setAttributes(values);
        if (success) {
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectUpdate((ISharedObjectBase)this, values);
            }
        }
        return success;
    }

    @Override
    public void addSharedObjectListener(ISharedObjectListener listener) {
        this.serverListeners.add(listener);
    }

    @Override
    public void removeSharedObjectListener(ISharedObjectListener listener) {
        this.serverListeners.remove(listener);
    }

    @Override
    public void registerServiceHandler(Object handler) {
        this.registerServiceHandler("", handler);
    }

    @Override
    public void registerServiceHandler(String name, Object handler) {
        if (name == null) {
            name = "";
        }
        this.handlers.put(name, handler);
    }

    public void unregisterServiceHandler() {
        this.unregisterServiceHandler("");
    }

    @Override
    public void unregisterServiceHandler(String name) {
        if (name == null) {
            name = "";
        }
        this.handlers.remove(name);
    }

    @Override
    public Object getServiceHandler(String name) {
        if (name == null) {
            name = "";
        }
        return this.handlers.get(name);
    }

    @Override
    public Set<String> getServiceHandlerNames() {
        return Collections.unmodifiableSet(this.handlers.keySet());
    }

    @Override
    public boolean clear() {
        boolean success = this.so.get().clear();
        if (success) {
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectClear(this);
            }
        }
        return success;
    }

    @Override
    public void close() {
        this.so.get().close();
        this.parent.removeChildScope(this);
        this.so.set(null);
    }

    @Override
    public ISharedObjectStatistics getStatistics() {
        return this.so.get();
    }

    public String toString() {
        SharedObject sharedObject = this.so.get();
        if (sharedObject != null) {
            return "SharedObjectScope: " + sharedObject.getName() + " version: " + sharedObject.getVersion() + " created: " + sharedObject.getCreationTime();
        }
        return "SharedObjectScope";
    }
}

