/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.red5.io.utils.ObjectMap;
import org.red5.server.BaseConnection;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.service.IStreamSecurityService;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.IPlaylistSubscriberStream;
import org.red5.server.api.stream.ISingleItemSubscriberStream;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.red5.server.api.stream.IStreamPlaybackSecurity;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.red5.server.api.stream.IStreamService;
import org.red5.server.api.stream.ISubscriberStream;
import org.red5.server.api.stream.OperationNotSupportedException;
import org.red5.server.api.stream.support.DynamicPlayItem;
import org.red5.server.api.stream.support.SimplePlayItem;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.stream.IProviderService;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamService
implements IStreamService {
    private static Logger log = LoggerFactory.getLogger(StreamService.class);
    protected boolean stripTypePrefix = true;
    protected boolean nameAliasingEnabled;
    private ThreadLocal<Boolean> simplePlayback = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };

    @Override
    public Number createStream() {
        IConnection conn = Red5.getConnectionLocal();
        log.trace("createStream connection: {}", (Object)conn.getSessionId());
        if (conn instanceof IStreamCapableConnection) {
            try {
                Number streamId = ((IStreamCapableConnection)conn).reserveStreamId();
                if (log.isTraceEnabled()) {
                    log.trace("Stream id: {} created for {}", (Object)streamId, (Object)conn.getSessionId());
                }
                return streamId;
            }
            catch (IndexOutOfBoundsException e) {
                log.error("Unable to create stream", (Throwable)e);
            }
        }
        return -1;
    }

    @Override
    public Number createStream(Number streamId) {
        IConnection conn = Red5.getConnectionLocal();
        log.trace("createStream stream id: {} connection: {}", (Object)streamId, (Object)conn.getSessionId());
        if (conn instanceof IStreamCapableConnection) {
            try {
                streamId = streamId.intValue() > 0 ? (Number)((IStreamCapableConnection)conn).reserveStreamId(streamId) : (Number)((IStreamCapableConnection)conn).reserveStreamId();
                if (log.isTraceEnabled()) {
                    log.trace("Stream id: {} created for {}", (Object)streamId, (Object)conn.getSessionId());
                }
                return streamId;
            }
            catch (IndexOutOfBoundsException e) {
                log.error("Unable to create stream", (Throwable)e);
            }
        }
        return -1;
    }

    @Override
    public void initStream(Number streamId) {
        IConnection conn = Red5.getConnectionLocal();
        log.info("initStream stream id: {} current stream id: {} connection: {}", new Object[]{streamId, conn.getStreamId(), conn.getSessionId()});
        if (conn instanceof IStreamCapableConnection) {
            ((IStreamCapableConnection)conn).reserveStreamId(streamId);
            IClientStream stream = ((IStreamCapableConnection)conn).getStreamById(streamId);
            if (stream != null) {
                if (stream instanceof IClientBroadcastStream) {
                    IClientBroadcastStream bs = (IClientBroadcastStream)stream;
                    IBroadcastScope bsScope = this.getBroadcastScope(conn.getScope(), bs.getPublishedName());
                    if (bsScope != null && conn instanceof BaseConnection) {
                        ((BaseConnection)conn).unregisterBasicScope(bsScope);
                    }
                }
                stream.close();
            }
            ((IStreamCapableConnection)conn).deleteStreamById(streamId);
        } else {
            log.warn("ERROR in initStream, connection is not stream capable");
        }
    }

    @Override
    public void initStream(Number streamId, Object idk) {
        log.info("initStream parameter #2: {}", idk);
        this.initStream(streamId);
    }

    public void closeStream() {
        IConnection conn = Red5.getConnectionLocal();
        this.closeStream(conn, conn.getStreamId());
    }

    @Override
    public void closeStream(IConnection conn, Number streamId) {
        log.info("closeStream  stream id: {} connection: {}", (Object)streamId, (Object)conn.getSessionId());
        if (conn instanceof IStreamCapableConnection) {
            IStreamCapableConnection scConn = (IStreamCapableConnection)conn;
            IClientStream stream = scConn.getStreamById(streamId);
            if (stream != null) {
                if (stream instanceof IClientBroadcastStream) {
                    IClientBroadcastStream bs = (IClientBroadcastStream)stream;
                    IBroadcastScope bsScope = this.getBroadcastScope(conn.getScope(), bs.getPublishedName());
                    if (bsScope != null && conn instanceof BaseConnection) {
                        ((BaseConnection)conn).unregisterBasicScope(bsScope);
                    }
                }
                stream.close();
                scConn.deleteStreamById(streamId);
                if (!(stream instanceof IClientBroadcastStream)) {
                    StreamService.sendNetStreamStatus(conn, "NetStream.Play.Stop", "Stream closed by server", stream.getName(), "status", streamId);
                }
            } else {
                log.info("Stream not found - streamId: {} connection: {}", (Object)streamId, (Object)conn.getSessionId());
            }
        } else {
            log.warn("Connection is not instance of IStreamCapableConnection: {}", (Object)conn);
        }
    }

    @Override
    public void releaseStream(String streamName) {
    }

    @Override
    public void deleteStream(Number streamId) {
        IConnection conn = Red5.getConnectionLocal();
        if (conn instanceof IStreamCapableConnection) {
            IStreamCapableConnection streamConn = (IStreamCapableConnection)conn;
            this.deleteStream(streamConn, streamId);
        }
    }

    @Override
    public void deleteStream(IStreamCapableConnection conn, Number streamId) {
        IClientStream stream = conn.getStreamById(streamId);
        if (stream != null) {
            if (stream instanceof IClientBroadcastStream) {
                IClientBroadcastStream bs = (IClientBroadcastStream)stream;
                IBroadcastScope bsScope = this.getBroadcastScope(conn.getScope(), bs.getPublishedName());
                if (bsScope != null && conn instanceof BaseConnection) {
                    ((BaseConnection)((Object)conn)).unregisterBasicScope(bsScope);
                }
            }
            stream.close();
        }
        conn.unreserveStreamId(streamId);
    }

    @Override
    public void pauseRaw(Boolean pausePlayback, int position) {
        log.trace("pauseRaw - pausePlayback:{} position:{}", (Object)pausePlayback, (Object)position);
        this.pause(pausePlayback, position);
    }

    @Override
    public void pause(Boolean pausePlayback, int position) {
        Number streamId;
        IStreamCapableConnection streamConn;
        IClientStream stream;
        IConnection conn = Red5.getConnectionLocal();
        if (conn instanceof IStreamCapableConnection && (stream = (streamConn = (IStreamCapableConnection)conn).getStreamById(streamId = conn.getStreamId())) != null && stream instanceof ISubscriberStream) {
            ISubscriberStream subscriberStream = (ISubscriberStream)stream;
            if (pausePlayback == null) {
                pausePlayback = !subscriberStream.isPaused();
            }
            if (pausePlayback.booleanValue()) {
                subscriberStream.pause(position);
            } else {
                subscriberStream.resume(position);
            }
        }
    }

    public void play(String name, int start, int length, Object reset) {
        if (reset instanceof Boolean) {
            this.play(name, start, length, (Boolean)reset);
        } else if (reset instanceof Integer) {
            int value = (Integer)reset;
            switch (value) {
                case 0: {
                    IStreamCapableConnection streamConn = (IStreamCapableConnection)Red5.getConnectionLocal();
                    IPlaylistSubscriberStream playlistStream = (IPlaylistSubscriberStream)streamConn.getStreamById(streamConn.getStreamId());
                    SimplePlayItem item = SimplePlayItem.build(name);
                    playlistStream.addItem(item);
                    this.play(name, start, length, false);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    this.play(name, start, length, true);
                    break;
                }
            }
        } else {
            this.play(name, start, length);
        }
    }

    @Override
    public void play(String name, int start, int length, boolean flushPlaylist) {
        log.debug("Play called - name: {} start: {} length: {} flush playlist: {}", new Object[]{name, start, length, flushPlaylist});
        IConnection conn = Red5.getConnectionLocal();
        HashMap<String, String> params = null;
        if (name != null && name.contains("?")) {
            String[] kvs;
            params = new HashMap<String, String>();
            String queryString = name;
            if (name.charAt(0) != '?') {
                queryString = name.split("\\?")[1];
            } else if (name.charAt(0) == '?') {
                queryString = name.substring(1);
            }
            conn.setAttribute("queryString", (Object)queryString);
            String[] stringArray = kvs = queryString.split("&");
            int n = kvs.length;
            int n2 = 0;
            while (n2 < n) {
                String kv = stringArray[n2];
                String[] split = kv.split("=");
                String key = split[0];
                String value = split[1];
                params.put(key, value);
                conn.setAttribute(key, (Object)value);
                ++n2;
            }
            name = name.substring(0, name.indexOf("?"));
        }
        if (conn instanceof IStreamCapableConnection) {
            IClientStream stream;
            boolean created;
            Number streamId;
            IStreamCapableConnection streamConn;
            block26: {
                IScope scope = conn.getScope();
                streamConn = (IStreamCapableConnection)conn;
                streamId = conn.getStreamId();
                if (StringUtils.isEmpty((CharSequence)name)) {
                    log.warn("The stream name may not be empty");
                    this.sendNSFailed(streamConn, "NetStream.Failed", "The stream name may not be empty.", name, streamId);
                    return;
                }
                IStreamSecurityService security = (IStreamSecurityService)ScopeUtils.getScopeService(scope, IStreamSecurityService.class);
                if (security != null) {
                    Set<IStreamPlaybackSecurity> handlers = security.getStreamPlaybackSecurity();
                    for (IStreamPlaybackSecurity handler : handlers) {
                        if (handler.isPlaybackAllowed(scope, name, start, length, flushPlaylist)) continue;
                        log.warn("You are not allowed to play stream {}", (Object)name);
                        this.sendNSFailed(streamConn, "NetStream.Failed", "You are not allowed to play the stream.", name, streamId);
                        return;
                    }
                }
                created = false;
                stream = streamConn.getStreamById(streamId);
                if (stream == null) {
                    if (log.isTraceEnabled()) {
                        log.trace("Stream not found for stream id: {} streams: {}", (Object)streamId, streamConn.getStreamsMap());
                    }
                    try {
                        if (streamId.doubleValue() <= 0.0) {
                            streamId = streamConn.reserveStreamId();
                        }
                        if ((stream = streamConn.newPlaylistSubscriberStream(streamId)) != null) {
                            if (log.isTraceEnabled()) {
                                log.trace("Created stream: {} for stream id: {}", (Object)stream, (Object)streamId);
                            }
                            stream.setBroadcastStreamPublishName(name);
                            stream.start();
                            created = true;
                            break block26;
                        }
                        log.warn("Stream was null for id: {}", (Object)streamId);
                        throw new Exception("Stream creation failed for name: " + name + " id: " + streamId);
                    }
                    catch (Exception e) {
                        log.warn("Unable to start playing stream: {}", (Object)name, (Object)e);
                        this.sendNSFailed(streamConn, "NetStream.Failed", "Unable to start playing stream", name, streamId);
                        return;
                    }
                }
            }
            if (stream instanceof ISubscriberStream) {
                IPlayItem item;
                ISubscriberStream subscriberStream = (ISubscriberStream)stream;
                IPlayItem iPlayItem = item = this.simplePlayback.get() != false ? SimplePlayItem.build(name, start, length) : DynamicPlayItem.build(name, start, length);
                if (subscriberStream instanceof IPlaylistSubscriberStream) {
                    IPlaylistSubscriberStream playlistStream = (IPlaylistSubscriberStream)subscriberStream;
                    if (flushPlaylist) {
                        playlistStream.removeAllItems();
                    }
                    playlistStream.addItem(item);
                } else if (subscriberStream instanceof ISingleItemSubscriberStream) {
                    ISingleItemSubscriberStream singleStream = (ISingleItemSubscriberStream)subscriberStream;
                    singleStream.setPlayItem(item);
                } else {
                    log.warn("Stream instance type: {} is not supported", (Object)subscriberStream.getClass().getName());
                    return;
                }
                try {
                    subscriberStream.play();
                }
                catch (IOException err) {
                    if (created) {
                        stream.close();
                        streamConn.deleteStreamById(streamId);
                    }
                    log.warn("Unable to play stream {}", (Object)name, (Object)err);
                    this.sendNSFailed(streamConn, "NetStream.Failed", err.getMessage(), name, streamId);
                }
            }
        } else {
            log.debug("Connection was not stream capable");
        }
    }

    @Override
    public void play(String name, int start, int length) {
        this.play(name, start, length, true);
    }

    @Override
    public void play(String name, int start) {
        this.play(name, start, -1000, true);
    }

    @Override
    public void play(String name) {
        this.play(name, -2000, -1000, true);
    }

    @Override
    public void play(Boolean dontStop) {
        Number streamId;
        IStreamCapableConnection streamConn;
        IClientStream stream;
        IConnection conn;
        log.debug("Play without stop: {}", (Object)dontStop);
        if (!dontStop.booleanValue() && (conn = Red5.getConnectionLocal()) instanceof IStreamCapableConnection && (stream = (streamConn = (IStreamCapableConnection)conn).getStreamById(streamId = conn.getStreamId())) != null) {
            stream.stop();
        }
    }

    public void play2(String oldStreamName, int start, String transition, int length, double offset, String streamName) {
        HashMap<String, Object> playOptions = new HashMap<String, Object>();
        playOptions.put("oldStreamName", oldStreamName);
        playOptions.put("streamName", streamName);
        playOptions.put("start", start);
        playOptions.put("len", length);
        playOptions.put("offset", offset);
        this.play2(playOptions);
    }

    public void play2(ObjectMap params) {
        log.debug("play2 options: {}", (Object)params);
        HashMap<String, Object> playOptions = new HashMap<String, Object>();
        for (Object key : params.keySet()) {
            String k = key.toString();
            log.trace("Parameter: {}", (Object)k);
            playOptions.put(k, params.get((Object)k));
        }
        this.play2(playOptions);
    }

    public void play2(Map<String, ?> playOptions) {
        log.debug("play2 options: {}", (Object)playOptions.toString());
        String transition = (String)playOptions.get("transition");
        String streamName = (String)playOptions.get("streamName");
        String oldStreamName = (String)playOptions.get("oldStreamName");
        int start = (Integer)playOptions.get("start");
        int length = (Integer)playOptions.get("len");
        IConnection conn = Red5.getConnectionLocal();
        if (conn != null && conn instanceof IStreamCapableConnection) {
            Number streamId = conn.getStreamId();
            IStreamCapableConnection streamConn = (IStreamCapableConnection)conn;
            if ("stop".equals(transition)) {
                this.play(Boolean.FALSE);
            } else if ("reset".equals(transition)) {
                this.play(streamName);
            } else {
                if ("switch".equals(transition)) {
                    try {
                        this.simplePlayback.set(Boolean.FALSE);
                        this.sendNSStatus(conn, "NetStream.Play.Transition", String.format("Transitioning from %s to %s.", oldStreamName, streamName), streamName, streamId);
                        this.play(streamName, start, length);
                    }
                    finally {
                        this.simplePlayback.remove();
                    }
                }
                if ("append".equals(transition) || "appendAndWait".equals(transition)) {
                    IPlaylistSubscriberStream playlistStream = (IPlaylistSubscriberStream)streamConn.getStreamById(streamId);
                    SimplePlayItem item = SimplePlayItem.build(streamName);
                    playlistStream.addItem(item);
                    if ("append".equals(transition)) {
                        this.play(streamName, start, length, false);
                    }
                } else if ("swap".equals(transition)) {
                    IPlaylistSubscriberStream playlistStream = (IPlaylistSubscriberStream)streamConn.getStreamById(streamId);
                    SimplePlayItem item = SimplePlayItem.build(streamName);
                    int itemCount = playlistStream.getItemSize();
                    int i = 0;
                    while (i < itemCount) {
                        IPlayItem tmpItem = playlistStream.getItem(i);
                        if (tmpItem.getName().equals(oldStreamName)) {
                            if (!playlistStream.replace(tmpItem, item)) {
                                log.warn("Playlist item replacement failed");
                                this.sendNSFailed(streamConn, "NetStream.Play.Failed", "Playlist swap failed.", streamName, streamId);
                            }
                            break;
                        }
                        ++i;
                    }
                } else {
                    log.warn("Unhandled transition: {}", (Object)transition);
                    this.sendNSFailed(conn, "NetStream.Failed", "Transition type not supported", streamName, streamId);
                }
            }
        } else {
            log.info("Connection was null ?");
        }
    }

    @Override
    public void publish(Boolean dontStop) {
        IBroadcastStream bs;
        Number streamId;
        IStreamCapableConnection streamConn;
        IClientStream stream;
        IConnection conn;
        if ((dontStop == null || !dontStop.booleanValue()) && (conn = Red5.getConnectionLocal()) instanceof IStreamCapableConnection && (stream = (streamConn = (IStreamCapableConnection)conn).getStreamById(streamId = conn.getStreamId())) instanceof IBroadcastStream && (bs = (IBroadcastStream)((Object)stream)).getPublishedName() != null) {
            IBroadcastScope bsScope = this.getBroadcastScope(conn.getScope(), bs.getPublishedName());
            if (bsScope != null) {
                bsScope.unsubscribe(bs.getProvider());
                if (conn instanceof BaseConnection) {
                    ((BaseConnection)conn).unregisterBasicScope(bsScope);
                }
            }
            bs.close();
            streamConn.deleteStreamById(streamId);
        }
    }

    @Override
    public void publish(String name, String mode) {
        IConnection conn = Red5.getConnectionLocal();
        HashMap<String, String> params = null;
        if (name != null && name.contains("?")) {
            String[] kvs;
            params = new HashMap<String, String>();
            String queryString = name;
            if (name.charAt(0) != '?') {
                queryString = name.split("\\?")[1];
            } else if (name.charAt(0) == '?') {
                queryString = name.substring(1);
            }
            conn.setAttribute("queryString", (Object)queryString);
            String[] stringArray = kvs = queryString.split("&");
            int n = kvs.length;
            int n2 = 0;
            while (n2 < n) {
                String kv = stringArray[n2];
                String[] split = kv.split("=");
                String key = split[0];
                String value = split[1];
                params.put(key, value);
                conn.setAttribute(key, (Object)value);
                ++n2;
            }
            name = name.substring(0, name.indexOf("?"));
            log.debug("publish called with name: {} and mode: {}; query string: {}", new Object[]{name, mode, queryString});
        } else {
            log.debug("publish called with name: {} and mode: {}", (Object)name, (Object)mode);
        }
        if (this.stripTypePrefix) {
            name = name.replaceAll("(mp4\\:|f4v\\:)", "");
            log.debug("publish name (updated): {}", (Object)name);
        }
        if (conn instanceof IStreamCapableConnection) {
            IBroadcastScope bsScope;
            IScope scope = conn.getScope();
            IStreamCapableConnection streamConn = (IStreamCapableConnection)conn;
            Number streamId = conn.getStreamId();
            if (StringUtils.isEmpty((CharSequence)name)) {
                this.sendNSFailed(streamConn, "NetStream.Failed", "The stream name may not be empty.", name, streamId);
                log.error("The stream name may not be empty.");
                return;
            }
            IStreamSecurityService security = (IStreamSecurityService)ScopeUtils.getScopeService(scope, IStreamSecurityService.class);
            if (security != null) {
                Set<IStreamPublishSecurity> handlers = security.getStreamPublishSecurity();
                for (IStreamPublishSecurity handler : handlers) {
                    if (handler.isPublishAllowed(scope, name, mode)) continue;
                    this.sendNSFailed(streamConn, "NetStream.Publish.BadName", "You are not allowed to publish the stream.", name, streamId);
                    log.error("You are not allowed to publish the stream {}", (Object)name);
                    return;
                }
            }
            if ((bsScope = this.getBroadcastScope(scope, name)) != null && !bsScope.getProviders().isEmpty()) {
                this.sendNSFailed(streamConn, "NetStream.Publish.BadName", name, name, streamId);
                log.error("Bad name {}", (Object)name);
                return;
            }
            IClientStream stream = streamConn.getStreamById(streamId);
            if (stream != null) {
                if (!(stream instanceof IClientBroadcastStream)) {
                    log.error("Stream not found or is not instance of IClientBroadcastStream, name: {}, streamId: {}", (Object)name, (Object)streamId);
                    return;
                }
                if (this.nameAliasingEnabled && ((IClientBroadcastStream)stream).aliasRegistered(name)) {
                    this.sendNSFailed(streamConn, "NetStream.Publish.BadName", "You are not allowed to publish the stream, alias exists.", name, streamId);
                    log.error("Bad name {} (alias in-use)", (Object)name);
                    return;
                }
            }
            boolean created = false;
            if (stream == null) {
                stream = streamConn.newBroadcastStream(streamId);
                created = true;
            }
            IClientBroadcastStream bs = (IClientBroadcastStream)stream;
            try {
                IContext context;
                IProviderService providerService;
                bs.setPublishedName(name);
                if (params != null) {
                    bs.setParameters(params);
                }
                if (this.nameAliasingEnabled) {
                    if (params != null && params.containsKey("aliases")) {
                        Stream.of(((String)params.get("aliases")).split(",")).forEach(alias -> {
                            boolean bl = bs.addAlias((String)alias);
                        });
                    }
                    if (params != null && params.containsKey("nameAlias")) {
                        bs.setNameAlias((String)params.get("nameAlias"));
                    }
                }
                if ((providerService = (IProviderService)(context = conn.getScope().getContext()).getBean("providerService")).registerBroadcastStream(conn.getScope(), name, bs)) {
                    bsScope = this.getBroadcastScope(conn.getScope(), name);
                    bsScope.setClientBroadcastStream(bs);
                    if (conn instanceof BaseConnection) {
                        ((BaseConnection)conn).registerBasicScope(bsScope);
                    }
                }
                log.debug("Mode: {}", (Object)mode);
                if ("record".equals(mode)) {
                    bs.start();
                    bs.saveAs(name, false);
                } else if ("append".equals(mode)) {
                    bs.start();
                    bs.saveAs(name, true);
                } else {
                    bs.start();
                }
                bs.startPublishing();
            }
            catch (IOException e) {
                log.warn("Stream I/O exception", (Throwable)e);
                this.sendNSFailed(streamConn, "NetStream.Record.NoAccess", "The file could not be created/written to.", name, streamId);
                bs.close();
                if (created) {
                    streamConn.deleteStreamById(streamId);
                }
            }
            catch (Exception e) {
                log.warn("Exception on publish", (Throwable)e);
            }
        }
    }

    @Override
    public void publish(String name) {
        this.publish(name, "live");
    }

    @Override
    public void seek(int position) {
        Number streamId;
        IStreamCapableConnection streamConn;
        IClientStream stream;
        log.trace("seek - position:{}", (Object)position);
        IConnection conn = Red5.getConnectionLocal();
        if (conn instanceof IStreamCapableConnection && (stream = (streamConn = (IStreamCapableConnection)conn).getStreamById(streamId = conn.getStreamId())) != null && stream instanceof ISubscriberStream) {
            ISubscriberStream subscriberStream = (ISubscriberStream)stream;
            try {
                subscriberStream.seek(position);
            }
            catch (OperationNotSupportedException err) {
                this.sendNSFailed(streamConn, "NetStream.Seek.Failed", "The stream doesn't support seeking.", stream.getName(), streamId);
            }
        }
    }

    @Override
    public void receiveVideo(boolean receive) {
        Number streamId;
        IStreamCapableConnection streamConn;
        IClientStream stream;
        IConnection conn = Red5.getConnectionLocal();
        if (conn instanceof IStreamCapableConnection && (stream = (streamConn = (IStreamCapableConnection)conn).getStreamById(streamId = conn.getStreamId())) != null && stream instanceof ISubscriberStream) {
            ISubscriberStream subscriberStream = (ISubscriberStream)stream;
            subscriberStream.receiveVideo(receive);
        }
    }

    @Override
    public void receiveAudio(boolean receive) {
        Number streamId;
        IStreamCapableConnection streamConn;
        IClientStream stream;
        IConnection conn = Red5.getConnectionLocal();
        if (conn instanceof IStreamCapableConnection && (stream = (streamConn = (IStreamCapableConnection)conn).getStreamById(streamId = conn.getStreamId())) != null && stream instanceof ISubscriberStream) {
            ISubscriberStream subscriberStream = (ISubscriberStream)stream;
            subscriberStream.receiveAudio(receive);
        }
    }

    public IBroadcastScope getBroadcastScope(IScope scope, String name) {
        return scope.getBroadcastScope(name);
    }

    private void sendNSFailed(IConnection conn, String errorCode, String description, String name, Number streamId) {
        StreamService.sendNetStreamStatus(conn, errorCode, description, name, "error", streamId);
    }

    private void sendNSStatus(IConnection conn, String statusCode, String description, String name, Number streamId) {
        StreamService.sendNetStreamStatus(conn, statusCode, description, name, "status", streamId);
    }

    public static void sendNetStreamStatus(IConnection conn, String statusCode, String description, String name, String status, Number streamId) {
        if (!(conn instanceof RTMPConnection)) {
            throw new RuntimeException("Connection is not RTMPConnection: " + conn);
        }
        Status s = new Status(statusCode);
        s.setClientid(streamId);
        s.setDesciption(description);
        s.setDetails(name);
        s.setLevel(status);
        RTMPConnection rtmpConn = (RTMPConnection)conn;
        Optional.ofNullable(rtmpConn.getChannel(rtmpConn.getChannelIdForStreamId(streamId))).ifPresent(c -> c.sendStatus(s));
    }

    public void setStripTypePrefix(boolean stripTypePrefix) {
        this.stripTypePrefix = stripTypePrefix;
    }

    public void setNameAliasingEnabled(boolean nameAliasingEnabled) {
        this.nameAliasingEnabled = nameAliasingEnabled;
    }
}

