/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.consumer;

import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.stream.IStreamData;
import org.red5.server.stream.consumer.ImmutableTag;

public class QueuedMediaData {
    ImmutableTag tag;
    boolean video;
    boolean audio;
    boolean config;
    int codecId;
    VideoData.FrameType frameType;

    public QueuedMediaData(int timestamp, byte dataType) {
        this.tag = ImmutableTag.build(dataType, timestamp);
    }

    public QueuedMediaData(int timestamp, byte dataType, IStreamData streamData) {
        this.tag = ImmutableTag.build(dataType, timestamp, streamData.getData());
        if (streamData instanceof VideoData) {
            this.video = true;
            this.config = ((VideoData)streamData).isConfig();
            this.codecId = ((VideoData)streamData).getCodecId();
            this.frameType = ((VideoData)streamData).getFrameType();
        } else if (streamData instanceof AudioData) {
            this.audio = true;
            this.config = ((AudioData)streamData).isConfig();
        }
    }

    public int getTimestamp() {
        return this.tag.getTimestamp();
    }

    public byte getDataType() {
        return this.tag.getDataType();
    }

    public ImmutableTag getData() {
        return this.tag;
    }

    public boolean isVideo() {
        return this.video;
    }

    public boolean isAudio() {
        return this.audio;
    }

    public boolean isConfig() {
        return this.config;
    }

    public boolean hasData() {
        return this.tag != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.tag.getDataType();
        result = 31 * result + this.tag.getTimestamp();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueuedMediaData other = (QueuedMediaData)obj;
        if (this.tag.getDataType() != other.getDataType()) {
            return false;
        }
        return this.tag.getTimestamp() == other.getTimestamp();
    }

    public void dispose() {
        this.tag = null;
    }
}

